/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.client.rpc;

import com.qq.tars.client.ServantProxyConfig;
import com.qq.tars.client.rpc.ServantClient;
import com.qq.tars.client.rpc.ServantInvokeContext;
import com.qq.tars.rpc.common.InvokeContext;
import com.qq.tars.rpc.common.Url;
import com.qq.tars.rpc.common.support.AbstractInvoker;
import com.qq.tars.support.log.LoggerFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;

public abstract class ServantInvoker<T>
extends AbstractInvoker<T> {
    private static final Logger logger = LoggerFactory.getClientLogger();
    protected final String objName;
    protected final ServantProxyConfig config;
    protected final ServantClient[] clients;
    protected final AtomicInteger index = new AtomicInteger();
    protected final ReentrantLock destroyLock = new ReentrantLock();

    public ServantInvoker(ServantProxyConfig config, Class<T> api, Url url, ServantClient[] clients) {
        super(api, url);
        this.config = config;
        this.objName = config.getSimpleObjectName();
        this.clients = clients;
    }

    @Override
    protected Object doInvoke(InvokeContext inv) throws Throwable {
        return this.doInvokeServant((ServantInvokeContext)inv);
    }

    protected abstract Object doInvokeServant(ServantInvokeContext var1) throws Throwable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        if (super.isDestroyed()) {
            return;
        }
        this.destroyLock.lock();
        try {
            if (super.isDestroyed()) {
                return;
            }
            super.destroy();
            for (ServantClient client : this.clients) {
                try {
                    logger.info("try to close client " + client);
                    client.close();
                    logger.info("closed client " + client);
                }
                catch (Throwable t) {
                    logger.error("error in close " + client, t);
                }
            }
        }
        finally {
            this.destroyLock.unlock();
        }
    }
}

