/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.client.rpc.tars;

import com.qq.tars.client.ServantProxyConfig;
import com.qq.tars.client.cluster.ServantInvokerAliveChecker;
import com.qq.tars.client.rpc.ServantClient;
import com.qq.tars.client.rpc.ServantInvokeContext;
import com.qq.tars.client.rpc.ServantInvoker;
import com.qq.tars.client.rpc.tars.TarsCallbackWrapper;
import com.qq.tars.client.rpc.tars.TarsClientFilterChain;
import com.qq.tars.common.Filter;
import com.qq.tars.common.FilterKind;
import com.qq.tars.context.DistributedContext;
import com.qq.tars.context.DistributedContextManager;
import com.qq.tars.net.client.Callback;
import com.qq.tars.net.core.Request;
import com.qq.tars.protocol.tars.support.TarsMethodInfo;
import com.qq.tars.protocol.tars.support.TarsMethodParameterInfo;
import com.qq.tars.protocol.tars.support.TarsPromiseFutureCallback;
import com.qq.tars.protocol.util.TarsHelper;
import com.qq.tars.rpc.common.Url;
import com.qq.tars.rpc.exc.NotConnectedException;
import com.qq.tars.rpc.exc.ServerException;
import com.qq.tars.rpc.exc.TimeoutException;
import com.qq.tars.rpc.protocol.tars.TarsServantRequest;
import com.qq.tars.rpc.protocol.tars.TarsServantResponse;
import com.qq.tars.rpc.protocol.tars.support.AnalystManager;
import com.qq.tars.server.core.AppContextManager;
import com.qq.tars.support.stat.InvokeStatHelper;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class TarsInvoker<T>
extends ServantInvoker<T> {
    final List<Filter> filters = AppContextManager.getInstance().getAppContext() == null ? null : AppContextManager.getInstance().getAppContext().getFilters(FilterKind.CLIENT);

    public TarsInvoker(ServantProxyConfig config, Class<T> api, Url url, ServantClient[] clients) {
        super(config, api, url, clients);
    }

    @Override
    public void setAvailable(boolean available) {
        super.setAvailable(available);
    }

    @Override
    protected Object doInvokeServant(ServantInvokeContext inv) throws Throwable {
        long begin = System.currentTimeMillis();
        int ret = 0;
        try {
            Method method = this.getApi().getMethod(inv.getMethodName(), inv.getParameterTypes());
            if (inv.isAsync()) {
                this.invokeWithAsync(method, inv.getArguments(), inv.getAttachments());
                Object var6_6 = null;
                return var6_6;
            }
            if (inv.isPromiseFuture()) {
                CompletableFuture completableFuture = this.invokeWithPromiseFuture(method, inv.getArguments(), inv.getAttachments());
                return completableFuture;
            }
            TarsServantResponse response = this.invokeWithSync(method, inv.getArguments(), inv.getAttachments());
            int n = ret = response.getRet() == 0 ? 0 : 1;
            if (response.getRet() != 0) {
                throw ServerException.makeException(response.getRet(), response.getRemark());
            }
            Object object = response.getResult();
            return object;
        }
        catch (Throwable e) {
            ret = e instanceof TimeoutException ? 2 : (e instanceof NotConnectedException ? 3 : 1);
            throw e;
        }
        finally {
            if (inv.isNormal()) {
                this.setAvailable(ServantInvokerAliveChecker.isAlive(this.getUrl(), this.config, ret));
                InvokeStatHelper.getInstance().addProxyStat(this.objName).addInvokeTimeByClient(this.config.getMasterName(), this.config.getSlaveName(), this.config.getSlaveSetName(), this.config.getSlaveSetArea(), this.config.getSlaveSetID(), inv.getMethodName(), this.getUrl().getHost(), this.getUrl().getPort(), ret, System.currentTimeMillis() - begin);
            }
        }
    }

    private ServantClient getClient() {
        return this.clients.length == 1 ? this.clients[0] : this.clients[(this.index.getAndIncrement() & Integer.MAX_VALUE) % this.clients.length];
    }

    private TarsServantResponse invokeWithSync(Method method, Object[] args, Map<String, String> context) throws Throwable {
        ServantClient client = this.getClient();
        TarsServantRequest request = new TarsServantRequest(client.getIoSession());
        request.setVersion((short)1);
        request.setMessageType(this.isHashInvoke(context) ? 1 : 0);
        request.setPacketType((byte)0);
        request.setServantName(this.objName);
        request.setFunctionName(method.getName());
        request.setApi(super.getApi());
        request.setMethodInfo(AnalystManager.getInstance().getMethodMap(super.getApi()).get(method));
        request.setMethodParameters(args);
        request.setContext(context);
        request.setInvokeStatus(Request.InvokeStatus.SYNC_CALL);
        TarsServantResponse response = new TarsServantResponse(request.getIoSession());
        response.setRequest(request);
        response.setRequestId(request.getTicketNumber());
        response.setVersion(request.getVersion());
        response.setPacketType(request.getPacketType());
        response.setMessageType(request.getMessageType());
        response.setStatus(request.getStatus());
        response.setRequest(request);
        response.setCharsetName(request.getCharsetName());
        response.setTimeout(request.getTimeout());
        response.setContext(request.getContext());
        DistributedContext distributedContext = DistributedContextManager.getDistributedContext();
        Boolean bDyeing = (Boolean)distributedContext.get("bDyeing");
        if (bDyeing != null && bDyeing.booleanValue()) {
            request.setMessageType(request.getMessageType() | 4);
            HashMap<String, String> status = new HashMap<String, String>();
            String routeKey = (String)distributedContext.get("dyeingKey");
            String fileName = (String)distributedContext.get("dyeFileName");
            status.put("STATUS_DYED_KEY", routeKey == null ? "" : routeKey);
            status.put("STATUS_DYED_FILENAME", fileName == null ? "" : fileName);
            request.setStatus(status);
        }
        TarsClientFilterChain filterChain = new TarsClientFilterChain(this.filters, this.objName, FilterKind.CLIENT, client, Request.InvokeStatus.SYNC_CALL, null);
        filterChain.doFilter(request, response);
        return response;
    }

    private void invokeWithAsync(Method method, Object[] args, Map<String, String> context) throws Throwable {
        ServantClient client = this.getClient();
        TarsServantRequest request = new TarsServantRequest(client.getIoSession());
        request.setVersion((short)1);
        request.setMessageType(this.isHashInvoke(context) ? 1 : 0);
        request.setPacketType((byte)0);
        request.setServantName(this.objName);
        request.setFunctionName(method.getName().replaceAll("async_", ""));
        request.setContext(context);
        TarsMethodInfo methodInfo = AnalystManager.getInstance().getMethodMap(super.getApi()).get(method);
        request.setApi(super.getApi());
        request.setMethodInfo(methodInfo);
        request.setMethodParameters(args);
        request.setInvokeStatus(Request.InvokeStatus.ASYNC_CALL);
        Callback callback = null;
        List<TarsMethodParameterInfo> parameterInfoList = methodInfo.getParametersList();
        for (TarsMethodParameterInfo parameterInfo : parameterInfoList) {
            if (!TarsHelper.isCallback(parameterInfo.getAnnotations())) continue;
            callback = (Callback)args[parameterInfo.getOrder()];
            break;
        }
        if (callback == null) {
            request.setPacketType((byte)1);
        }
        TarsServantResponse response = new TarsServantResponse(client.getIoSession());
        DistributedContext distributedContext = DistributedContextManager.getDistributedContext();
        Boolean bDyeing = (Boolean)distributedContext.get("bDyeing");
        if (bDyeing != null && bDyeing.booleanValue()) {
            request.setMessageType(request.getMessageType() | 4);
            HashMap<String, String> status = new HashMap<String, String>();
            String routeKey = (String)distributedContext.get("dyeingKey");
            String fileName = (String)distributedContext.get("dyeFileName");
            status.put("STATUS_DYED_KEY", routeKey == null ? "" : routeKey);
            status.put("STATUS_DYED_FILENAME", fileName == null ? "" : fileName);
            request.setStatus(status);
        }
        TarsCallbackWrapper tarsCallbackWrapper = callback == null ? null : new TarsCallbackWrapper(this.config, request.getFunctionName(), this.getUrl().getHost(), this.getUrl().getPort(), request.getBornTime(), request, (Callback<TarsServantResponse>)callback, this);
        TarsClientFilterChain filterChain = new TarsClientFilterChain(this.filters, this.objName, FilterKind.CLIENT, client, Request.InvokeStatus.ASYNC_CALL, tarsCallbackWrapper);
        filterChain.doFilter(request, response);
    }

    private <V> CompletableFuture<V> invokeWithPromiseFuture(Method method, Object[] args, Map<String, String> context) throws Throwable {
        ServantClient client = this.getClient();
        TarsServantRequest request = new TarsServantRequest(client.getIoSession());
        request.setVersion((short)1);
        request.setMessageType(this.isHashInvoke(context) ? 1 : 0);
        request.setPacketType((byte)0);
        request.setServantName(this.objName);
        request.setFunctionName(method.getName().replaceAll("promise_", ""));
        request.setContext(context);
        request.setMethodParameters(args);
        CompletableFuture completableFuture = new CompletableFuture();
        TarsMethodInfo methodInfo = AnalystManager.getInstance().getMethodMap(super.getApi()).get(method);
        request.setInvokeStatus(Request.InvokeStatus.FUTURE_CALL);
        request.setApi(super.getApi());
        request.setMethodInfo(methodInfo);
        TarsServantResponse response = new TarsServantResponse(client.getIoSession());
        DistributedContext distributedContext = DistributedContextManager.getDistributedContext();
        Boolean bDyeing = (Boolean)distributedContext.get("bDyeing");
        if (bDyeing != null && bDyeing.booleanValue()) {
            request.setMessageType(request.getMessageType() | 4);
            HashMap<String, String> status = new HashMap<String, String>();
            String routeKey = (String)distributedContext.get("dyeingKey");
            String fileName = (String)distributedContext.get("dyeFileName");
            status.put("STATUS_DYED_KEY", routeKey == null ? "" : routeKey);
            status.put("STATUS_DYED_FILENAME", fileName == null ? "" : fileName);
            request.setStatus(status);
        }
        TarsPromiseFutureCallback callback = new TarsPromiseFutureCallback(this.config, request.getFunctionName(), this.getUrl().getHost(), this.getUrl().getPort(), request.getBornTime(), this, completableFuture);
        TarsClientFilterChain filterChain = new TarsClientFilterChain(this.filters, this.objName, FilterKind.CLIENT, client, Request.InvokeStatus.FUTURE_CALL, callback);
        filterChain.doFilter(request, response);
        return completableFuture;
    }

    private boolean isHashInvoke(Map<String, String> context) {
        return context != null && context.containsKey("tars_hash");
    }
}

