/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.statistic;

import com.alibaba.csp.sentinel.node.DefaultNode;
import com.alibaba.csp.sentinel.slotchain.ProcessorSlotEntryCallback;
import com.alibaba.csp.sentinel.slotchain.ProcessorSlotExitCallback;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class StatisticSlotCallbackRegistry {
    private static final Map<String, ProcessorSlotEntryCallback<DefaultNode>> entryCallbackMap = new ConcurrentHashMap<String, ProcessorSlotEntryCallback<DefaultNode>>();
    private static final Map<String, ProcessorSlotExitCallback> exitCallbackMap = new ConcurrentHashMap<String, ProcessorSlotExitCallback>();

    public static void clearEntryCallback() {
        entryCallbackMap.clear();
    }

    public static void clearExitCallback() {
        exitCallbackMap.clear();
    }

    public static void addEntryCallback(String key, ProcessorSlotEntryCallback<DefaultNode> callback) {
        entryCallbackMap.put(key, callback);
    }

    public static void addExitCallback(String key, ProcessorSlotExitCallback callback) {
        exitCallbackMap.put(key, callback);
    }

    public static ProcessorSlotEntryCallback<DefaultNode> removeEntryCallback(String key) {
        if (key == null) {
            return null;
        }
        return entryCallbackMap.remove(key);
    }

    public static ProcessorSlotExitCallback removeExitCallback(String key) {
        if (key == null) {
            return null;
        }
        return exitCallbackMap.remove(key);
    }

    public static Collection<ProcessorSlotEntryCallback<DefaultNode>> getEntryCallbacks() {
        return entryCallbackMap.values();
    }

    public static Collection<ProcessorSlotExitCallback> getExitCallbacks() {
        return exitCallbackMap.values();
    }

    private StatisticSlotCallbackRegistry() {
    }
}

