/*
 * Decompiled with CFR 0.152.
 */
package io.fury.builder;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import io.fury.Fury;
import io.fury.builder.CodecBuilder;
import io.fury.builder.Generated;
import io.fury.codegen.CodeGenerator;
import io.fury.codegen.CodegenContext;
import io.fury.codegen.Expression;
import io.fury.codegen.ExpressionOptimizer;
import io.fury.codegen.ExpressionUtils;
import io.fury.codegen.ExpressionVisitor;
import io.fury.collection.Collections;
import io.fury.collection.Tuple2;
import io.fury.memory.MemoryBuffer;
import io.fury.resolver.ClassInfo;
import io.fury.resolver.ClassInfoHolder;
import io.fury.resolver.ClassResolver;
import io.fury.resolver.RefResolver;
import io.fury.serializer.CodegenSerializer;
import io.fury.serializer.CompatibleSerializer;
import io.fury.serializer.ObjectSerializer;
import io.fury.serializer.PrimitiveSerializers;
import io.fury.serializer.Serializer;
import io.fury.serializer.Serializers;
import io.fury.serializer.StringSerializer;
import io.fury.serializer.collection.AbstractCollectionSerializer;
import io.fury.serializer.collection.AbstractMapSerializer;
import io.fury.type.TypeUtils;
import io.fury.util.GraalvmSupport;
import io.fury.util.Preconditions;
import io.fury.util.ReflectionUtils;
import io.fury.util.StringUtils;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class BaseObjectCodecBuilder
extends CodecBuilder {
    public static final String BUFFER_NAME = "buffer";
    public static final String REF_RESOLVER_NAME = "refResolver";
    public static final String CLASS_RESOLVER_NAME = "classResolver";
    public static final String POJO_CLASS_TYPE_NAME = "classType";
    public static final String STRING_SERIALIZER_NAME = "strSerializer";
    private static final TypeToken<?> CLASS_RESOLVER_TYPE_TOKEN = TypeToken.of(ClassResolver.class);
    private static final TypeToken<?> STRING_SERIALIZER_TYPE_TOKEN = TypeToken.of(StringSerializer.class);
    private static final TypeToken<?> SERIALIZER_TYPE = TypeToken.of(Serializer.class);
    private static final TypeToken<?> COLLECTION_SERIALIZER_TYPE = TypeToken.of(AbstractCollectionSerializer.class);
    private static final TypeToken<?> MAP_SERIALIZER_TYPE = TypeToken.of(AbstractMapSerializer.class);
    protected final Expression.Reference refResolverRef;
    protected final Expression.Reference classResolverRef = Expression.Reference.fieldRef("classResolver", CLASS_RESOLVER_TYPE_TOKEN);
    protected final Fury fury;
    protected final ClassResolver classResolver;
    protected final Expression.Reference stringSerializerRef;
    private final Map<Class<?>, Expression.Reference> serializerMap = new HashMap();
    private final Map<String, Object> sharedFieldMap = new HashMap<String, Object>();
    protected final Class<?> parentSerializerClass;
    private final Map<String, String> jitCallbackUpdateFields;
    protected LinkedList<String> walkPath = new LinkedList();

    public BaseObjectCodecBuilder(TypeToken<?> beanType, Fury fury, Class<?> parentSerializerClass) {
        super(new CodegenContext(), beanType);
        this.fury = fury;
        this.classResolver = fury.getClassResolver();
        this.parentSerializerClass = parentSerializerClass;
        this.addCommonImports();
        this.ctx.reserveName(REF_RESOLVER_NAME);
        this.ctx.reserveName(CLASS_RESOLVER_NAME);
        TypeToken refResolverTypeToken = TypeToken.of(fury.getRefResolver().getClass());
        this.refResolverRef = Expression.Reference.fieldRef(REF_RESOLVER_NAME, refResolverTypeToken);
        Expression.Invoke refResolverExpr = new Expression.Invoke((Expression)this.furyRef, "getRefResolver", TypeToken.of(RefResolver.class));
        this.ctx.addField(this.ctx.type(refResolverTypeToken), REF_RESOLVER_NAME, (Expression)new Expression.Cast(refResolverExpr, refResolverTypeToken));
        Expression.Invoke classResolverExpr = Expression.Invoke.inlineInvoke((Expression)this.furyRef, "getClassResolver", CLASS_RESOLVER_TYPE_TOKEN, new Expression[0]);
        this.ctx.addField(this.ctx.type(CLASS_RESOLVER_TYPE_TOKEN), CLASS_RESOLVER_NAME, (Expression)classResolverExpr);
        this.ctx.reserveName(STRING_SERIALIZER_NAME);
        this.stringSerializerRef = Expression.Reference.fieldRef(STRING_SERIALIZER_NAME, STRING_SERIALIZER_TYPE_TOKEN);
        this.ctx.addField(this.ctx.type(TypeToken.of(StringSerializer.class)), STRING_SERIALIZER_NAME, (Expression)Expression.Invoke.inlineInvoke((Expression)this.furyRef, "getStringSerializer", CLASS_RESOLVER_TYPE_TOKEN, new Expression[0]));
        this.jitCallbackUpdateFields = new HashMap<String, String>();
    }

    public String codecClassName(Class<?> beanClass) {
        String name = ReflectionUtils.getClassNameWithoutPackage(beanClass).replace("$", "_");
        StringBuilder nameBuilder = new StringBuilder(name);
        if (this.fury.trackingRef()) {
            nameBuilder.append("FuryRef");
        } else {
            nameBuilder.append("Fury");
        }
        nameBuilder.append(this.codecSuffix()).append("Codec");
        nameBuilder.append('_').append(this.fury.getConfig().getConfigHash());
        String classUniqueId = CodeGenerator.getClassUniqueId(beanClass);
        if (StringUtils.isNotBlank(classUniqueId)) {
            nameBuilder.append('_').append(classUniqueId);
        }
        return nameBuilder.toString();
    }

    public String codecQualifiedClassName(Class<?> beanClass) {
        String pkg = CodeGenerator.getPackage(beanClass);
        if (StringUtils.isNotBlank(pkg)) {
            return pkg + "." + this.codecClassName(beanClass);
        }
        return this.codecClassName(beanClass);
    }

    protected abstract String codecSuffix();

    <T> T visitFury(Function<Fury, T> function) {
        return this.fury.getJITContext().asyncVisitFury(function);
    }

    @Override
    public String genCode() {
        this.ctx.setPackage(CodeGenerator.getPackage(this.beanClass));
        String className = this.codecClassName(this.beanClass);
        this.ctx.setClassName(className);
        this.ctx.extendsClasses(this.ctx.type(this.parentSerializerClass));
        this.ctx.reserveName(POJO_CLASS_TYPE_NAME);
        this.ctx.addField(this.ctx.type(Fury.class), "fury");
        Expression encodeExpr = this.buildEncodeExpression();
        Expression decodeExpr = this.buildDecodeExpression();
        String constructorCode = StringUtils.format("super(${fury}, ${cls});\nthis.${fury} = ${fury};\n${fury}.getClassResolver().setSerializerIfAbsent(${cls}, this);\n", "fury", "fury", "cls", POJO_CLASS_TYPE_NAME);
        this.ctx.clearExprState();
        String encodeCode = encodeExpr.genCode(this.ctx).code();
        encodeCode = this.ctx.optimizeMethodCode(encodeCode);
        this.ctx.clearExprState();
        String decodeCode = decodeExpr.genCode(this.ctx).code();
        decodeCode = this.ctx.optimizeMethodCode(decodeCode);
        this.ctx.overrideMethod("write", encodeCode, Void.TYPE, MemoryBuffer.class, BUFFER_NAME, Object.class, "obj");
        this.ctx.overrideMethod("read", decodeCode, Object.class, MemoryBuffer.class, BUFFER_NAME);
        this.registerJITNotifyCallback();
        this.ctx.addConstructor(constructorCode, Fury.class, "fury", Class.class, POJO_CLASS_TYPE_NAME);
        return this.ctx.genCode();
    }

    protected void registerJITNotifyCallback() {
        if (!this.jitCallbackUpdateFields.isEmpty()) {
            StringJoiner stringJoiner = new StringJoiner(", ", "registerJITNotifyCallback(this,", ");\n");
            for (Map.Entry<String, String> entry : this.jitCallbackUpdateFields.entrySet()) {
                stringJoiner.add("\"" + entry.getKey() + "\"");
                stringJoiner.add(entry.getValue());
            }
            this.ctx.addInitCode(stringJoiner.toString());
        }
    }

    protected void addCommonImports() {
        this.ctx.addImports(List.class, Map.class, Set.class);
        this.ctx.addImports(Fury.class, MemoryBuffer.class, this.fury.getRefResolver().getClass());
        this.ctx.addImports(ClassInfo.class, ClassInfoHolder.class, ClassResolver.class);
        this.ctx.addImport(Generated.class);
        this.ctx.addImports(CodegenSerializer.LazyInitBeanSerializer.class, Serializers.EnumSerializer.class);
        this.ctx.addImports(Serializer.class, StringSerializer.class);
        this.ctx.addImports(ObjectSerializer.class, CompatibleSerializer.class);
        this.ctx.addImports(AbstractCollectionSerializer.class, AbstractMapSerializer.class);
    }

    protected Expression serializeFor(Expression inputObject, Expression buffer, TypeToken<?> typeToken) {
        return this.serializeFor(inputObject, buffer, typeToken, false);
    }

    protected Expression serializeFor(Expression inputObject, Expression buffer, TypeToken<?> typeToken, boolean generateNewMethod) {
        return this.serializeFor(inputObject, buffer, typeToken, null, generateNewMethod);
    }

    protected Expression serializeFor(Expression inputObject, Expression buffer, TypeToken<?> typeToken, Expression serializer, boolean generateNewMethod) {
        Class<?> rawType = TypeUtils.getRawType(typeToken);
        if (this.visitFury(fury -> fury.getClassResolver().needToWriteRef(rawType)).booleanValue()) {
            return new Expression.If(ExpressionUtils.not(this.writeRefOrNull(buffer, inputObject)), this.serializeForNotNull(inputObject, buffer, typeToken, serializer, generateNewMethod));
        }
        if (typeToken.isPrimitive()) {
            return this.serializeForNotNull(inputObject, buffer, typeToken, serializer, generateNewMethod);
        }
        Expression.ListExpression action = new Expression.ListExpression(new Expression.Invoke(buffer, "writeByte", new Expression.Literal((byte)0, TypeUtils.PRIMITIVE_BYTE_TYPE)), this.serializeForNotNull(inputObject, buffer, typeToken, serializer, generateNewMethod));
        return new Expression.If(ExpressionUtils.eqNull(inputObject), new Expression.Invoke(buffer, "writeByte", new Expression.Literal((byte)-3, TypeUtils.PRIMITIVE_BYTE_TYPE)), action);
    }

    protected Expression writeRefOrNull(Expression buffer, Expression object) {
        return Expression.Invoke.inlineInvoke((Expression)this.refResolverRef, "writeRefOrNull", TypeUtils.PRIMITIVE_BOOLEAN_TYPE, buffer, object);
    }

    protected Expression serializeForNotNull(Expression inputObject, Expression buffer, TypeToken<?> typeToken) {
        return this.serializeForNotNull(inputObject, buffer, typeToken, null, false);
    }

    private Expression serializeForNotNull(Expression inputObject, Expression buffer, TypeToken<?> typeToken, boolean generateNewMethod) {
        return this.serializeForNotNull(inputObject, buffer, typeToken, null, generateNewMethod);
    }

    private Expression serializeForNotNull(Expression inputObject, Expression buffer, TypeToken<?> typeToken, Expression serializer, boolean generateNewMethod) {
        Class<?> clz = TypeUtils.getRawType(typeToken);
        if (TypeUtils.isPrimitive(clz) || TypeUtils.isBoxed(clz)) {
            if (clz == Byte.TYPE || clz == Byte.class) {
                return new Expression.Invoke(buffer, "writeByte", inputObject);
            }
            if (clz == Boolean.TYPE || clz == Boolean.class) {
                return new Expression.Invoke(buffer, "writeBoolean", inputObject);
            }
            if (clz == Character.TYPE || clz == Character.class) {
                return new Expression.Invoke(buffer, "writeChar", inputObject);
            }
            if (clz == Short.TYPE || clz == Short.class) {
                return new Expression.Invoke(buffer, "writeShort", inputObject);
            }
            if (clz == Integer.TYPE || clz == Integer.class) {
                String func = this.fury.compressInt() ? "writeVarInt" : "writeInt";
                return new Expression.Invoke(buffer, func, inputObject);
            }
            if (clz == Long.TYPE || clz == Long.class) {
                return PrimitiveSerializers.LongSerializer.writeLong(buffer, inputObject, this.fury.longEncoding(), true);
            }
            if (clz == Float.TYPE || clz == Float.class) {
                return new Expression.Invoke(buffer, "writeFloat", inputObject);
            }
            if (clz == Double.TYPE || clz == Double.class) {
                return new Expression.Invoke(buffer, "writeDouble", inputObject);
            }
            throw new IllegalStateException("impossible");
        }
        if (clz == String.class) {
            return this.fury.getStringSerializer().writeStringExpr(this.stringSerializerRef, buffer, inputObject);
        }
        Expression action = this.useCollectionSerialization(typeToken) ? this.serializeForCollection(buffer, inputObject, typeToken, serializer, generateNewMethod) : (this.useMapSerialization(typeToken) ? this.serializeForMap(buffer, inputObject, typeToken, serializer, generateNewMethod) : this.serializeForNotNullObject(inputObject, buffer, typeToken, serializer));
        return action;
    }

    protected boolean useCollectionSerialization(TypeToken<?> typeToken) {
        return this.visitFury(f -> f.getClassResolver().isCollection(TypeUtils.getRawType(typeToken)));
    }

    protected boolean useMapSerialization(TypeToken<?> typeToken) {
        return this.visitFury(f -> f.getClassResolver().isMap(TypeUtils.getRawType(typeToken)));
    }

    protected abstract boolean isFinal(Class<?> var1);

    protected Expression serializeForNotNullObject(Expression inputObject, Expression buffer, TypeToken<?> typeToken, Expression serializer) {
        Class<?> clz = TypeUtils.getRawType(typeToken);
        if (serializer != null) {
            return new Expression.Invoke(serializer, "write", buffer, inputObject);
        }
        if (this.isFinal(clz)) {
            serializer = this.getOrCreateSerializer(clz);
            return new Expression.Invoke(serializer, "write", buffer, inputObject);
        }
        return this.writeForNotNullNonFinalObject(inputObject, buffer, typeToken);
    }

    protected Expression writeForNotNullNonFinalObject(Expression inputObject, Expression buffer, TypeToken<?> typeToken) {
        Class<?> clz = TypeUtils.getRawType(typeToken);
        Expression.Invoke clsExpr = new Expression.Invoke(inputObject, "getClass", "cls", TypeUtils.CLASS_TYPE);
        Expression.ListExpression writeClassAndObject = new Expression.ListExpression(new Expression[0]);
        Tuple2<Expression.Reference, Boolean> classInfoRef = this.addClassInfoField(clz);
        Expression classInfo = (Expression)classInfoRef.f0;
        if (((Boolean)classInfoRef.f1).booleanValue()) {
            writeClassAndObject.add(new Expression.If(ExpressionUtils.neq(new Expression.Invoke(classInfo, "getCls", TypeUtils.CLASS_TYPE), clsExpr), new Expression.Assign(classInfo, Expression.Invoke.inlineInvoke((Expression)this.classResolverRef, "getClassInfo", classInfoTypeToken, clsExpr))));
        }
        writeClassAndObject.add(this.fury.getClassResolver().writeClassExpr(this.classResolverRef, buffer, classInfo));
        writeClassAndObject.add(new Expression.Invoke((Expression)Expression.Invoke.inlineInvoke(classInfo, "getSerializer", SERIALIZER_TYPE, new Expression[0]), "write", TypeUtils.PRIMITIVE_VOID_TYPE, buffer, inputObject));
        return ExpressionOptimizer.invokeGenerated(this.ctx, (Set<Expression>)ImmutableSet.of((Object)buffer, (Object)inputObject), writeClassAndObject, "writeClassAndObject", false);
    }

    protected Expression getOrCreateSerializer(Class<?> cls) {
        Expression.Reference serializerRef = this.serializerMap.get(cls);
        if (serializerRef == null) {
            ClassLoader beanClassClassLoader;
            Class<Serializer> serializerClass = this.visitFury(f -> f.getClassResolver().getSerializerClass(cls));
            Preconditions.checkNotNull(serializerClass, "Unsupported for class " + cls);
            ClassLoader classLoader = beanClassClassLoader = this.beanClass.getClassLoader() == null ? Thread.currentThread().getContextClassLoader() : this.beanClass.getClassLoader();
            if (!ReflectionUtils.isPublic(serializerClass)) {
                serializerClass = Serializer.class;
            } else {
                try {
                    beanClassClassLoader.loadClass(serializerClass.getName());
                }
                catch (ClassNotFoundException e) {
                    serializerClass = CodegenSerializer.LazyInitBeanSerializer.class;
                }
                if (serializerClass == CodegenSerializer.LazyInitBeanSerializer.class || serializerClass == ObjectSerializer.class || serializerClass == CompatibleSerializer.class) {
                    serializerClass = Serializer.class;
                }
            }
            TypeToken serializerTypeToken = TypeToken.of(serializerClass);
            Expression fieldTypeExpr = this.getClassExpr(cls);
            Expression.Invoke newSerializerExpr = Expression.Invoke.inlineInvoke((Expression)this.classResolverRef, "getRawSerializer", SERIALIZER_TYPE, fieldTypeExpr);
            String name = this.ctx.newName(StringUtils.uncapitalize(serializerClass.getSimpleName()));
            boolean hasJITResult = this.fury.getJITContext().hasJITResult(cls);
            if (hasJITResult) {
                this.jitCallbackUpdateFields.put(name, this.ctx.type(cls) + ".class");
                this.ctx.addField(false, this.ctx.type(Serializer.class), name, new Expression.Cast(newSerializerExpr, SERIALIZER_TYPE));
                serializerRef = new Expression.Reference(name, SERIALIZER_TYPE, false);
            } else {
                this.ctx.addField(true, this.ctx.type(serializerClass), name, new Expression.Cast(newSerializerExpr, serializerTypeToken));
                serializerRef = Expression.Reference.fieldRef(name, serializerTypeToken);
            }
            this.serializerMap.put(cls, serializerRef);
        }
        return serializerRef;
    }

    protected Expression getClassExpr(Class<?> cls) {
        if (this.sourcePublicAccessible(cls)) {
            return Expression.Literal.ofClass(cls);
        }
        return new Expression.StaticInvoke(ReflectionUtils.class, "loadClass", TypeUtils.CLASS_TYPE, this.beanClassExpr(), Expression.Literal.ofString(cls.getName()));
    }

    protected Tuple2<Expression.Reference, Boolean> addClassInfoField(Class<?> cls) {
        boolean needUpdate = !ReflectionUtils.isFinal(cls);
        String key = !needUpdate ? "classInfo:" + cls : "classInfo:" + cls + this.walkPath;
        Tuple2<Expression.Reference, Boolean> classInfoRef = (Tuple2<Expression.Reference, Boolean>)this.sharedFieldMap.get(key);
        if (classInfoRef != null) {
            return classInfoRef;
        }
        if (!needUpdate) {
            Expression clsExpr = this.getClassExpr(cls);
            Expression.Invoke classInfoExpr = Expression.Invoke.inlineInvoke((Expression)this.classResolverRef, "getClassInfo", classInfoTypeToken, clsExpr);
            String name = this.ctx.newName(this.ctx.newName(cls) + "ClassInfo");
            this.ctx.addField(true, this.ctx.type(ClassInfo.class), name, classInfoExpr);
            classInfoRef = Tuple2.of(Expression.Reference.fieldRef(name, classInfoTypeToken), false);
        } else {
            Expression.Invoke classInfoExpr = Expression.Invoke.inlineInvoke((Expression)this.classResolverRef, "nilClassInfo", classInfoTypeToken, new Expression[0]);
            String name = this.ctx.newName(StringUtils.uncapitalize(cls.getSimpleName()) + "ClassInfo");
            this.ctx.addField(false, this.ctx.type(ClassInfo.class), name, classInfoExpr);
            classInfoRef = Tuple2.of(new Expression.Reference(name, classInfoTypeToken), true);
        }
        this.sharedFieldMap.put(key, classInfoRef);
        return classInfoRef;
    }

    protected Expression.Reference addClassInfoHolderField(Class<?> cls) {
        String key = Modifier.isFinal(cls.getModifiers()) ? "classInfoHolder:" + cls : "classInfoHolder:" + cls + this.walkPath;
        Expression.Reference reference = (Expression.Reference)this.sharedFieldMap.get(key);
        if (reference != null) {
            return reference;
        }
        Expression.Invoke classInfoHolderExpr = Expression.Invoke.inlineInvoke((Expression)this.classResolverRef, "nilClassInfoHolder", classInfoHolderTypeToken, new Expression[0]);
        String name = this.ctx.newName(cls, "ClassInfoHolder");
        this.ctx.addField(true, this.ctx.type(ClassInfoHolder.class), name, classInfoHolderExpr);
        reference = new Expression.Reference(name, classInfoHolderTypeToken);
        this.sharedFieldMap.put(key, reference);
        return reference;
    }

    protected Expression readClassInfo(Class<?> cls, Expression buffer) {
        return this.readClassInfo(cls, buffer, true);
    }

    protected Expression readClassInfo(Class<?> cls, Expression buffer, boolean inlineReadClassInfo) {
        if (Modifier.isFinal(cls.getModifiers())) {
            Expression.Reference classInfoRef = (Expression.Reference)this.addClassInfoField(cls).f0;
            if (inlineReadClassInfo) {
                return Expression.Invoke.inlineInvoke((Expression)this.classResolverRef, "readClassInfo", classInfoTypeToken, buffer, classInfoRef);
            }
            return new Expression.Invoke((Expression)this.classResolverRef, "readClassInfo", classInfoTypeToken, buffer, classInfoRef);
        }
        Expression.Reference classInfoHolderRef = this.addClassInfoHolderField(cls);
        if (inlineReadClassInfo) {
            return Expression.Invoke.inlineInvoke((Expression)this.classResolverRef, "readClassInfo", classInfoTypeToken, buffer, classInfoHolderRef);
        }
        return new Expression.Invoke((Expression)this.classResolverRef, "readClassInfo", classInfoTypeToken, buffer, classInfoHolderRef);
    }

    protected TypeToken<?> getSerializerType(TypeToken<?> objType) {
        if (TypeUtils.COLLECTION_TYPE.isSupertypeOf(objType)) {
            return COLLECTION_SERIALIZER_TYPE;
        }
        if (TypeUtils.MAP_TYPE.isSupertypeOf(objType)) {
            return MAP_SERIALIZER_TYPE;
        }
        return SERIALIZER_TYPE;
    }

    protected Expression castSerializer(Expression serializer, TypeToken<?> objType) {
        if (TypeUtils.COLLECTION_TYPE.isSupertypeOf(objType) && !COLLECTION_SERIALIZER_TYPE.isSupertypeOf(serializer.type())) {
            serializer = new Expression.Cast(serializer, COLLECTION_SERIALIZER_TYPE, "colSerializer");
        } else if (TypeUtils.MAP_TYPE.isSupertypeOf(objType) && !MAP_SERIALIZER_TYPE.isSupertypeOf(serializer.type())) {
            serializer = new Expression.Cast(serializer, TypeToken.of(AbstractMapSerializer.class), "mapSerializer");
        }
        return serializer;
    }

    protected Expression serializeForCollection(Expression buffer, Expression collection, TypeToken<?> typeToken, Expression serializer, boolean generateNewMethod) {
        if (serializer == null) {
            Class<?> clz = TypeUtils.getRawType(typeToken);
            if (this.isFinal(clz)) {
                serializer = this.getOrCreateSerializer(clz);
            } else {
                Expression.ListExpression writeClassAction = new Expression.ListExpression(new Expression[0]);
                Tuple2<Expression.Reference, Boolean> classInfoRef = this.addClassInfoField(clz);
                Expression classInfo = (Expression)classInfoRef.f0;
                Expression.Invoke clsExpr = new Expression.Invoke(collection, "getClass", "cls", TypeUtils.CLASS_TYPE);
                writeClassAction.add(new Expression.If(ExpressionUtils.neq(new Expression.Invoke(classInfo, "getCls", TypeUtils.CLASS_TYPE), clsExpr), new Expression.Assign(classInfo, Expression.Invoke.inlineInvoke((Expression)this.classResolverRef, "getClassInfo", classInfoTypeToken, clsExpr))));
                writeClassAction.add(this.fury.getClassResolver().writeClassExpr(this.classResolverRef, buffer, classInfo));
                serializer = new Expression.Invoke(classInfo, "getSerializer", "serializer", SERIALIZER_TYPE, false, new Expression[0]);
                serializer = new Expression.Cast(serializer, TypeToken.of(AbstractCollectionSerializer.class));
                writeClassAction.add(serializer, new Expression.Return(serializer));
                serializer = ExpressionOptimizer.invokeGenerated(this.ctx, (Set<Expression>)ImmutableSet.of((Object)buffer, (Object)collection), writeClassAction, "writeCollectionClassInfo", false);
            }
        } else if (!TypeToken.of(AbstractCollectionSerializer.class).isSupertypeOf(serializer.type())) {
            serializer = new Expression.Cast(serializer, TypeToken.of(AbstractCollectionSerializer.class), "colSerializer");
        }
        Expression.ListExpression actions = new Expression.ListExpression(new Expression[0]);
        Expression.If write = new Expression.If(Expression.Invoke.inlineInvoke(serializer, "supportCodegenHook", TypeUtils.PRIMITIVE_BOOLEAN_TYPE, new Expression[0]), this.writeCollectionData(buffer, collection, serializer, TypeUtils.getElementType(typeToken)), new Expression.Invoke(serializer, "write", buffer, collection));
        actions.add(write);
        if (generateNewMethod) {
            return ExpressionOptimizer.invokeGenerated(this.ctx, (Set<Expression>)ImmutableSet.of((Object)buffer, (Object)collection, (Object)serializer), actions, "writeCollection", false);
        }
        return actions;
    }

    protected Expression writeCollectionData(Expression buffer, Expression collection, Expression serializer, TypeToken<?> elementType) {
        Expression.Invoke onCollectionWrite = new Expression.Invoke(serializer, "onCollectionWrite", TypeUtils.collectionOf(elementType), buffer, collection);
        collection = onCollectionWrite;
        Expression.Invoke size = new Expression.Invoke(collection, "size", TypeUtils.PRIMITIVE_INT_TYPE);
        this.walkPath.add(elementType.toString());
        Expression.ListExpression builder = new Expression.ListExpression(new Expression[0]);
        Class<?> elemClass = TypeUtils.getRawType(elementType);
        boolean trackingRef = this.visitFury(fury -> fury.getClassResolver().needToWriteRef(elemClass));
        Tuple2<Expression, Expression.Invoke> writeElementsHeader = this.writeElementsHeader(elemClass, trackingRef, serializer, buffer, collection);
        Expression flags = (Expression)writeElementsHeader.f0;
        builder.add(flags);
        boolean finalType = this.isFinal(elemClass);
        if (finalType) {
            if (trackingRef) {
                builder.add(this.writeContainerElements(elementType, true, null, null, buffer, collection, size));
            } else {
                Expression.Literal hasNullFlag = Expression.Literal.ofInt(AbstractCollectionSerializer.Flags.HAS_NULL);
                Expression.Comparator hasNull = ExpressionUtils.eq((Expression)new Expression.BitAnd(flags, hasNullFlag), (Expression)hasNullFlag, "hasNull");
                builder.add(hasNull, this.writeContainerElements(elementType, false, null, hasNull, buffer, collection, size));
            }
        } else {
            Expression.If action;
            Expression.Literal flag = Expression.Literal.ofInt(AbstractCollectionSerializer.Flags.NOT_SAME_TYPE);
            Expression.Comparator sameElementClass = ExpressionUtils.neq((Expression)new Expression.BitAnd(flags, flag), (Expression)flag, "sameElementClass");
            builder.add(sameElementClass);
            Expression.Literal notDeclTypeFlag = Expression.Literal.ofInt(AbstractCollectionSerializer.Flags.NOT_DECL_ELEMENT_TYPE);
            Expression.Comparator isDeclType = ExpressionUtils.neq((Expression)new Expression.BitAnd(flags, notDeclTypeFlag), (Expression)notDeclTypeFlag, "isDeclType");
            boolean maybeDecl = this.visitFury(f -> f.getClassResolver().isSerializable(elemClass));
            Expression elemSerializer = maybeDecl ? new Expression.If(isDeclType, this.getOrCreateSerializer(elemClass), this.castSerializer(((Expression.Invoke)writeElementsHeader.f1).inline(), elementType), false, this.getSerializerType(elementType)) : this.castSerializer(((Expression.Invoke)writeElementsHeader.f1).inline(), elementType);
            elemSerializer = ExpressionUtils.uninline(elemSerializer);
            if (trackingRef) {
                Expression.ListExpression writeBuilder = new Expression.ListExpression(elemSerializer);
                writeBuilder.add(this.writeContainerElements(elementType, true, elemSerializer, null, buffer, collection, size));
                HashSet<Expression> cutPoint = Collections.ofHashSet(buffer, collection, size);
                if (maybeDecl) {
                    cutPoint.add(flags);
                }
                action = new Expression.If(sameElementClass, ExpressionOptimizer.invokeGenerated(this.ctx, cutPoint, writeBuilder, "sameElementClassWrite", false), this.writeContainerElements(elementType, true, null, null, buffer, collection, size));
            } else {
                Expression.Literal hasNullFlag = Expression.Literal.ofInt(AbstractCollectionSerializer.Flags.HAS_NULL);
                Expression.Comparator hasNull = ExpressionUtils.eq((Expression)new Expression.BitAnd(flags, hasNullFlag), (Expression)hasNullFlag, "hasNull");
                builder.add(hasNull);
                Expression.ListExpression writeBuilder = new Expression.ListExpression(elemSerializer);
                writeBuilder.add(this.writeContainerElements(elementType, false, elemSerializer, hasNull, buffer, collection, size));
                HashSet<Expression> cutPoint = Collections.ofHashSet(buffer, collection, size, hasNull);
                if (maybeDecl) {
                    cutPoint.add(flags);
                }
                action = new Expression.If(sameElementClass, ExpressionOptimizer.invokeGenerated(this.ctx, cutPoint, writeBuilder, "sameElementClassWrite", false), this.writeContainerElements(elementType, false, null, hasNull, buffer, collection, size));
            }
            builder.add(action);
        }
        this.walkPath.removeLast();
        return new Expression.ListExpression(onCollectionWrite, new Expression.If(ExpressionUtils.gt(size, Expression.Literal.ofInt(0)), builder));
    }

    private Tuple2<Expression, Expression.Invoke> writeElementsHeader(Class<?> elementType, boolean trackingRef, Expression collectionSerializer, Expression buffer, Expression value) {
        if (this.isFinal(elementType)) {
            Expression bitmap = trackingRef ? new Expression.ListExpression(new Expression.Invoke(buffer, "writeByte", Expression.Literal.ofInt(AbstractCollectionSerializer.Flags.TRACKING_REF)), Expression.Literal.ofInt(AbstractCollectionSerializer.Flags.TRACKING_REF)) : new Expression.Invoke(collectionSerializer, "writeNullabilityHeader", TypeUtils.PRIMITIVE_INT_TYPE, buffer, value);
            return Tuple2.of(bitmap, null);
        }
        Expression elementTypeExpr = this.getClassExpr(elementType);
        Expression.Reference classInfoHolder = this.addClassInfoHolderField(elementType);
        Expression.Invoke bitmap = trackingRef ? (elementType == Object.class ? new Expression.Invoke(collectionSerializer, "writeTypeHeader", TypeUtils.PRIMITIVE_INT_TYPE, buffer, value, classInfoHolder) : new Expression.Invoke(collectionSerializer, "writeTypeHeader", TypeUtils.PRIMITIVE_INT_TYPE, buffer, value, elementTypeExpr, classInfoHolder)) : new Expression.Invoke(collectionSerializer, "writeTypeNullabilityHeader", TypeUtils.PRIMITIVE_INT_TYPE, buffer, value, elementTypeExpr, classInfoHolder);
        Expression.Invoke serializer = new Expression.Invoke((Expression)classInfoHolder, "getSerializer", SERIALIZER_TYPE);
        return Tuple2.of(bitmap, serializer);
    }

    private Expression writeContainerElements(TypeToken<?> elementType, boolean trackingRef, Expression serializer, Expression hasNull, Expression buffer, Expression collection, Expression size) {
        ExpressionVisitor.ExprHolder exprHolder = ExpressionVisitor.ExprHolder.of(BUFFER_NAME, buffer, "hasNull", hasNull, "serializer", serializer);
        boolean isList = List.class.isAssignableFrom(TypeUtils.getRawType(collection.type()));
        if (isList) {
            exprHolder.add("list", collection);
            return new Expression.ForLoop(new Expression.Literal(0, TypeUtils.PRIMITIVE_INT_TYPE), size, new Expression.Literal(1, TypeUtils.PRIMITIVE_INT_TYPE), i -> {
                Expression.Invoke elem = new Expression.Invoke(exprHolder.get("list"), "get", TypeUtils.OBJECT_TYPE, false, (Expression)i);
                return this.writeContainerElement(exprHolder.get(BUFFER_NAME), elem, elementType, trackingRef, exprHolder.get("hasNull"), exprHolder.get("serializer"));
            });
        }
        return new Expression.ForEach(collection, (i, elem) -> this.writeContainerElement(exprHolder.get(BUFFER_NAME), (Expression)elem, elementType, trackingRef, exprHolder.get("hasNull"), exprHolder.get("serializer")));
    }

    private Expression writeContainerElement(Expression buffer, Expression elem, TypeToken<?> elementType, boolean trackingRef, Expression hasNull, Expression elemSerializer) {
        boolean generateNewMethod = this.useCollectionSerialization(elementType) || this.useMapSerialization(elementType);
        Class<?> rawType = TypeUtils.getRawType(elementType);
        boolean finalType = this.isFinal(rawType);
        elem = this.tryCastIfPublic(elem, elementType);
        Expression.If write = finalType ? (trackingRef ? new Expression.If(ExpressionUtils.not(this.writeRefOrNull(buffer, elem)), this.serializeForNotNull(elem, buffer, elementType, generateNewMethod)) : new Expression.If(hasNull, this.serializeFor(elem, buffer, elementType, generateNewMethod), this.serializeForNotNull(elem, buffer, elementType))) : (trackingRef ? new Expression.If(ExpressionUtils.not(this.writeRefOrNull(buffer, elem)), this.serializeForNotNull(elem, buffer, elementType, elemSerializer, generateNewMethod)) : new Expression.If(hasNull, this.serializeFor(elem, buffer, elementType, elemSerializer, generateNewMethod), this.serializeForNotNull(elem, buffer, elementType, elemSerializer, generateNewMethod)));
        return new Expression.ListExpression(elem, write);
    }

    protected Expression serializeForMap(Expression buffer, Expression map, TypeToken<?> typeToken, Expression serializer, boolean generateNewMethod) {
        if (serializer == null) {
            Class<?> clz = TypeUtils.getRawType(typeToken);
            if (this.isFinal(clz)) {
                serializer = this.getOrCreateSerializer(clz);
            } else {
                Expression.ListExpression writeClassAction = new Expression.ListExpression(new Expression[0]);
                Tuple2<Expression.Reference, Boolean> classInfoRef = this.addClassInfoField(clz);
                Expression classInfo = (Expression)classInfoRef.f0;
                Expression.Invoke clsExpr = new Expression.Invoke(map, "getClass", "cls", TypeUtils.CLASS_TYPE);
                writeClassAction.add(new Expression.If(ExpressionUtils.neq(new Expression.Invoke(classInfo, "getCls", TypeUtils.CLASS_TYPE), clsExpr), new Expression.Assign(classInfo, Expression.Invoke.inlineInvoke((Expression)this.classResolverRef, "getClassInfo", classInfoTypeToken, clsExpr))));
                writeClassAction.add(this.fury.getClassResolver().writeClassExpr(this.classResolverRef, buffer, classInfo));
                serializer = new Expression.Invoke(classInfo, "getSerializer", "serializer", SERIALIZER_TYPE, false, new Expression[0]);
                serializer = new Expression.Cast(serializer, TypeToken.of(AbstractMapSerializer.class));
                writeClassAction.add(serializer, new Expression.Return(serializer));
                serializer = ExpressionOptimizer.invokeGenerated(this.ctx, (Set<Expression>)ImmutableSet.of((Object)buffer, (Object)map), writeClassAction, "writeMapClassInfo", false);
            }
        } else if (!AbstractMapSerializer.class.isAssignableFrom(serializer.type().getRawType())) {
            serializer = new Expression.Cast(serializer, TypeToken.of(AbstractMapSerializer.class), "mapSerializer");
        }
        Expression.If write = new Expression.If(Expression.Invoke.inlineInvoke(serializer, "supportCodegenHook", TypeUtils.PRIMITIVE_BOOLEAN_TYPE, new Expression[0]), this.jitWriteMap(buffer, map, serializer, typeToken), new Expression.Invoke(serializer, "write", buffer, map));
        if (generateNewMethod) {
            return ExpressionOptimizer.invokeGenerated(this.ctx, (Set<Expression>)ImmutableSet.of((Object)buffer, (Object)map), write, "writeMap", false);
        }
        return write;
    }

    private Expression jitWriteMap(Expression buffer, Expression map, Expression serializer, TypeToken<?> typeToken) {
        Tuple2<TypeToken<?>, TypeToken<?>> keyValueType = TypeUtils.getMapKeyValueType(typeToken);
        TypeToken keyType = (TypeToken)keyValueType.f0;
        TypeToken valueType = (TypeToken)keyValueType.f1;
        Expression.Invoke onMapWrite = new Expression.Invoke(serializer, "onMapWrite", TypeUtils.mapOf(keyType, valueType), buffer, map);
        map = onMapWrite;
        Expression.Invoke size = new Expression.Invoke(map, "size", TypeUtils.PRIMITIVE_INT_TYPE);
        Expression.Invoke entrySet = new Expression.Invoke(map, "entrySet", "entrySet", TypeUtils.SET_TYPE);
        ExpressionVisitor.ExprHolder exprHolder = ExpressionVisitor.ExprHolder.of(BUFFER_NAME, buffer);
        Expression.ForEach writeKeyValues = new Expression.ForEach(entrySet, (i, entryObj) -> {
            Expression.Cast entry = new Expression.Cast((Expression)entryObj, (TypeToken<?>)TypeToken.of(Map.Entry.class), "entry");
            Expression key = new Expression.Invoke((Expression)entry, "getKey", "keyObj", TypeUtils.OBJECT_TYPE);
            key = this.tryCastIfPublic(key, keyType, "key");
            Expression value = new Expression.Invoke((Expression)entry, "getValue", "valueObj", TypeUtils.OBJECT_TYPE);
            value = this.tryCastIfPublic(value, valueType, "value");
            this.walkPath.add("key:" + keyType);
            boolean genMethodForKey = this.useCollectionSerialization(keyType) || this.useMapSerialization(keyType);
            Expression keyAction = this.serializeFor(key, exprHolder.get(BUFFER_NAME), keyType, genMethodForKey);
            this.walkPath.removeLast();
            this.walkPath.add("value:" + valueType);
            boolean genMethodForValue = this.useCollectionSerialization(valueType) || this.useMapSerialization(valueType);
            Expression valueAction = this.serializeFor(value, exprHolder.get(BUFFER_NAME), valueType, genMethodForValue);
            this.walkPath.removeLast();
            return new Expression.ListExpression(keyAction, valueAction);
        });
        return new Expression.ListExpression(onMapWrite, writeKeyValues);
    }

    protected Expression readRefOrNull(Expression buffer) {
        return new Expression.Invoke((Expression)this.refResolverRef, "readRefOrNull", "tag", TypeUtils.PRIMITIVE_BYTE_TYPE, false, buffer);
    }

    protected Expression tryPreserveRefId(Expression buffer) {
        return new Expression.Invoke((Expression)this.refResolverRef, "tryPreserveRefId", "refId", TypeUtils.PRIMITIVE_INT_TYPE, false, buffer);
    }

    protected Expression deserializeFor(Expression buffer, TypeToken<?> typeToken, Function<Expression, Expression> callback) {
        return this.deserializeFor(buffer, typeToken, callback, null);
    }

    protected Expression deserializeFor(Expression buffer, TypeToken<?> typeToken, Function<Expression, Expression> callback, CutPoint cutPoint) {
        Class<?> rawType = TypeUtils.getRawType(typeToken);
        if (this.visitFury(f -> f.getClassResolver().needToWriteRef(rawType)).booleanValue()) {
            return this.readRef(buffer, callback, () -> this.deserializeForNotNull(buffer, typeToken, cutPoint));
        }
        if (typeToken.isPrimitive()) {
            Expression value = this.deserializeForNotNull(buffer, typeToken, cutPoint);
            return new Expression.ListExpression(value, callback.apply(value));
        }
        return this.readNullable(buffer, typeToken, callback, () -> this.deserializeForNotNull(buffer, typeToken, cutPoint));
    }

    private Expression readRef(Expression buffer, Function<Expression, Expression> callback, Supplier<Expression> deserializeForNotNull) {
        Expression refId = this.tryPreserveRefId(buffer);
        Expression.Comparator needDeserialize = ExpressionUtils.egt(refId, new Expression.Literal((byte)-1, TypeUtils.PRIMITIVE_BYTE_TYPE));
        Expression deserializedValue = deserializeForNotNull.get();
        Expression.Invoke setReadObject = new Expression.Invoke((Expression)this.refResolverRef, "setReadObject", refId, deserializedValue);
        Expression.Invoke readValue = Expression.Invoke.inlineInvoke((Expression)this.refResolverRef, "getReadObject", TypeUtils.OBJECT_TYPE, false, new Expression[0]);
        return new Expression.If(needDeserialize, callback.apply(new Expression.ListExpression(refId, deserializedValue, setReadObject, deserializedValue)), callback.apply(readValue), false);
    }

    private Expression readNullable(Expression buffer, TypeToken<?> typeToken, Function<Expression, Expression> callback, Supplier<Expression> deserializeForNotNull) {
        Expression.Comparator notNull = ExpressionUtils.neq(Expression.Invoke.inlineInvoke(buffer, "readByte", TypeUtils.PRIMITIVE_BYTE_TYPE, new Expression[0]), new Expression.Literal((byte)-3, TypeUtils.PRIMITIVE_BYTE_TYPE));
        Expression value = deserializeForNotNull.get();
        return new Expression.If(notNull, callback.apply(value), callback.apply(ExpressionUtils.nullValue(typeToken)), false);
    }

    protected Expression deserializeForNotNull(Expression buffer, TypeToken<?> typeToken, CutPoint cutPoint) {
        return this.deserializeForNotNull(buffer, typeToken, null, cutPoint);
    }

    protected Expression deserializeForNotNull(Expression buffer, TypeToken<?> typeToken, Expression serializer, CutPoint cutPoint) {
        Expression obj;
        Class<?> cls = TypeUtils.getRawType(typeToken);
        if (TypeUtils.isPrimitive(cls) || TypeUtils.isBoxed(cls)) {
            if (cls == Byte.TYPE || cls == Byte.class) {
                return new Expression.Invoke(buffer, "readByte", TypeUtils.PRIMITIVE_BYTE_TYPE);
            }
            if (cls == Boolean.TYPE || cls == Boolean.class) {
                return new Expression.Invoke(buffer, "readBoolean", TypeUtils.PRIMITIVE_BOOLEAN_TYPE);
            }
            if (cls == Character.TYPE || cls == Character.class) {
                return new Expression.Invoke(buffer, "readChar", TypeToken.of(Character.TYPE));
            }
            if (cls == Short.TYPE || cls == Short.class) {
                return new Expression.Invoke(buffer, "readShort", TypeUtils.PRIMITIVE_SHORT_TYPE);
            }
            if (cls == Integer.TYPE || cls == Integer.class) {
                String func = this.fury.compressInt() ? "readVarInt" : "readInt";
                return new Expression.Invoke(buffer, func, TypeUtils.PRIMITIVE_INT_TYPE);
            }
            if (cls == Long.TYPE || cls == Long.class) {
                return PrimitiveSerializers.LongSerializer.readLong(buffer, this.fury.longEncoding());
            }
            if (cls == Float.TYPE || cls == Float.class) {
                return new Expression.Invoke(buffer, "readFloat", TypeUtils.PRIMITIVE_FLOAT_TYPE);
            }
            if (cls == Double.TYPE || cls == Double.class) {
                return new Expression.Invoke(buffer, "readDouble", TypeUtils.PRIMITIVE_DOUBLE_TYPE);
            }
            throw new IllegalStateException("impossible");
        }
        if (cls == String.class) {
            return this.fury.getStringSerializer().readStringExpr(this.stringSerializerRef, buffer);
        }
        if (this.useCollectionSerialization(typeToken)) {
            obj = this.deserializeForCollection(buffer, typeToken, serializer, cutPoint);
        } else if (this.useMapSerialization(typeToken)) {
            obj = this.deserializeForMap(buffer, typeToken, serializer, cutPoint);
        } else if (this.isFinal(cls)) {
            Preconditions.checkState(serializer == null);
            serializer = this.getOrCreateSerializer(cls);
            Class<?> returnType = ReflectionUtils.getReturnType(TypeUtils.getRawType(serializer.type()), "read");
            obj = new Expression.Invoke(serializer, "read", TypeToken.of(returnType), buffer);
        } else {
            obj = this.readForNotNullNonFinal(buffer, typeToken, serializer);
        }
        return obj;
    }

    protected Expression readForNotNullNonFinal(Expression buffer, TypeToken<?> typeToken, Expression serializer) {
        if (serializer == null) {
            Expression classInfo = this.readClassInfo(TypeUtils.getRawType(typeToken), buffer);
            serializer = Expression.Invoke.inlineInvoke(classInfo, "getSerializer", SERIALIZER_TYPE, new Expression[0]);
        }
        return new Expression.Invoke(serializer, "read", TypeUtils.OBJECT_TYPE, buffer);
    }

    protected Expression deserializeForCollection(Expression buffer, TypeToken<?> typeToken, Expression serializer, CutPoint cutPoint) {
        TypeToken<?> elementType = TypeUtils.getElementType(typeToken);
        if (serializer == null) {
            Class<?> cls = TypeUtils.getRawType(typeToken);
            if (this.isFinal(cls)) {
                serializer = this.getOrCreateSerializer(cls);
            } else {
                Expression classInfo = this.readClassInfo(cls, buffer);
                serializer = new Expression.Invoke(classInfo, "getSerializer", "serializer", SERIALIZER_TYPE, false, new Expression[0]);
                serializer = new Expression.Cast(serializer, TypeToken.of(AbstractCollectionSerializer.class), "collectionSerializer");
            }
        } else {
            Preconditions.checkArgument(AbstractCollectionSerializer.class.isAssignableFrom(serializer.type().getRawType()), "Expected AbstractCollectionSerializer but got %s", serializer.type(), new Object[0]);
        }
        Expression.Invoke supportHook = Expression.Invoke.inlineInvoke(serializer, "supportCodegenHook", TypeUtils.PRIMITIVE_BOOLEAN_TYPE, new Expression[0]);
        Expression.Invoke collection = new Expression.Invoke(serializer, "newCollection", TypeUtils.COLLECTION_TYPE, buffer);
        Expression.Invoke size = new Expression.Invoke(serializer, "getNumElements", "size", TypeUtils.PRIMITIVE_INT_TYPE);
        Expression hookRead = this.readCollectionCodegen(buffer, collection, size, elementType);
        hookRead = new Expression.Invoke(serializer, "onCollectionRead", TypeUtils.OBJECT_TYPE, hookRead);
        Expression.If action = new Expression.If(supportHook, new Expression.ListExpression(collection, hookRead), new Expression.Invoke(serializer, "read", TypeUtils.OBJECT_TYPE, buffer), false);
        if (cutPoint != null && cutPoint.genNewMethod) {
            cutPoint.add(buffer);
            return ExpressionOptimizer.invokeGenerated(this.ctx, cutPoint.cutPoints, new Expression.ListExpression(action, new Expression.Return(action)), "readCollection", false);
        }
        return action;
    }

    protected Expression readCollectionCodegen(Expression buffer, Expression collection, Expression size, TypeToken<?> elementType) {
        Expression.ListExpression builder = new Expression.ListExpression(new Expression[0]);
        Expression.Invoke flags = new Expression.Invoke(buffer, "readByte", "flags", TypeUtils.PRIMITIVE_INT_TYPE, false, new Expression[0]);
        builder.add(flags);
        Class<?> elemClass = TypeUtils.getRawType(elementType);
        this.walkPath.add(elementType.toString());
        boolean finalType = this.isFinal(elemClass);
        boolean trackingRef = this.visitFury(fury -> fury.getClassResolver().needToWriteRef(elemClass));
        if (finalType) {
            if (trackingRef) {
                builder.add(this.readContainerElements(elementType, true, null, null, buffer, collection, size));
            } else {
                Expression.Literal hasNullFlag = Expression.Literal.ofInt(AbstractCollectionSerializer.Flags.HAS_NULL);
                Expression.Comparator hasNull = ExpressionUtils.eq((Expression)new Expression.BitAnd(flags, hasNullFlag), (Expression)hasNullFlag, "hasNull");
                builder.add(hasNull, this.readContainerElements(elementType, false, null, hasNull, buffer, collection, size));
            }
        } else {
            Expression.If action;
            Expression.Literal notSameTypeFlag = Expression.Literal.ofInt(AbstractCollectionSerializer.Flags.NOT_SAME_TYPE);
            Expression.Comparator sameElementClass = ExpressionUtils.neq((Expression)new Expression.BitAnd(flags, notSameTypeFlag), (Expression)notSameTypeFlag, "sameElementClass");
            Expression.Literal notDeclTypeFlag = Expression.Literal.ofInt(AbstractCollectionSerializer.Flags.NOT_DECL_ELEMENT_TYPE);
            Expression.Comparator isDeclType = ExpressionUtils.neq((Expression)new Expression.BitAnd(flags, notDeclTypeFlag), (Expression)notDeclTypeFlag, "isDeclType");
            Expression.Invoke serializer = Expression.Invoke.inlineInvoke(this.readClassInfo(elemClass, buffer), "getSerializer", SERIALIZER_TYPE, new Expression[0]);
            TypeToken<?> serializerType = this.getSerializerType(elementType);
            boolean maybeDecl = this.visitFury(f -> f.getClassResolver().isSerializable(elemClass));
            Expression elemSerializer = maybeDecl ? new Expression.If(isDeclType, this.getOrCreateSerializer(elemClass), this.castSerializer(serializer.inline(), elementType), false, serializerType) : this.castSerializer(serializer.inline(), elementType);
            elemSerializer = ExpressionUtils.uninline(elemSerializer);
            builder.add(sameElementClass);
            if (trackingRef) {
                Expression.ListExpression readBuilder = new Expression.ListExpression(elemSerializer);
                readBuilder.add(this.readContainerElements(elementType, true, elemSerializer, null, buffer, collection, size));
                HashSet<Expression> cutPoint = Collections.ofHashSet(buffer, collection, size);
                if (maybeDecl) {
                    cutPoint.add(flags);
                }
                Expression sameElementClassRead = ExpressionOptimizer.invokeGenerated(this.ctx, cutPoint, readBuilder, "sameElementClassRead", false);
                action = new Expression.If(sameElementClass, sameElementClassRead, this.readContainerElements(elementType, true, null, null, buffer, collection, size));
            } else {
                Expression.Literal hasNullFlag = Expression.Literal.ofInt(AbstractCollectionSerializer.Flags.HAS_NULL);
                Expression.Comparator hasNull = ExpressionUtils.eq((Expression)new Expression.BitAnd(flags, hasNullFlag), (Expression)hasNullFlag, "hasNull");
                builder.add(hasNull);
                Expression.ListExpression readBuilder = new Expression.ListExpression(elemSerializer);
                readBuilder.add(this.readContainerElements(elementType, false, elemSerializer, hasNull, buffer, collection, size));
                HashSet<Expression> cutPoint = Collections.ofHashSet(buffer, collection, size, hasNull);
                if (maybeDecl) {
                    cutPoint.add(flags);
                }
                Expression sameElementClassRead = ExpressionOptimizer.invokeGenerated(this.ctx, cutPoint, readBuilder, "sameElementClassRead", false);
                action = new Expression.If(sameElementClass, sameElementClassRead, this.readContainerElements(elementType, false, null, hasNull, buffer, collection, size));
            }
            builder.add(action);
        }
        this.walkPath.removeLast();
        return new Expression.ListExpression(size, collection, new Expression.If(ExpressionUtils.gt(size, Expression.Literal.ofInt(0)), builder), collection);
    }

    private Expression readContainerElements(TypeToken<?> elementType, boolean trackingRef, Expression serializer, Expression hasNull, Expression buffer, Expression collection, Expression size) {
        ExpressionVisitor.ExprHolder exprHolder = ExpressionVisitor.ExprHolder.of("collection", collection, BUFFER_NAME, buffer, "hasNull", hasNull, "serializer", serializer);
        Expression.Literal start = new Expression.Literal(0, TypeUtils.PRIMITIVE_INT_TYPE);
        Expression.Literal step = new Expression.Literal(1, TypeUtils.PRIMITIVE_INT_TYPE);
        return new Expression.ForLoop(start, size, step, i -> this.readContainerElement(exprHolder.get(BUFFER_NAME), elementType, trackingRef, exprHolder.get("hasNull"), exprHolder.get("serializer"), v -> new Expression.Invoke(exprHolder.get("collection"), "add", (Expression)v)));
    }

    private Expression readContainerElement(Expression buffer, TypeToken<?> elementType, boolean trackingRef, Expression hasNull, Expression elemSerializer, Function<Expression, Expression> callback) {
        Expression read;
        boolean genNewMethod = this.useCollectionSerialization(elementType) || this.useMapSerialization(elementType);
        CutPoint cutPoint = new CutPoint(genNewMethod, buffer);
        Class<?> rawType = TypeUtils.getRawType(elementType);
        boolean finalType = this.isFinal(rawType);
        if (finalType) {
            if (trackingRef) {
                read = this.deserializeFor(buffer, elementType, callback, cutPoint);
            } else {
                cutPoint.add(hasNull);
                read = new Expression.If(hasNull, this.deserializeFor(buffer, elementType, callback, cutPoint), callback.apply(this.deserializeForNotNull(buffer, elementType, cutPoint)));
            }
        } else {
            cutPoint.add(elemSerializer);
            if (trackingRef) {
                read = this.readRef(buffer, callback, () -> this.deserializeForNotNull(buffer, elementType, elemSerializer, cutPoint));
            } else {
                cutPoint.add(hasNull);
                read = new Expression.If(hasNull, this.readNullable(buffer, elementType, callback, () -> this.deserializeForNotNull(buffer, elementType, elemSerializer, cutPoint)), callback.apply(this.deserializeForNotNull(buffer, elementType, elemSerializer, cutPoint)));
            }
        }
        return read;
    }

    protected Expression deserializeForMap(Expression buffer, TypeToken<?> typeToken, Expression serializer, CutPoint cutPoint) {
        Tuple2<TypeToken<?>, TypeToken<?>> keyValueType = TypeUtils.getMapKeyValueType(typeToken);
        TypeToken keyType = (TypeToken)keyValueType.f0;
        TypeToken valueType = (TypeToken)keyValueType.f1;
        if (serializer == null) {
            Class<?> cls = TypeUtils.getRawType(typeToken);
            if (this.isFinal(cls)) {
                serializer = this.getOrCreateSerializer(cls);
            } else {
                Expression classInfo = this.readClassInfo(cls, buffer);
                serializer = new Expression.Invoke(classInfo, "getSerializer", SERIALIZER_TYPE);
                serializer = new Expression.Cast(serializer, TypeToken.of(AbstractMapSerializer.class), "mapSerializer");
            }
        } else {
            Preconditions.checkArgument(AbstractMapSerializer.class.isAssignableFrom(serializer.type().getRawType()), "Expected AbstractMapSerializer but got %s", serializer.type(), new Object[0]);
        }
        Expression.Invoke supportHook = Expression.Invoke.inlineInvoke(serializer, "supportCodegenHook", TypeUtils.PRIMITIVE_BOOLEAN_TYPE, new Expression[0]);
        Expression.Invoke newMap = new Expression.Invoke(serializer, "newMap", TypeUtils.MAP_TYPE, buffer);
        Expression.Invoke size = new Expression.Invoke(serializer, "getNumElements", "size", TypeUtils.PRIMITIVE_INT_TYPE);
        Expression.Literal start = new Expression.Literal(0, TypeUtils.PRIMITIVE_INT_TYPE);
        Expression.Literal step = new Expression.Literal(1, TypeUtils.PRIMITIVE_INT_TYPE);
        ExpressionVisitor.ExprHolder exprHolder = ExpressionVisitor.ExprHolder.of("map", newMap, BUFFER_NAME, buffer);
        Expression.ForLoop readKeyValues = new Expression.ForLoop(start, size, step, i -> {
            boolean genKeyMethod = this.useCollectionSerialization(keyType) || this.useMapSerialization(keyType);
            boolean genValueMethod = this.useCollectionSerialization(valueType) || this.useMapSerialization(valueType);
            this.walkPath.add("key:" + keyType);
            Expression keyAction = this.deserializeFor(exprHolder.get(BUFFER_NAME), keyType, e -> e, new CutPoint(genKeyMethod, new Expression[0]));
            this.walkPath.removeLast();
            this.walkPath.add("value:" + valueType);
            Expression valueAction = this.deserializeFor(exprHolder.get(BUFFER_NAME), valueType, e -> e, new CutPoint(genValueMethod, new Expression[0]));
            this.walkPath.removeLast();
            return new Expression.Invoke(exprHolder.get("map"), "put", keyAction, valueAction);
        });
        Expression hookRead = new Expression.ListExpression(newMap, size, readKeyValues, newMap);
        hookRead = new Expression.Invoke(serializer, "onMapRead", TypeUtils.OBJECT_TYPE, hookRead);
        Expression.If action = new Expression.If(supportHook, hookRead, new Expression.Invoke(serializer, "read", TypeUtils.OBJECT_TYPE, buffer), false);
        if (cutPoint != null && cutPoint.genNewMethod) {
            cutPoint.add(buffer);
            return ExpressionOptimizer.invokeGenerated(this.ctx, cutPoint.cutPoints, new Expression.ListExpression(action, new Expression.Return(action)), "readMap", false);
        }
        return action;
    }

    @Override
    protected Expression beanClassExpr() {
        if (GraalvmSupport.isGraalBuildtime()) {
            return this.staticBeanClassExpr();
        }
        return new Expression.Reference("super.type", TypeUtils.CLASS_TYPE);
    }

    protected static class CutPoint {
        public boolean genNewMethod;
        public Set<Expression> cutPoints = new HashSet<Expression>();

        public CutPoint(boolean genNewMethod, Expression ... cutPoints) {
            this.genNewMethod = genNewMethod;
            java.util.Collections.addAll(this.cutPoints, cutPoints);
        }

        public CutPoint add(Expression cutPoint) {
            this.cutPoints.add(cutPoint);
            return this;
        }

        public String toString() {
            return "CutPoint{genNewMethod=" + this.genNewMethod + ", cutPoints=" + this.cutPoints + '}';
        }
    }
}

