/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.command;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.Http2Headers;
import org.apache.dubbo.rpc.protocol.tri.command.StreamQueueCommand;
import org.apache.dubbo.rpc.protocol.tri.stream.TripleStreamChannelFuture;

public class HeaderQueueCommand
extends StreamQueueCommand {
    private final Http2Headers headers;
    private final boolean endStream;

    private HeaderQueueCommand(TripleStreamChannelFuture streamChannelFuture, Http2Headers headers, boolean endStream) {
        super(streamChannelFuture);
        this.headers = headers;
        this.endStream = endStream;
    }

    public static HeaderQueueCommand createHeaders(TripleStreamChannelFuture streamChannelFuture, Http2Headers headers) {
        return new HeaderQueueCommand(streamChannelFuture, headers, false);
    }

    public static HeaderQueueCommand createHeaders(TripleStreamChannelFuture streamChannelFuture, Http2Headers headers, boolean endStream) {
        return new HeaderQueueCommand(streamChannelFuture, headers, endStream);
    }

    public Http2Headers getHeaders() {
        return this.headers;
    }

    public boolean isEndStream() {
        return this.endStream;
    }

    @Override
    public void doSend(ChannelHandlerContext ctx, ChannelPromise promise) {
        ctx.write((Object)new DefaultHttp2HeadersFrame(this.headers, this.endStream), promise);
    }
}

