/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.springboot.starter.plugin.sign;

import org.apache.shenyu.plugin.api.ShenyuPlugin;
import org.apache.shenyu.plugin.base.handler.PluginDataHandler;
import org.apache.shenyu.plugin.sign.SignPlugin;
import org.apache.shenyu.plugin.sign.extractor.DefaultExtractor;
import org.apache.shenyu.plugin.sign.extractor.SignParameterExtractor;
import org.apache.shenyu.plugin.sign.handler.SignPluginDataHandler;
import org.apache.shenyu.plugin.sign.provider.DefaultSignProvider;
import org.apache.shenyu.plugin.sign.provider.SignProvider;
import org.apache.shenyu.plugin.sign.service.ComposableSignService;
import org.apache.shenyu.plugin.sign.service.SignService;
import org.apache.shenyu.plugin.sign.subscriber.SignAuthDataSubscriber;
import org.apache.shenyu.sync.data.api.AuthDataSubscriber;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.codec.ServerCodecConfigurer;

@Configuration
@ConditionalOnProperty(value={"shenyu.plugins.sign.enabled"}, havingValue="true", matchIfMissing=true)
public class SignPluginConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={SignService.class}, search=SearchStrategy.ALL)
    public SignService signService() {
        return new ComposableSignService((SignParameterExtractor)new DefaultExtractor(), (SignProvider)new DefaultSignProvider());
    }

    @Bean
    public ShenyuPlugin signPlugin(SignService signService, ServerCodecConfigurer configurer) {
        return new SignPlugin(configurer.getReaders(), signService);
    }

    @Bean
    public AuthDataSubscriber signAuthDataSubscriber() {
        return new SignAuthDataSubscriber();
    }

    @Bean
    public PluginDataHandler signPluginDataHandler() {
        return new SignPluginDataHandler();
    }
}

