/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.common.tracer.core.appender.self;

import com.alipay.common.tracer.core.appender.file.AbstractRollingFileAppender;
import com.alipay.common.tracer.core.appender.file.TimedRollingFileAppender;
import com.alipay.common.tracer.core.appender.self.Timestamp;
import com.alipay.common.tracer.core.configuration.SofaTracerConfiguration;
import com.alipay.common.tracer.core.utils.StringUtils;
import com.alipay.common.tracer.core.utils.TracerUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public class SynchronizingSelfLog {
    private static final String ERROR_PREFIX = "[ERROR] ";
    private static final String WARN_PREFIX = "[WARN]  ";
    private static final String INFO_PREFIX = "[INFO]  ";
    protected static final String SELF_LOG_FILE = "sync.log";
    private static AbstractRollingFileAppender selfAppender;

    public static void error(String log, Throwable e) {
        try {
            String timestamp = Timestamp.currentTime();
            StringWriter sw = new StringWriter(4096);
            PrintWriter pw = new PrintWriter((Writer)sw, false);
            pw.append(timestamp).append(ERROR_PREFIX).append(log).append("\r\n");
            e.printStackTrace(pw);
            pw.println();
            pw.flush();
            selfAppender.append(sw.toString());
            selfAppender.flush();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void errorWithTraceId(String log, Throwable e) {
        try {
            String timestamp = Timestamp.currentTime();
            StringWriter sw = new StringWriter(4096);
            PrintWriter pw = new PrintWriter((Writer)sw, false);
            pw.append(timestamp).append(ERROR_PREFIX).append("[").append(TracerUtils.getTraceId()).append("]").append(log).append("\r\n");
            e.printStackTrace(pw);
            pw.println();
            pw.flush();
            selfAppender.append(sw.toString());
            selfAppender.flush();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void error(String log) {
        SynchronizingSelfLog.doLog(log, ERROR_PREFIX);
    }

    public static void errorWithTraceId(String log, String traceId) {
        SynchronizingSelfLog.doLog(log, "[ERROR] [" + traceId + "]");
    }

    public static void errorWithTraceId(String log) {
        SynchronizingSelfLog.doLog(log, "[ERROR] [" + TracerUtils.getTraceId() + "]");
    }

    public static void warn(String log) {
        SynchronizingSelfLog.doLog(log, WARN_PREFIX);
    }

    public static void info(String log) {
        SynchronizingSelfLog.doLog(log, INFO_PREFIX);
    }

    public static void infoWithTraceId(String log) {
        SynchronizingSelfLog.doLog(log, "[INFO]  [" + TracerUtils.getTraceId() + "]");
    }

    public static void flush() {
        selfAppender.flush();
    }

    private static void doLog(String log, String prefix) {
        try {
            String timestamp = Timestamp.currentTime();
            StringBuilder sb = new StringBuilder();
            sb.append(timestamp).append(prefix).append(log).append("\r\n");
            selfAppender.append(sb.toString());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static {
        String globalLogReserveDay = SofaTracerConfiguration.getProperty("tracer_global_log_reserve_day", String.valueOf(7));
        String rollingPolicy = SofaTracerConfiguration.getProperty("tracer_global_rolling_policy");
        if (StringUtils.isBlank(rollingPolicy)) {
            rollingPolicy = "'.'yyyy-MM-dd";
        }
        selfAppender = new TimedRollingFileAppender(SELF_LOG_FILE, rollingPolicy, String.valueOf(globalLogReserveDay));
    }
}

