/*
 * Decompiled with CFR 0.152.
 */
package shade.polaris.com.fasterxml.jackson.databind.deser.std;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import shade.polaris.com.fasterxml.jackson.core.JsonParser;
import shade.polaris.com.fasterxml.jackson.core.JsonToken;
import shade.polaris.com.fasterxml.jackson.databind.DeserializationContext;
import shade.polaris.com.fasterxml.jackson.databind.JsonMappingException;
import shade.polaris.com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import shade.polaris.com.fasterxml.jackson.databind.type.LogicalType;

public class AtomicBooleanDeserializer
extends StdScalarDeserializer<AtomicBoolean> {
    private static final long serialVersionUID = 1L;

    public AtomicBooleanDeserializer() {
        super(AtomicBoolean.class);
    }

    @Override
    public AtomicBoolean deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t = p.currentToken();
        if (t == JsonToken.VALUE_TRUE) {
            return new AtomicBoolean(true);
        }
        if (t == JsonToken.VALUE_FALSE) {
            return new AtomicBoolean(false);
        }
        Boolean b = this._parseBoolean(p, ctxt, AtomicBoolean.class);
        return b == null ? null : new AtomicBoolean(b);
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Boolean;
    }

    @Override
    public Object getEmptyValue(DeserializationContext ctxt) throws JsonMappingException {
        return new AtomicBoolean(false);
    }
}

