/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.cache.filter;

import java.io.Serializable;
import org.apache.dubbo.cache.Cache;
import org.apache.dubbo.cache.CacheFactory;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.utils.ConfigUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.AsyncRpcResult;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;

@Activate(group={"consumer", "provider"}, value={"cache"})
public class CacheFilter
implements Filter {
    private CacheFactory cacheFactory;

    public void setCacheFactory(CacheFactory cacheFactory) {
        this.cacheFactory = cacheFactory;
    }

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        if (this.cacheFactory == null || ConfigUtils.isEmpty(invoker.getUrl().getMethodParameter(invocation.getMethodName(), "cache"))) {
            return invoker.invoke(invocation);
        }
        Cache cache = this.cacheFactory.getCache(invoker.getUrl(), invocation);
        if (cache == null) {
            return invoker.invoke(invocation);
        }
        String key = StringUtils.toArgumentString(invocation.getArguments());
        Object value = cache.get(key);
        return value != null ? this.onCacheValuePresent(invocation, value) : this.onCacheValueNotPresent(invoker, invocation, cache, key);
    }

    private Result onCacheValuePresent(Invocation invocation, Object value) {
        if (value instanceof ValueWrapper) {
            return AsyncRpcResult.newDefaultAsyncResult(((ValueWrapper)value).get(), invocation);
        }
        return AsyncRpcResult.newDefaultAsyncResult(value, invocation);
    }

    private Result onCacheValueNotPresent(Invoker<?> invoker, Invocation invocation, Cache cache, String key) {
        Result result = invoker.invoke(invocation);
        if (!result.hasException()) {
            cache.put(key, new ValueWrapper(result.getValue()));
        }
        return result;
    }

    static class ValueWrapper
    implements Serializable {
        private static final long serialVersionUID = -1777337318019193256L;
        private final Object value;

        public ValueWrapper(Object value) {
            this.value = value;
        }

        public Object get() {
            return this.value;
        }
    }
}

