/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.dubbo.common.config.InmemoryConfiguration;
import org.apache.dubbo.common.config.ModuleEnvironment;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.common.utils.MethodUtils;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.AbstractMethodConfig;
import org.apache.dubbo.config.ArgumentConfig;
import org.apache.dubbo.config.annotation.Method;
import org.apache.dubbo.config.support.Parameter;
import org.apache.dubbo.rpc.model.AsyncMethodInfo;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ScopeModelUtil;

public class MethodConfig
extends AbstractMethodConfig {
    private static final long serialVersionUID = 884908855422675941L;
    private String name;
    private Integer stat;
    private Boolean retry;
    private Boolean reliable;
    private Integer executes;
    private Boolean deprecated;
    private Boolean sticky;
    private Boolean isReturn;
    private Object oninvoke;
    private String oninvokeMethod;
    private Object onreturn;
    private String onreturnMethod;
    private Object onthrow;
    private String onthrowMethod;
    private List<ArgumentConfig> arguments;
    private String service;
    private String serviceId;
    private String parentPrefix;

    public MethodConfig() {
    }

    public MethodConfig(ModuleModel moduleModel) {
        super(moduleModel);
    }

    @Deprecated
    public MethodConfig(Method method) {
        String methodName;
        String ref;
        int index;
        this.appendAnnotation(Method.class, method);
        this.setReturn(method.isReturn());
        String split = ".";
        if (!"".equals(method.oninvoke()) && method.oninvoke().lastIndexOf(split) > 0) {
            index = method.oninvoke().lastIndexOf(split);
            ref = method.oninvoke().substring(0, index);
            methodName = method.oninvoke().substring(index + 1);
            this.setOninvoke(ref);
            this.setOninvokeMethod(methodName);
        }
        if (!"".equals(method.onreturn()) && method.onreturn().lastIndexOf(split) > 0) {
            index = method.onreturn().lastIndexOf(split);
            ref = method.onreturn().substring(0, index);
            methodName = method.onreturn().substring(index + 1);
            this.setOnreturn(ref);
            this.setOnreturnMethod(methodName);
        }
        if (!"".equals(method.onthrow()) && method.onthrow().lastIndexOf(split) > 0) {
            index = method.onthrow().lastIndexOf(split);
            ref = method.onthrow().substring(0, index);
            methodName = method.onthrow().substring(index + 1);
            this.setOnthrow(ref);
            this.setOnthrowMethod(methodName);
        }
        if (method.arguments() != null && method.arguments().length != 0) {
            ArrayList<ArgumentConfig> argumentConfigs = new ArrayList<ArgumentConfig>(method.arguments().length);
            this.setArguments(argumentConfigs);
            for (int i = 0; i < method.arguments().length; ++i) {
                ArgumentConfig argumentConfig = new ArgumentConfig(method.arguments()[i]);
                argumentConfigs.add(argumentConfig);
            }
        }
    }

    @Deprecated
    public static List<MethodConfig> constructMethodConfig(Method[] methods) {
        if (methods != null && methods.length != 0) {
            ArrayList<MethodConfig> methodConfigs = new ArrayList<MethodConfig>(methods.length);
            for (int i = 0; i < methods.length; ++i) {
                MethodConfig methodConfig = new MethodConfig(methods[i]);
                methodConfigs.add(methodConfig);
            }
            return methodConfigs;
        }
        return Collections.emptyList();
    }

    @Override
    @Parameter(excluded=true, attribute=false)
    public List<String> getPrefixes() {
        if (this.parentPrefix != null) {
            ArrayList<String> prefixes = new ArrayList<String>();
            prefixes.add(this.parentPrefix + "." + this.getName());
            return prefixes;
        }
        throw new IllegalStateException("The parent prefix of MethodConfig is null");
    }

    @Override
    protected void processExtraRefresh(String preferredPrefix, InmemoryConfiguration subPropsConfiguration) {
        if (this.getArguments() != null && this.getArguments().size() > 0) {
            for (ArgumentConfig argument : this.getArguments()) {
                this.refreshArgument(argument, subPropsConfiguration);
            }
        }
    }

    private void refreshArgument(ArgumentConfig argument, InmemoryConfiguration subPropsConfiguration) {
        if (argument.getIndex() != null && argument.getIndex() >= 0) {
            String prefix = argument.getIndex() + ".";
            ModuleEnvironment environment = this.getScopeModel().modelEnvironment();
            List<java.lang.reflect.Method> methods = MethodUtils.getMethods(argument.getClass(), method -> method.getDeclaringClass() != Object.class);
            for (java.lang.reflect.Method method2 : methods) {
                String propertyName;
                if (!MethodUtils.isSetter(method2) || StringUtils.isEquals(propertyName = MethodConfig.extractPropertyName(method2.getName()), "index") || StringUtils.isEquals(propertyName, "type")) continue;
                String kebabPropertyName = prefix + StringUtils.convertToSplitName(propertyName, "-");
                try {
                    String value = StringUtils.trim(subPropsConfiguration.getString(kebabPropertyName));
                    if (!StringUtils.hasText(value) || !ClassUtils.isTypeMatch(method2.getParameterTypes()[0], value)) continue;
                    value = environment.resolvePlaceholders(value);
                    method2.invoke((Object)argument, ClassUtils.convertPrimitive(ScopeModelUtil.getFrameworkModel(this.getScopeModel()), method2.getParameterTypes()[0], value));
                }
                catch (Exception e) {
                    logger.info("Failed to override the property " + method2.getName() + " in " + this.getClass().getSimpleName() + ", please make sure every property has getter/setter method provided.");
                }
            }
        }
    }

    public AsyncMethodInfo convertMethodConfig2AsyncInfo() {
        if (this.getOninvoke() == null && this.getOnreturn() == null && this.getOnthrow() == null) {
            return null;
        }
        if (Boolean.FALSE.equals(this.isReturn()) && (this.getOnreturn() != null || this.getOnthrow() != null)) {
            throw new IllegalStateException("method config error : return attribute must be set true when on-return or on-throw has been set.");
        }
        AsyncMethodInfo asyncMethodInfo = new AsyncMethodInfo();
        asyncMethodInfo.setOninvokeInstance(this.getOninvoke());
        asyncMethodInfo.setOnreturnInstance(this.getOnreturn());
        asyncMethodInfo.setOnthrowInstance(this.getOnthrow());
        try {
            if (StringUtils.isNotEmpty(this.oninvokeMethod)) {
                asyncMethodInfo.setOninvokeMethod(this.getMethodByName(this.getOninvoke().getClass(), this.oninvokeMethod));
            }
            if (StringUtils.isNotEmpty(this.onreturnMethod)) {
                asyncMethodInfo.setOnreturnMethod(this.getMethodByName(this.getOnreturn().getClass(), this.onreturnMethod));
            }
            if (StringUtils.isNotEmpty(this.onthrowMethod)) {
                asyncMethodInfo.setOnthrowMethod(this.getMethodByName(this.getOnthrow().getClass(), this.onthrowMethod));
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        return asyncMethodInfo;
    }

    private java.lang.reflect.Method getMethodByName(Class<?> clazz, String methodName) {
        try {
            return ReflectUtils.findMethodByMethodName(clazz, methodName);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    protected void checkDefault() {
        super.checkDefault();
        if (this.isReturn() == null) {
            this.setReturn(true);
        }
        if (this.getSent() == null) {
            this.setSent(true);
        }
    }

    @Parameter(excluded=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getStat() {
        return this.stat;
    }

    @Deprecated
    public void setStat(Integer stat) {
        this.stat = stat;
    }

    @Deprecated
    public Boolean isRetry() {
        return this.retry;
    }

    @Deprecated
    public void setRetry(Boolean retry) {
        this.retry = retry;
    }

    @Deprecated
    public Boolean isReliable() {
        return this.reliable;
    }

    @Deprecated
    public void setReliable(Boolean reliable) {
        this.reliable = reliable;
    }

    public Integer getExecutes() {
        return this.executes;
    }

    public void setExecutes(Integer executes) {
        this.executes = executes;
    }

    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
    }

    public List<ArgumentConfig> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<? extends ArgumentConfig> arguments) {
        this.arguments = arguments;
    }

    public Boolean getSticky() {
        return this.sticky;
    }

    public void setSticky(Boolean sticky) {
        this.sticky = sticky;
    }

    @Parameter(key="onreturn.instance", excluded=true, attribute=true)
    public Object getOnreturn() {
        return this.onreturn;
    }

    public void setOnreturn(Object onreturn) {
        this.onreturn = onreturn;
    }

    @Parameter(key="onreturn.method", excluded=true, attribute=true)
    public String getOnreturnMethod() {
        return this.onreturnMethod;
    }

    public void setOnreturnMethod(String onreturnMethod) {
        this.onreturnMethod = onreturnMethod;
    }

    @Parameter(key="onthrow.instance", excluded=true, attribute=true)
    public Object getOnthrow() {
        return this.onthrow;
    }

    public void setOnthrow(Object onthrow) {
        this.onthrow = onthrow;
    }

    @Parameter(key="onthrow.method", excluded=true, attribute=true)
    public String getOnthrowMethod() {
        return this.onthrowMethod;
    }

    public void setOnthrowMethod(String onthrowMethod) {
        this.onthrowMethod = onthrowMethod;
    }

    @Parameter(key="oninvoke.instance", excluded=true, attribute=true)
    public Object getOninvoke() {
        return this.oninvoke;
    }

    public void setOninvoke(Object oninvoke) {
        this.oninvoke = oninvoke;
    }

    @Parameter(key="oninvoke.method", excluded=true, attribute=true)
    public String getOninvokeMethod() {
        return this.oninvokeMethod;
    }

    public void setOninvokeMethod(String oninvokeMethod) {
        this.oninvokeMethod = oninvokeMethod;
    }

    public Boolean isReturn() {
        return this.isReturn;
    }

    public void setReturn(Boolean isReturn) {
        this.isReturn = isReturn;
    }

    @Parameter(excluded=true, attribute=false)
    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    @Parameter(excluded=true, attribute=false)
    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public void setParentPrefix(String parentPrefix) {
        this.parentPrefix = parentPrefix;
    }

    @Parameter(excluded=true, attribute=false)
    public String getParentPrefix() {
        return this.parentPrefix;
    }

    public void addArgument(ArgumentConfig argumentConfig) {
        if (this.arguments == null) {
            this.arguments = new ArrayList<ArgumentConfig>();
        }
        this.arguments.add(argumentConfig);
    }
}

