/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest.annotation.param.parse.consumer;

import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.metadata.rest.ArgInfo;
import org.apache.dubbo.metadata.rest.ParamType;
import org.apache.dubbo.remoting.http.RequestTemplate;
import org.apache.dubbo.rpc.protocol.rest.annotation.param.parse.consumer.BaseConsumerParamParser;
import org.apache.dubbo.rpc.protocol.rest.annotation.param.parse.consumer.ConsumerParseContext;

@Activate(value={"consumer-header"})
public class HeaderConsumerParamParser
implements BaseConsumerParamParser {
    @Override
    public void parse(ConsumerParseContext parseContext, ArgInfo argInfo) {
        List<Object> args = parseContext.getArgs();
        RequestTemplate requestTemplate = parseContext.getRequestTemplate();
        Object headerValue = args.get(argInfo.getIndex());
        if (headerValue == null) {
            return;
        }
        if (Map.class.isAssignableFrom(argInfo.getParamType())) {
            Map headerValues = (Map)headerValue;
            for (Object name : headerValues.keySet()) {
                requestTemplate.addHeader(String.valueOf(name), headerValues.get(name));
            }
        } else {
            requestTemplate.addHeader(argInfo.getAnnotationNameAttribute(), headerValue);
        }
    }

    @Override
    public boolean paramTypeMatch(ArgInfo argInfo) {
        return ParamType.HEADER.supportAnno(argInfo.getParamAnnotationType());
    }
}

