/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest.util;

import java.lang.reflect.Method;
import java.util.Map;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.rpc.protocol.rest.util.ReflectUtils;

public class MultiValueCreator {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(MultiValueCreator.class);
    private static final String SPRING_MultiValueMapImpl = "org.springframework.util.LinkedMultiValueMap";
    private static final String SPRING_MultiValueMap = "org.springframework.util.MultiValueMap";
    private static final String JAVAX_MultiValueMapImpl = "org.jboss.resteasy.specimpl.MultivaluedMapImpl";
    private static final String JAVAX_MultiValueMap = "javax.ws.rs.core.MultivaluedMap";
    private static Class springMultiValueMapImplClass = null;
    private static Class springMultiValueMapClass = null;
    private static Method springMultiValueMapAdd = null;
    private static Class jaxrsMultiValueMapImplClass = null;
    private static Class jaxrsMultiValueMapClass = null;
    private static Method jaxrsMultiValueMapAdd = null;

    public static Object providerCreateMultiValueMap(Class<?> targetType) {
        try {
            if (MultiValueCreator.typeJudge(springMultiValueMapClass, targetType)) {
                return springMultiValueMapImplClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            if (MultiValueCreator.typeJudge(jaxrsMultiValueMapClass, targetType)) {
                return jaxrsMultiValueMapImplClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            logger.error("", e.getMessage(), "current param type is: " + targetType + "and support type is : " + springMultiValueMapClass + "or" + jaxrsMultiValueMapClass, "dubbo rest form content-type param construct error,un support  param type: ", e);
        }
        return null;
    }

    private static boolean typeJudge(Class<?> parent, Class<?> targetType) {
        if (parent == null) {
            return false;
        }
        if (!Map.class.isAssignableFrom(targetType)) {
            return true;
        }
        return parent.isAssignableFrom(targetType) || parent.equals(targetType);
    }

    public static void add(Object multiValueMap, String key, Object value) {
        try {
            if (multiValueMap == null) {
                return;
            }
            Method multiValueMapAdd = null;
            if (springMultiValueMapImplClass.equals(multiValueMap.getClass())) {
                multiValueMapAdd = springMultiValueMapAdd;
            } else if (jaxrsMultiValueMapImplClass.equals(multiValueMap.getClass())) {
                multiValueMapAdd = jaxrsMultiValueMapAdd;
            }
            ReflectUtils.invokeAndTryCatch(multiValueMap, multiValueMapAdd, new Object[]{key, value});
        }
        catch (Exception e) {
            logger.error("", e.getMessage(), "", "dubbo rest form content-type param add data  error: ", e);
        }
    }

    static {
        springMultiValueMapClass = ReflectUtils.findClassTryException(SPRING_MultiValueMap);
        springMultiValueMapImplClass = ReflectUtils.findClassTryException(SPRING_MultiValueMapImpl);
        springMultiValueMapAdd = ReflectUtils.getMethodByName(springMultiValueMapImplClass, "add");
        jaxrsMultiValueMapClass = ReflectUtils.findClassTryException(JAVAX_MultiValueMap);
        jaxrsMultiValueMapImplClass = ReflectUtils.findClassTryException(JAVAX_MultiValueMapImpl);
        jaxrsMultiValueMapAdd = ReflectUtils.getMethodByName(jaxrsMultiValueMapImplClass, "add");
    }
}

