/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.transport;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2GoAwayFrame;
import io.netty.util.ReferenceCountUtil;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.api.connection.ConnectionHandler;

public class TripleGoAwayHandler
extends ChannelDuplexHandler {
    private static final Logger logger = LoggerFactory.getLogger(TripleGoAwayHandler.class);

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof Http2GoAwayFrame) {
            ConnectionHandler connectionHandler = (ConnectionHandler)ctx.pipeline().get("connectionHandler");
            if (logger.isInfoEnabled()) {
                logger.info("Receive go away frame of " + ctx.channel().localAddress() + " -> " + ctx.channel().remoteAddress() + " and will reconnect later.");
            }
            connectionHandler.onGoAway(ctx.channel());
            ReferenceCountUtil.release((Object)msg);
            return;
        }
        super.channelRead(ctx, msg);
    }
}

