/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.net.client.ticket;

import com.qq.tars.net.client.Callback;
import com.qq.tars.net.client.ticket.TicketListener;
import com.qq.tars.net.client.ticket.TicketManager;
import com.qq.tars.net.client.ticket.TimeoutManager;
import com.qq.tars.net.core.Request;
import com.qq.tars.net.core.nio.SelectorManager;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class Ticket<T> {
    public static final int DEFAULT_TICKET_NUMBER = -1;
    private CountDownLatch latch = new CountDownLatch(1);
    private T response = null;
    private Request request = null;
    private volatile boolean expired = false;
    protected long timeout = 1000L;
    public long startTime = System.currentTimeMillis();
    private Callback<T> callback = null;
    private int ticketNumber = -1;
    private static TicketListener ticketListener = null;
    private SelectorManager selectorManager = null;
    Future<?> timeoutFuture;
    AtomicBoolean hasRun = new AtomicBoolean(false);

    public Future<?> getTimeoutFuture() {
        return this.timeoutFuture;
    }

    public void setTimeoutFuture(Future<?> timeoutFuture) {
        this.timeoutFuture = timeoutFuture;
    }

    public SelectorManager getSelectorManager() {
        return this.selectorManager;
    }

    public void setSelectorManager(SelectorManager selectorManager) {
        this.selectorManager = selectorManager;
    }

    public Ticket(Request request, long timeout) {
        this.request = request;
        this.ticketNumber = request.getTicketNumber();
        this.timeout = timeout;
    }

    public Ticket(Request request, long timeout, SelectorManager selectorManager) {
        this.request = request;
        this.ticketNumber = request.getTicketNumber();
        this.timeout = timeout;
        this.selectorManager = selectorManager;
    }

    public Request request() {
        return this.request;
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        boolean status = this.latch.await(timeout, unit);
        return status && !this.expired;
    }

    public void expired() {
        if (this.hasRun.compareAndSet(false, true)) {
            this.expired = true;
            if (this.callback != null) {
                if (this.getTimeoutFuture() != null && (this.getTimeoutFuture().isDone() || this.getTimeoutFuture().isCancelled())) {
                    System.out.println("task has run or canceled.");
                } else {
                    this.selectorManager.getThreadPool().execute(() -> this.callback.onExpired());
                }
            }
            this.countDown();
            if (ticketListener != null) {
                ticketListener.onResponseExpired(this);
            }
        } else {
            System.out.println("expired has run.");
        }
    }

    public void countDown() {
        this.latch.countDown();
    }

    public boolean isDone() {
        return this.latch.getCount() == 0L;
    }

    public void notifyResponse(T response) {
        TicketManager.removeTicket(this.ticketNumber);
        if (this.timeoutFuture != null) {
            TimeoutManager.cancelTimeoutTask(this);
        }
        this.response = response;
        this.countDown();
        if (this.callback != null) {
            this.callback.onCompleted(response);
        }
        if (ticketListener != null) {
            ticketListener.onResponseReceived(this);
        }
    }

    public T response() {
        return this.response;
    }

    public Callback<T> getCallback() {
        return this.callback;
    }

    public void setCallback(Callback<T> callback) {
        this.callback = callback;
    }

    public int getTicketNumber() {
        return this.ticketNumber;
    }

    public static void setTicketListener(TicketListener listener) {
        ticketListener = listener;
    }
}

