/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.config;

import com.weibo.api.motan.cluster.support.ClusterSupport;
import com.weibo.api.motan.common.MotanConstants;
import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.config.AbstractRefererConfig;
import com.weibo.api.motan.config.BasicRefererInterfaceConfig;
import com.weibo.api.motan.config.MethodConfig;
import com.weibo.api.motan.config.ProtocolConfig;
import com.weibo.api.motan.config.annotation.ConfigDesc;
import com.weibo.api.motan.config.handler.ConfigHandler;
import com.weibo.api.motan.core.extension.ExtensionLoader;
import com.weibo.api.motan.exception.MotanErrorMsgConstant;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.proxy.ProxyFactory;
import com.weibo.api.motan.registry.RegistryService;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.util.CollectionUtil;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.UrlUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;

public class RefererConfig<T>
extends AbstractRefererConfig {
    private static final long serialVersionUID = -2299754608229467887L;
    private Class<T> interfaceClass;
    private String serviceInterface;
    protected List<MethodConfig> methods;
    private String directUrl;
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private T ref;
    private BasicRefererInterfaceConfig basicReferer;
    private List<ClusterSupport<T>> clusterSupports;

    public String getServiceInterface() {
        return this.serviceInterface;
    }

    public void setServiceInterface(String serviceInterface) {
        this.serviceInterface = serviceInterface;
    }

    public List<MethodConfig> getMethods() {
        return this.methods;
    }

    public void setMethods(List<MethodConfig> methods) {
        this.methods = methods;
    }

    public void setMethods(MethodConfig methods) {
        this.methods = Collections.singletonList(methods);
    }

    public boolean hasMethods() {
        return this.methods != null && !this.methods.isEmpty();
    }

    public T getRef() {
        if (this.ref == null) {
            this.initRef();
        }
        return this.ref;
    }

    public synchronized void initRef() {
        if (this.initialized.get()) {
            return;
        }
        try {
            this.interfaceClass = Class.forName(this.interfaceClass.getName(), true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new MotanFrameworkException("RefererConfig initRef Error: Class not found " + this.interfaceClass.getName(), e, MotanErrorMsgConstant.FRAMEWORK_INIT_ERROR);
        }
        this.checkInterfaceAndMethods(this.interfaceClass, this.methods);
        if (this.meshClient != null) {
            this.initMeshClientRef();
        } else {
            this.initClusterRef();
        }
        this.initialized.set(true);
    }

    private void initClusterRef() {
        if (CollectionUtil.isEmpty(this.protocols)) {
            throw new MotanFrameworkException(String.format("%s RefererConfig is malformed, for protocol not set correctly!", this.interfaceClass.getName()));
        }
        this.clusterSupports = new ArrayList<ClusterSupport<T>>(this.protocols.size());
        ArrayList clusters = new ArrayList(this.protocols.size());
        String proxy = null;
        ConfigHandler configHandler = ExtensionLoader.getExtensionLoader(ConfigHandler.class).getExtension("default");
        this.loadRegistryUrls();
        String localIp = this.getLocalHostAddress();
        for (ProtocolConfig protocol : this.protocols) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(URLParamType.nodeType.getName(), "referer");
            params.put(URLParamType.version.getName(), URLParamType.version.getValue());
            params.put(URLParamType.refreshTimestamp.getName(), String.valueOf(System.currentTimeMillis()));
            RefererConfig.collectConfigParams(params, protocol, this.basicReferer, this.extConfig, this);
            RefererConfig.collectMethodConfigParams(params, this.getMethods());
            String path = StringUtils.isBlank((CharSequence)this.serviceInterface) ? this.interfaceClass.getName() : this.serviceInterface;
            URL refUrl = new URL(protocol.getName(), localIp, 0, path, params);
            ClusterSupport<T> clusterSupport = this.createClusterSupport(refUrl, configHandler);
            this.clusterSupports.add(clusterSupport);
            clusters.add(clusterSupport.getCluster());
            if (proxy != null) continue;
            proxy = this.getProxyType(refUrl);
        }
        this.ref = configHandler.refer(this.interfaceClass, clusters, proxy);
    }

    private void initMeshClientRef() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(URLParamType.nodeType.getName(), "referer");
        RefererConfig.collectConfigParams(params, this.basicReferer, this.extConfig, this);
        String path = StringUtils.isBlank((CharSequence)this.serviceInterface) ? this.interfaceClass.getName() : this.serviceInterface;
        URL refUrl = new URL("motan2", this.getLocalHostAddress(), 0, path, params);
        ProxyFactory proxyFactory = ExtensionLoader.getExtensionLoader(ProxyFactory.class).getExtension(this.getProxyType(refUrl));
        this.ref = proxyFactory.getProxy(this.interfaceClass, refUrl, this.meshClient);
        LoggerUtil.info("init mesh client referer finish. url:" + refUrl.toFullStr());
    }

    private String getProxyType(URL refUrl) {
        String defaultProxy = StringUtils.isBlank((CharSequence)this.serviceInterface) ? URLParamType.proxy.getValue() : "common";
        return refUrl.getParameter(URLParamType.proxy.getName(), defaultProxy);
    }

    private ClusterSupport<T> createClusterSupport(URL refUrl, ConfigHandler configHandler) {
        LoggerUtil.info("create cluster for refer url :" + refUrl.toFullStr());
        ArrayList<URL> regUrls = new ArrayList<URL>();
        if (StringUtils.isNotBlank((CharSequence)this.directUrl) || "injvm".equals(refUrl.getProtocol())) {
            URL regUrl = new URL("local", "127.0.0.1", 0, RegistryService.class.getName());
            if (StringUtils.isNotBlank((CharSequence)this.directUrl)) {
                String[] dus;
                ArrayList<URL> directUrls = new ArrayList<URL>();
                for (String du : dus = MotanConstants.COMMA_SPLIT_PATTERN.split(this.directUrl)) {
                    if (!du.contains(":")) continue;
                    String[] hostPort = du.split(":");
                    URL durl = refUrl.createCopy();
                    durl.setHost(hostPort[0].trim());
                    durl.setPort(Integer.parseInt(hostPort[1].trim()));
                    durl.addParameter(URLParamType.nodeType.getName(), "service");
                    directUrls.add(durl);
                }
                String directUrlsString = UrlUtils.urlsToString(directUrls);
                if (StringUtils.isNotBlank((CharSequence)directUrlsString)) {
                    regUrl.addParameter(URLParamType.directUrl.getName(), directUrlsString);
                } else {
                    LoggerUtil.warn("parse directUrl string is empty. directUrl:" + this.directUrl);
                }
            }
            regUrls.add(regUrl);
        } else {
            if (this.registryUrls == null || this.registryUrls.isEmpty()) {
                throw new IllegalStateException(String.format("No registry to reference %s on the consumer %s , please config <motan:registry address=\"...\" /> in your spring config.", this.interfaceClass, "127.0.0.1"));
            }
            for (URL url : this.registryUrls) {
                regUrls.add(url.createCopy());
            }
        }
        return configHandler.buildClusterSupport(this.interfaceClass, regUrls, refUrl);
    }

    public synchronized void destroy() {
        if (this.clusterSupports != null) {
            for (ClusterSupport<T> clusterSupport : this.clusterSupports) {
                clusterSupport.destroy();
            }
        }
        this.ref = null;
        this.initialized.set(false);
    }

    public void setInterface(Class<T> interfaceClass) {
        if (interfaceClass != null && !interfaceClass.isInterface()) {
            throw new IllegalStateException("The interface class " + interfaceClass + " is not a interface!");
        }
        this.interfaceClass = interfaceClass;
    }

    public Class<?> getInterface() {
        return this.interfaceClass;
    }

    public String getDirectUrl() {
        return this.directUrl;
    }

    public void setDirectUrl(String directUrl) {
        this.directUrl = directUrl;
    }

    @ConfigDesc(excluded=true)
    public BasicRefererInterfaceConfig getBasicReferer() {
        return this.basicReferer;
    }

    public void setBasicReferer(BasicRefererInterfaceConfig basicReferer) {
        this.basicReferer = basicReferer;
    }

    public List<ClusterSupport<T>> getClusterSupports() {
        return this.clusterSupports;
    }

    public AtomicBoolean getInitialized() {
        return this.initialized;
    }
}

