/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.codec.sofahessian.serialize;

import com.alipay.hessian.generic.model.GenericObject;
import com.alipay.sofa.common.config.SofaConfigs;
import com.alipay.sofa.rpc.common.config.RpcConfigKeys;

public class GenericCustomThrowableDeterminer {
    private static final boolean GENERIC_THROW_EXCEPTION = (Boolean)SofaConfigs.getOrDefault(RpcConfigKeys.GENERIC_THROW_EXCEPTION);
    private static final String[] THROWABLE_FIELDS = (String[])SofaConfigs.getOrDefault(RpcConfigKeys.GENERIC_THROWABLE_FIELDS);

    public static Object judgeCustomThrowableForGenericObject(Object appObject) {
        if (!GENERIC_THROW_EXCEPTION || appObject == null) {
            return appObject;
        }
        if (!(appObject instanceof GenericObject)) {
            return appObject;
        }
        for (String field : THROWABLE_FIELDS) {
            if (((GenericObject)appObject).hasField(field)) continue;
            return appObject;
        }
        return new RuntimeException("occur business exception, but type=" + ((GenericObject)appObject).getType() + " class is not found, error: " + appObject);
    }

    public static boolean isGenericThrowException() {
        return GENERIC_THROW_EXCEPTION;
    }
}

