/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.log;

import com.alipay.sofa.rpc.common.SofaConfigs;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class TimeWaitLogger {
    private final long waitTime;
    private volatile long lastLogTime;
    private final boolean disabled;

    public TimeWaitLogger(long waitTimeMills) {
        this.waitTime = waitTimeMills;
        this.disabled = SofaConfigs.getBooleanValue("sofa.rpc.log.disableTimeWaitLog", false);
    }

    public void logWithRunnable(Runnable runnable) {
        long currentTimeMillis = System.currentTimeMillis();
        if (this.disabled) {
            runnable.run();
        } else if (currentTimeMillis > this.lastLogTime + this.waitTime) {
            this.lastLogTime = currentTimeMillis;
            runnable.run();
        }
    }

    public <T> void logWithConsumer(Consumer<T> consumer, T t) {
        long currentTimeMillis = System.currentTimeMillis();
        if (this.disabled) {
            consumer.accept(t);
        } else if (currentTimeMillis > this.lastLogTime + this.waitTime) {
            this.lastLogTime = currentTimeMillis;
            consumer.accept(t);
        }
    }

    public <T, R> void logWithBiConsume(BiConsumer<T, R> biConsumer, T r, R executor) {
        long currentTimeMillis = System.currentTimeMillis();
        if (this.disabled) {
            biConsumer.accept(r, executor);
        } else if (currentTimeMillis > this.lastLogTime + this.waitTime) {
            this.lastLogTime = currentTimeMillis;
            biConsumer.accept(r, executor);
        }
    }
}

