/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.registry.kubernetes;

import com.alipay.sofa.rpc.client.ProviderGroup;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.listener.ProviderInfoListener;
import com.alipay.sofa.rpc.registry.kubernetes.KubernetesRegistryHelper;
import com.alipay.sofa.rpc.registry.utils.RegistryUtils;
import io.fabric8.kubernetes.api.model.Pod;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class KubernetesRegistryProviderWatcher {
    private final ConcurrentMap<ConsumerConfig, List<ProviderInfoListener>> providerListenerMap = new ConcurrentHashMap<ConsumerConfig, List<ProviderInfoListener>>();

    public void addProviderListener(ConsumerConfig consumerConfig, ProviderInfoListener listener) {
        if (listener != null) {
            RegistryUtils.initOrAddList(this.providerListenerMap, consumerConfig, listener);
        }
    }

    public void removeProviderListener(ConsumerConfig consumerConfig) {
        this.providerListenerMap.remove(consumerConfig);
    }

    public void updateProviders(ConsumerConfig config, List<Pod> podList) {
        List providerInfoListeners = (List)this.providerListenerMap.get(config);
        if (CommonUtils.isNotEmpty(providerInfoListeners)) {
            List<ProviderInfo> providerInfos = KubernetesRegistryHelper.convertPodsToProviders(podList, config);
            for (ProviderInfoListener providerInfoListener : providerInfoListeners) {
                providerInfoListener.updateAllProviders(Collections.singletonList(new ProviderGroup().addAll(providerInfos)));
            }
        }
    }
}

