/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.transport.http;

import com.alipay.sofa.rpc.common.utils.NetUtils;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.transport.http.AbstractHttpClientHandler;
import com.alipay.sofa.rpc.transport.netty.NettyHelper;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.util.internal.PlatformDependent;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;

public class Http2ClientChannelHandler
extends SimpleChannelInboundHandler<FullHttpResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Http2ClientChannelHandler.class);
    private final Map<Integer, Map.Entry<ChannelFuture, AbstractHttpClientHandler>> streamIdPromiseMap = PlatformDependent.newConcurrentHashMap();

    public Map.Entry<ChannelFuture, AbstractHttpClientHandler> put(int streamId, ChannelFuture writeFuture, AbstractHttpClientHandler promise) {
        return this.streamIdPromiseMap.put(streamId, new AbstractMap.SimpleEntry<ChannelFuture, AbstractHttpClientHandler>(writeFuture, promise));
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpResponse msg) throws Exception {
        HttpHeaders headers = msg.headers();
        Integer streamId = headers.getInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text());
        if (streamId == null) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("HttpResponseHandler unexpected message received: {}, data is {}", msg.toString(), NettyHelper.toString(msg.content()));
            }
            return;
        }
        Map.Entry<ChannelFuture, AbstractHttpClientHandler> entry = this.removePromise(streamId);
        if (entry == null) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Message received for unknown stream id {}, msg is {}, data is {}", streamId, msg.toString(), NettyHelper.toString(msg.content()));
            }
        } else {
            AbstractHttpClientHandler callback = entry.getValue();
            callback.receiveHttpResponse(msg);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        Channel channel = ctx.channel();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Channel inactive: {}", channel);
        }
        SofaRpcException e = new SofaRpcException(250, "Channel " + NetUtils.channelToString(channel.localAddress(), channel.remoteAddress()) + " has been closed, remove future when channel inactive.");
        Iterator<Map.Entry<Integer, Map.Entry<ChannelFuture, AbstractHttpClientHandler>>> it = this.streamIdPromiseMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, Map.Entry<ChannelFuture, AbstractHttpClientHandler>> mapEntry = it.next();
            it.remove();
            Map.Entry<ChannelFuture, AbstractHttpClientHandler> entry = mapEntry.getValue();
            entry.getValue().onException(e);
        }
    }

    public Map.Entry<ChannelFuture, AbstractHttpClientHandler> removePromise(int streamId) {
        return this.streamIdPromiseMap.remove(streamId);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOGGER.error(LogCodes.getLog("020010015"), cause);
    }
}

