/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.context.path.handler;

import java.util.Optional;
import java.util.function.Supplier;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.rule.impl.ContextMappingRuleHandle;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.plugin.base.cache.CommonHandleCache;
import org.apache.shenyu.plugin.base.handler.PluginDataHandler;
import org.apache.shenyu.plugin.base.utils.BeanHolder;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;

public class ContextPathPluginDataHandler
implements PluginDataHandler {
    public static final Supplier<CommonHandleCache<String, ContextMappingRuleHandle>> CACHED_HANDLE = new BeanHolder(CommonHandleCache::new);

    public void handlerSelector(SelectorData selectorData) {
        if (!selectorData.getContinued().booleanValue()) {
            CACHED_HANDLE.get().cachedHandle((Object)CacheKeyUtils.INST.getKey(selectorData.getId(), "default_rule"), (Object)ContextMappingRuleHandle.newInstance());
        }
    }

    public void removeSelector(SelectorData selectorData) {
        CACHED_HANDLE.get().removeHandle((Object)CacheKeyUtils.INST.getKey(selectorData.getId(), "default_rule"));
    }

    public void handlerRule(RuleData ruleData) {
        Optional.ofNullable(ruleData.getHandle()).ifPresent(s -> {
            ContextMappingRuleHandle contextMappingRuleHandle = (ContextMappingRuleHandle)GsonUtils.getInstance().fromJson(s, ContextMappingRuleHandle.class);
            CACHED_HANDLE.get().cachedHandle((Object)CacheKeyUtils.INST.getKey(ruleData), (Object)contextMappingRuleHandle);
        });
    }

    public void removeRule(RuleData ruleData) {
        Optional.ofNullable(ruleData.getHandle()).ifPresent(s -> CACHED_HANDLE.get().removeHandle((Object)CacheKeyUtils.INST.getKey(ruleData)));
    }

    public String pluginNamed() {
        return PluginEnum.CONTEXT_PATH.getName();
    }
}

