/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.sql;

import co.elastic.clients.elasticsearch.sql.Column;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GetAsyncResponse
implements JsonpSerializable {
    private final String id;
    private final boolean isRunning;
    private final boolean isPartial;
    private final List<Column> columns;
    @Nullable
    private final String cursor;
    private final List<List<JsonData>> rows;
    public static final JsonpDeserializer<GetAsyncResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetAsyncResponse::setupGetAsyncResponseDeserializer);

    private GetAsyncResponse(Builder builder) {
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.isRunning = ApiTypeHelper.requireNonNull(builder.isRunning, this, "isRunning");
        this.isPartial = ApiTypeHelper.requireNonNull(builder.isPartial, this, "isPartial");
        this.columns = ApiTypeHelper.unmodifiable(builder.columns);
        this.cursor = builder.cursor;
        this.rows = ApiTypeHelper.unmodifiableRequired(builder.rows, (Object)this, "rows");
    }

    public static GetAsyncResponse of(Function<Builder, ObjectBuilder<GetAsyncResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String id() {
        return this.id;
    }

    public final boolean isRunning() {
        return this.isRunning;
    }

    public final boolean isPartial() {
        return this.isPartial;
    }

    public final List<Column> columns() {
        return this.columns;
    }

    @Nullable
    public final String cursor() {
        return this.cursor;
    }

    public final List<List<JsonData>> rows() {
        return this.rows;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("id");
        generator.write(this.id);
        generator.writeKey("is_running");
        generator.write(this.isRunning);
        generator.writeKey("is_partial");
        generator.write(this.isPartial);
        if (ApiTypeHelper.isDefined(this.columns)) {
            generator.writeKey("columns");
            generator.writeStartArray();
            for (Column column : this.columns) {
                column.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.cursor != null) {
            generator.writeKey("cursor");
            generator.write(this.cursor);
        }
        if (ApiTypeHelper.isDefined(this.rows)) {
            generator.writeKey("rows");
            generator.writeStartArray();
            for (List list : this.rows) {
                generator.writeStartArray();
                if (list != null) {
                    for (JsonData item1 : list) {
                        item1.serialize(generator, mapper);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupGetAsyncResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(Builder::isRunning, JsonpDeserializer.booleanDeserializer(), "is_running");
        op.add(Builder::isPartial, JsonpDeserializer.booleanDeserializer(), "is_partial");
        op.add(Builder::columns, JsonpDeserializer.arrayDeserializer(Column._DESERIALIZER), "columns");
        op.add(Builder::cursor, JsonpDeserializer.stringDeserializer(), "cursor");
        op.add(Builder::rows, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.arrayDeserializer(JsonData._DESERIALIZER)), "rows");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GetAsyncResponse> {
        private String id;
        private Boolean isRunning;
        private Boolean isPartial;
        @Nullable
        private List<Column> columns;
        @Nullable
        private String cursor;
        private List<List<JsonData>> rows;

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder isRunning(boolean value) {
            this.isRunning = value;
            return this;
        }

        public final Builder isPartial(boolean value) {
            this.isPartial = value;
            return this;
        }

        public final Builder columns(List<Column> list) {
            this.columns = Builder._listAddAll(this.columns, list);
            return this;
        }

        public final Builder columns(Column value, Column ... values) {
            this.columns = Builder._listAdd(this.columns, value, values);
            return this;
        }

        public final Builder columns(Function<Column.Builder, ObjectBuilder<Column>> fn) {
            return this.columns(fn.apply(new Column.Builder()).build(), new Column[0]);
        }

        public final Builder cursor(@Nullable String value) {
            this.cursor = value;
            return this;
        }

        public final Builder rows(List<List<JsonData>> list) {
            this.rows = Builder._listAddAll(this.rows, list);
            return this;
        }

        public final Builder rows(List<JsonData> value, List<JsonData> ... values) {
            this.rows = Builder._listAdd(this.rows, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetAsyncResponse build() {
            this._checkSingleUse();
            return new GetAsyncResponse(this);
        }
    }
}

