/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.code;

import com.alipay.sofa.common.space.SpaceId;
import com.alipay.sofa.common.utils.ReportUtil;
import com.alipay.sofa.common.utils.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class LogCode2Description {
    private static final Map<SpaceId, LogCode2Description> LOG_CODE_2_DESCRIPTION_MAP = new ConcurrentHashMap<SpaceId, LogCode2Description>();
    private final String logFormat;
    private final String logPrefix;
    private final Map<String, Pair> codeMap = new ConcurrentHashMap<String, Pair>();
    private String logValueSuffix;

    public static String convert(String spaceName, String code) {
        return LogCode2Description.convert(SpaceId.withSpaceName(spaceName), code);
    }

    public static String convert(SpaceId spaceId, String code) {
        LogCode2Description logCode2Description = LogCode2Description.isCodeSpaceInitialized(spaceId) ? LOG_CODE_2_DESCRIPTION_MAP.get(spaceId) : LogCode2Description.create(spaceId);
        return logCode2Description.convert(code);
    }

    public static LogCode2Description create(String spaceName) {
        return LogCode2Description.create(SpaceId.withSpaceName(spaceName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogCode2Description create(SpaceId spaceId) {
        if (LogCode2Description.isCodeSpaceInitialized(spaceId)) {
            ReportUtil.reportWarn("Code space: \"" + spaceId.getSpaceName() + "\" is already initialized!");
            return LOG_CODE_2_DESCRIPTION_MAP.get(spaceId);
        }
        SpaceId spaceId2 = spaceId;
        synchronized (spaceId2) {
            if (LogCode2Description.isCodeSpaceInitialized(spaceId)) {
                ReportUtil.reportWarn("Code space: \"" + spaceId.getSpaceName() + "\" is already initialized!");
                return LOG_CODE_2_DESCRIPTION_MAP.get(spaceId);
            }
            LogCode2Description logCode2Description = LogCode2Description.doCreate(spaceId);
            ReportUtil.reportInfo("Code Space: \"" + spaceId.getSpaceName() + "\" init ok");
            return logCode2Description;
        }
    }

    private static LogCode2Description doCreate(SpaceId spaceId) {
        LogCode2Description logCode2Description = new LogCode2Description(spaceId);
        LOG_CODE_2_DESCRIPTION_MAP.put(spaceId, logCode2Description);
        return logCode2Description;
    }

    private static boolean isCodeSpaceInitialized(SpaceId spaceId) {
        return LOG_CODE_2_DESCRIPTION_MAP.containsKey(spaceId);
    }

    public static void removeCodeSpace(String spaceName) {
        LogCode2Description.removeCodeSpace(SpaceId.withSpaceName(spaceName));
    }

    public static void removeCodeSpace(SpaceId spaceId) {
        if (spaceId == null || !LogCode2Description.isCodeSpaceInitialized(spaceId)) {
            return;
        }
        LOG_CODE_2_DESCRIPTION_MAP.remove(spaceId);
    }

    private LogCode2Description(SpaceId spaceId) {
        List<URL> configUrls;
        this.logPrefix = spaceId.getSpaceName().toUpperCase();
        this.logFormat = this.logPrefix + "-%s: %s";
        String prefix = spaceId.getSpaceName().replace(".", "/") + "/log-codes";
        String encoding = Locale.getDefault().toString();
        if (StringUtil.isEmpty(encoding)) {
            encoding = Locale.ENGLISH.toString();
        }
        String fileName = prefix + "_" + encoding + ".properties";
        if (this.getClass().getClassLoader().getResource(fileName) == null) {
            fileName = prefix + ".properties";
        }
        if ((configUrls = this.getResources(this.getClass().getClassLoader(), fileName)) != null) {
            for (URL configUrl : configUrls) {
                try {
                    InputStream in = configUrl.openStream();
                    try {
                        Properties properties = new Properties();
                        if (in == null) {
                            ReportUtil.reportError(String.format("Code file for CodeSpace \"%s\" doesn't exist!", spaceId.getSpaceName()));
                        } else {
                            InputStreamReader reader = new InputStreamReader(in);
                            properties.load(reader);
                        }
                        int priority = 0;
                        String priorityString = properties.getProperty("priority");
                        if (StringUtil.isNotEmpty(priorityString)) {
                            priority = Integer.parseInt(priorityString);
                        }
                        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                            String key2 = (String)entry.getKey();
                            Pair exist = this.codeMap.get(key2);
                            if (exist != null && exist.getPriority() > priority) continue;
                            if (key2.equals("logValueSuffix")) {
                                this.logValueSuffix = (String)entry.getValue();
                            }
                            this.codeMap.put(key2, new Pair(priority, String.format(this.logFormat, key2, entry.getValue())));
                        }
                    }
                    finally {
                        if (in == null) continue;
                        in.close();
                    }
                }
                catch (Throwable e) {
                    ReportUtil.reportError(String.format("Code space \"%s\" initializing failed!", spaceId.getSpaceName()), e);
                }
            }
            if (StringUtil.isNotEmpty(this.logValueSuffix)) {
                this.codeMap.forEach((key, value) -> value.setValue(value.getValue() + String.format(this.logValueSuffix, this.logPrefix, key)));
            }
        }
    }

    public String convert(String code) {
        return this.codeMap.computeIfAbsent(code, k -> new Pair(0, String.format(this.logFormat, k, "Unknown Code"))).getValue();
    }

    public String convert(String code, Object ... args) {
        return String.format(this.convert(code), args);
    }

    private List<URL> getResources(ClassLoader classLoader, String path) {
        ArrayList<URL> rtn = new ArrayList<URL>();
        try {
            Enumeration<URL> allUrls = classLoader.getResources(path);
            if (allUrls != null) {
                while (allUrls.hasMoreElements()) {
                    rtn.add(allUrls.nextElement());
                }
            }
        }
        catch (IOException e) {
            ReportUtil.reportWarn("Fail to get resource of " + path + " from classpath", e);
            return null;
        }
        return rtn;
    }

    private static class Pair {
        private final Integer priority;
        private String value;

        public Pair(Integer priority, String value) {
            this.priority = priority;
            this.value = value;
        }

        public Integer getPriority() {
            return this.priority;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

