/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.ai.common.config;

import java.util.Objects;
import java.util.Optional;
import org.apache.shenyu.common.dto.convert.rule.AiProxyHandle;

public class AiCommonConfig {
    private String provider;
    private String baseUrl;
    private String apiKey;
    private String model;
    private Double temperature = 0.8;
    private Integer maxTokens;
    private Boolean stream = false;

    public AiCommonConfig() {
    }

    public AiCommonConfig(AiProxyHandle.FallbackConfig fallbackConfig) {
        this.provider = fallbackConfig.getProvider();
        this.baseUrl = fallbackConfig.getBaseUrl();
        this.apiKey = fallbackConfig.getApiKey();
        this.model = fallbackConfig.getModel();
        this.temperature = fallbackConfig.getTemperature();
        this.maxTokens = fallbackConfig.getMaxTokens();
    }

    public AiCommonConfig(AiCommonConfig other) {
        this.provider = other.getProvider();
        this.baseUrl = other.getBaseUrl();
        this.apiKey = other.getApiKey();
        this.model = other.getModel();
        this.temperature = other.getTemperature();
        this.maxTokens = other.getMaxTokens();
        this.stream = other.getStream();
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    public Boolean getStream() {
        return this.stream;
    }

    public void setStream(Boolean stream) {
        this.stream = stream;
    }

    public AiCommonConfig mergeWith(AiCommonConfig overlay) {
        if (Objects.isNull(overlay)) {
            return this;
        }
        this.setProvider(Optional.ofNullable(overlay.getProvider()).orElse(this.getProvider()));
        this.setModel(Optional.ofNullable(overlay.getModel()).orElse(this.getModel()));
        this.setApiKey(Optional.ofNullable(overlay.getApiKey()).orElse(this.getApiKey()));
        this.setBaseUrl(Optional.ofNullable(overlay.getBaseUrl()).orElse(this.getBaseUrl()));
        this.setTemperature(Optional.ofNullable(overlay.getTemperature()).orElse(this.getTemperature()));
        this.setMaxTokens(Optional.ofNullable(overlay.getMaxTokens()).orElse(this.getMaxTokens()));
        this.setStream(Optional.ofNullable(overlay.getStream()).orElse(this.getStream()));
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (Objects.isNull(o) || this.getClass() != o.getClass()) {
            return false;
        }
        AiCommonConfig that = (AiCommonConfig)o;
        return Objects.equals(this.provider, that.provider) && Objects.equals(this.baseUrl, that.baseUrl) && Objects.equals(this.apiKey, that.apiKey) && Objects.equals(this.model, that.model) && Objects.equals(this.temperature, that.temperature) && Objects.equals(this.maxTokens, that.maxTokens) && Objects.equals(this.stream, that.stream);
    }

    public int hashCode() {
        return Objects.hash(this.provider, this.baseUrl, this.apiKey, this.model, this.temperature, this.maxTokens, this.stream);
    }

    public String toString() {
        return "AiCommonConfig{provider='" + this.provider + "', model='" + this.model + "', apiKey='" + AiProxyHandle.maskApiKey((String)this.apiKey) + "', baseUrl='" + this.baseUrl + "', temperature=" + this.temperature + ", maxTokens=" + this.maxTokens + ", stream=" + this.stream + "}";
    }
}

