/*
 * Decompiled with CFR 0.152.
 */
package io.fury.serializer;

import io.fury.Fury;
import io.fury.collection.Tuple2;
import io.fury.collection.Tuple3;
import io.fury.memory.MemoryBuffer;
import io.fury.resolver.ClassInfoHolder;
import io.fury.resolver.ClassResolver;
import io.fury.resolver.RefResolver;
import io.fury.serializer.ObjectSerializer;
import io.fury.serializer.Serializer;
import io.fury.serializer.Serializers;
import io.fury.type.ClassDef;
import io.fury.type.Descriptor;
import io.fury.type.DescriptorGrouper;
import io.fury.type.Generics;
import io.fury.util.FieldAccessor;
import io.fury.util.Platform;
import io.fury.util.Preconditions;
import io.fury.util.ReflectionUtils;
import io.fury.util.record.RecordInfo;
import io.fury.util.record.RecordUtils;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.stream.Collectors;

public class MetaSharedSerializer<T>
extends Serializer<T> {
    private final ObjectSerializer.FinalTypeField[] finalFields;
    private final boolean[] isFinal;
    private final ObjectSerializer.GenericTypeField[] otherFields;
    private final ObjectSerializer.GenericTypeField[] containerFields;
    private final boolean isRecord;
    private final MethodHandle constructor;
    private final RecordInfo recordInfo;
    private Serializer<T> serializer;
    private final ClassInfoHolder classInfoHolder;

    public MetaSharedSerializer(Fury fury, Class<T> type, ClassDef classDef) {
        super(fury, type);
        Preconditions.checkArgument(!fury.getConfig().checkClassVersion(), "Class version check should be disabled when compatible mode is enabled.");
        Preconditions.checkArgument(fury.getConfig().shareMetaContext(), "Meta share must be enabled.");
        Collection<Descriptor> descriptors = MetaSharedSerializer.consolidateFields(fury.getClassResolver(), type, classDef);
        DescriptorGrouper descriptorGrouper = DescriptorGrouper.createDescriptorGrouper(descriptors, true, fury.compressInt(), fury.getConfig().compressLong());
        this.isRecord = RecordUtils.isRecord(type);
        this.constructor = this.isRecord ? (MethodHandle)RecordUtils.getRecordConstructor(type).f1 : ReflectionUtils.getCtrHandle(type, false);
        Tuple3<Tuple2<ObjectSerializer.FinalTypeField[], boolean[]>, ObjectSerializer.GenericTypeField[], ObjectSerializer.GenericTypeField[]> infos = ObjectSerializer.buildFieldInfos(fury, descriptorGrouper);
        this.finalFields = (ObjectSerializer.FinalTypeField[])((Tuple2)infos.f0).f0;
        this.isFinal = (boolean[])((Tuple2)infos.f0).f1;
        this.otherFields = (ObjectSerializer.GenericTypeField[])infos.f1;
        this.containerFields = (ObjectSerializer.GenericTypeField[])infos.f2;
        this.classInfoHolder = fury.getClassResolver().nilClassInfoHolder();
        if (this.isRecord) {
            List<String> fieldNames = descriptorGrouper.getSortedDescriptors().stream().map(Descriptor::getName).collect(Collectors.toList());
            this.recordInfo = new RecordInfo(type, fieldNames);
        } else {
            this.recordInfo = null;
        }
    }

    @Override
    public void write(MemoryBuffer buffer, T value) {
        if (this.serializer == null) {
            this.serializer = this.fury.getClassResolver().createSerializerSafe(this.type, () -> new ObjectSerializer(this.fury, this.type));
        }
        this.serializer.write(buffer, value);
    }

    @Override
    public T read(MemoryBuffer buffer) {
        Object fieldValue;
        if (this.isRecord) {
            Object[] fieldValues = new Object[this.finalFields.length + this.otherFields.length + this.containerFields.length];
            this.readFields(buffer, fieldValues);
            RecordUtils.remapping(this.recordInfo, fieldValues);
            try {
                Object t = this.constructor.invokeWithArguments(this.recordInfo.getRecordComponents());
                Arrays.fill(this.recordInfo.getRecordComponents(), null);
                return (T)t;
            }
            catch (Throwable e) {
                Platform.throwException(e);
            }
        }
        Object obj = ObjectSerializer.newBean(this.constructor, this.type);
        Fury fury = this.fury;
        RefResolver refResolver = fury.getRefResolver();
        ClassResolver classResolver = fury.getClassResolver();
        refResolver.reference(obj);
        ObjectSerializer.FinalTypeField[] finalFields = this.finalFields;
        for (int i = 0; i < finalFields.length; ++i) {
            ObjectSerializer.FinalTypeField fieldInfo = finalFields[i];
            boolean isFinal = this.isFinal[i];
            FieldAccessor fieldAccessor = fieldInfo.fieldAccessor;
            if (fieldAccessor != null) {
                short classId = fieldInfo.classId;
                if (!ObjectSerializer.readPrimitiveFieldValueFailed(fury, buffer, obj, fieldAccessor, classId) || !ObjectSerializer.readBasicObjectFieldValueFailed(fury, buffer, obj, fieldAccessor, classId)) continue;
                assert (fieldInfo.classInfo != null);
                fieldValue = ObjectSerializer.readFinalObjectFieldValue(fury, refResolver, classResolver, fieldInfo, isFinal, buffer);
                fieldAccessor.putObject(obj, fieldValue);
                continue;
            }
            if (!MetaSharedSerializer.skipPrimitiveFieldValueFailed(fury, fieldInfo.classId, buffer)) continue;
            if (fieldInfo.classInfo == null) {
                fury.readRef(buffer, this.classInfoHolder);
                continue;
            }
            ObjectSerializer.readFinalObjectFieldValue(fury, refResolver, classResolver, fieldInfo, isFinal, buffer);
        }
        for (ObjectSerializer.GenericTypeField fieldInfo : this.otherFields) {
            Object fieldValue2 = ObjectSerializer.readOtherFieldValue(fury, fieldInfo, buffer);
            FieldAccessor fieldAccessor = fieldInfo.fieldAccessor;
            if (fieldAccessor == null) continue;
            fieldAccessor.putObject(obj, fieldValue2);
        }
        Generics generics = fury.getGenerics();
        for (ObjectSerializer.GenericTypeField fieldInfo : this.containerFields) {
            fieldValue = ObjectSerializer.readContainerFieldValue(fury, generics, fieldInfo, buffer);
            FieldAccessor fieldAccessor = fieldInfo.fieldAccessor;
            if (fieldAccessor == null) continue;
            fieldAccessor.putObject(obj, fieldValue);
        }
        return obj;
    }

    private void readFields(MemoryBuffer buffer, Object[] fields) {
        Object fieldValue;
        int counter = 0;
        Fury fury = this.fury;
        RefResolver refResolver = fury.getRefResolver();
        ClassResolver classResolver = fury.getClassResolver();
        ObjectSerializer.FinalTypeField[] finalFields = this.finalFields;
        for (int i = 0; i < finalFields.length; ++i) {
            ObjectSerializer.FinalTypeField fieldInfo = finalFields[i];
            boolean isFinal = this.isFinal[i];
            if (fieldInfo.fieldAccessor != null) {
                assert (fieldInfo.classInfo != null);
                short classId = fieldInfo.classId;
                if (classId >= 5 && classId <= 12) {
                    fields[counter++] = Serializers.readPrimitiveValue(fury, buffer, classId);
                    continue;
                }
                fieldValue = ObjectSerializer.readFinalObjectFieldValue(fury, refResolver, classResolver, fieldInfo, isFinal, buffer);
                fields[counter++] = fieldValue;
                continue;
            }
            if (MetaSharedSerializer.skipPrimitiveFieldValueFailed(fury, fieldInfo.classId, buffer)) {
                if (fieldInfo.classInfo == null) {
                    fury.readRef(buffer, this.classInfoHolder);
                } else {
                    ObjectSerializer.readFinalObjectFieldValue(fury, refResolver, classResolver, fieldInfo, isFinal, buffer);
                }
            }
            fields[counter++] = null;
        }
        for (ObjectSerializer.GenericTypeField fieldInfo : this.otherFields) {
            fieldValue = ObjectSerializer.readOtherFieldValue(fury, fieldInfo, buffer);
            fields[counter++] = fieldValue;
        }
        Generics generics = fury.getGenerics();
        for (ObjectSerializer.GenericTypeField fieldInfo : this.containerFields) {
            Object fieldValue2 = ObjectSerializer.readContainerFieldValue(fury, generics, fieldInfo, buffer);
            fields[counter++] = fieldValue2;
        }
    }

    static boolean skipPrimitiveFieldValueFailed(Fury fury, short classId, MemoryBuffer buffer) {
        switch (classId) {
            case 5: {
                buffer.increaseReaderIndex(1);
                return false;
            }
            case 6: {
                buffer.increaseReaderIndex(1);
                return false;
            }
            case 7: {
                buffer.increaseReaderIndex(2);
                return false;
            }
            case 8: {
                buffer.increaseReaderIndex(2);
                return false;
            }
            case 9: {
                if (fury.compressInt()) {
                    buffer.readVarInt();
                } else {
                    buffer.increaseReaderIndex(4);
                }
                return false;
            }
            case 10: {
                buffer.increaseReaderIndex(4);
                return false;
            }
            case 11: {
                fury.readLong(buffer);
                return false;
            }
            case 12: {
                buffer.increaseReaderIndex(8);
                return false;
            }
        }
        return true;
    }

    public static Collection<Descriptor> consolidateFields(ClassResolver classResolver, Class<?> cls, ClassDef classDef) {
        SortedMap<Field, Descriptor> allDescriptorsMap = classResolver.getAllDescriptorsMap(cls, true);
        HashMap<String, Descriptor> descriptorsMap = new HashMap<String, Descriptor>();
        for (Map.Entry<Field, Descriptor> e : allDescriptorsMap.entrySet()) {
            if (descriptorsMap.put(e.getKey().getDeclaringClass().getName() + "." + e.getKey().getName(), e.getValue()) == null) continue;
            throw new IllegalStateException("Duplicate key");
        }
        ArrayList<Descriptor> descriptors = new ArrayList<Descriptor>(classDef.getFieldsInfo().size());
        for (ClassDef.FieldInfo fieldInfo : classDef.getFieldsInfo()) {
            Descriptor descriptor = (Descriptor)descriptorsMap.get(fieldInfo.getDefinedClass() + "." + fieldInfo.getFieldName());
            if (descriptor != null) {
                descriptors.add(descriptor);
                continue;
            }
            descriptors.add(fieldInfo.toDescriptor(classResolver));
        }
        return descriptors;
    }
}

