/*
 * Decompiled with CFR 0.152.
 */
package io.fury.serializer;

import com.google.common.reflect.TypeToken;
import io.fury.Fury;
import io.fury.config.Language;
import io.fury.exception.ClassNotCompatibleException;
import io.fury.memory.MemoryBuffer;
import io.fury.serializer.Serializer;
import io.fury.type.Descriptor;
import io.fury.type.GenericType;
import io.fury.type.Generics;
import io.fury.type.Type;
import io.fury.type.TypeUtils;
import io.fury.util.FieldAccessor;
import io.fury.util.LoggerFactory;
import io.fury.util.Platform;
import io.fury.util.Preconditions;
import io.fury.util.Utils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class StructSerializer<T>
extends Serializer<T> {
    private static final Logger LOG = LoggerFactory.getLogger(StructSerializer.class);
    private final String typeTag;
    private final Constructor<T> constructor;
    private final FieldAccessor[] fieldAccessors;
    private GenericType[] fieldGenerics;
    private GenericType genericType;
    private final IdentityHashMap<GenericType, GenericType[]> genericTypesCache;
    private int typeHash;

    public StructSerializer(Fury fury, Class<T> cls, String typeTag) {
        super(fury, cls);
        this.typeTag = typeTag;
        if (fury.getLanguage() == Language.JAVA) {
            LOG.warn("Type of class {} shouldn't be serialized using cross-language serializer", cls);
        }
        Constructor<T> ctr = null;
        try {
            ctr = cls.getConstructor(new Class[0]);
            if (!ctr.isAccessible()) {
                ctr.setAccessible(true);
            }
        }
        catch (Exception e) {
            Utils.ignore(e);
        }
        this.constructor = ctr;
        this.fieldAccessors = (FieldAccessor[])Descriptor.getFields(cls).stream().sorted(Comparator.comparing(Field::getName)).map(FieldAccessor::createAccessor).toArray(FieldAccessor[]::new);
        this.fieldGenerics = StructSerializer.buildFieldGenerics(TypeToken.of(cls), this.fieldAccessors);
        this.genericTypesCache = new IdentityHashMap();
        this.genericTypesCache.put(null, this.fieldGenerics);
    }

    private static <T> GenericType[] buildFieldGenerics(TypeToken<T> type, FieldAccessor[] fieldAccessors) {
        return (GenericType[])Arrays.stream(fieldAccessors).map(fieldAccessor -> GenericType.build(type, fieldAccessor.getField().getGenericType())).toArray(GenericType[]::new);
    }

    @Override
    public void write(MemoryBuffer buffer, T value) {
        this.xwrite(buffer, value);
    }

    @Override
    public T read(MemoryBuffer buffer) {
        return this.xread(buffer);
    }

    @Override
    public short getXtypeId() {
        return Fury.FURY_TYPE_TAG_ID;
    }

    @Override
    public String getCrossLanguageTypeTag() {
        return this.typeTag;
    }

    @Override
    public void xwrite(MemoryBuffer buffer, T value) {
        int typeHash = this.typeHash;
        if (typeHash == 0) {
            this.typeHash = typeHash = this.computeStructHash();
        }
        buffer.writeInt(typeHash);
        Generics generics = this.fury.getGenerics();
        GenericType[] fieldGenerics = this.getGenericTypes(generics);
        for (int i = 0; i < this.fieldAccessors.length; ++i) {
            FieldAccessor fieldAccessor = this.fieldAccessors[i];
            GenericType fieldGeneric = fieldGenerics[i];
            Serializer<?> serializer = fieldGeneric.getSerializerOrNull(this.fury.getClassResolver());
            boolean hasGenerics = fieldGeneric.hasGenericParameters();
            if (hasGenerics) {
                generics.pushGenericType(fieldGeneric);
            }
            if (serializer != null) {
                this.fury.xwriteRef(buffer, fieldAccessor.get(value), serializer);
            } else {
                this.fury.xwriteRef(buffer, fieldAccessor.get(value));
            }
            if (!hasGenerics) continue;
            generics.popGenericType();
        }
    }

    private GenericType[] getGenericTypes(Generics generics) {
        GenericType[] fieldGenerics = this.fieldGenerics;
        GenericType genericType = generics.nextGenericType();
        if (genericType != this.genericType) {
            this.genericType = genericType;
            fieldGenerics = this.genericTypesCache.get(genericType);
            if (fieldGenerics == null) {
                fieldGenerics = StructSerializer.buildFieldGenerics(genericType.getTypeToken(), this.fieldAccessors);
                this.genericTypesCache.put(genericType, fieldGenerics);
            }
            this.fieldGenerics = fieldGenerics;
        }
        return fieldGenerics;
    }

    @Override
    public T xread(MemoryBuffer buffer) {
        int newHash;
        int typeHash = this.typeHash;
        if (typeHash == 0) {
            this.typeHash = typeHash = this.computeStructHash();
        }
        if ((newHash = buffer.readInt()) != typeHash) {
            throw new ClassNotCompatibleException(String.format("Hash %d is not consistent with %s for class %s", newHash, typeHash, this.fury.getClassResolver().getCurrentReadClass()));
        }
        T obj = this.newBean();
        this.fury.getRefResolver().reference(obj);
        Generics generics = this.fury.getGenerics();
        GenericType[] fieldGenerics = this.getGenericTypes(generics);
        for (int i = 0; i < this.fieldAccessors.length; ++i) {
            FieldAccessor fieldAccessor = this.fieldAccessors[i];
            GenericType fieldGeneric = fieldGenerics[i];
            Serializer<?> serializer = fieldGeneric.getSerializerOrNull(this.fury.getClassResolver());
            boolean hasGenerics = fieldGeneric.hasGenericParameters();
            if (hasGenerics) {
                generics.pushGenericType(fieldGeneric);
            }
            Object fieldValue = this.fury.xreadRefByNullableSerializer(buffer, serializer);
            fieldAccessor.set(obj, fieldValue);
            if (!hasGenerics) continue;
            generics.pushGenericType(fieldGeneric);
        }
        return obj;
    }

    private T newBean() {
        if (this.constructor != null) {
            try {
                return this.constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                Platform.throwException(e);
            }
        }
        return Platform.newInstance(this.type);
    }

    int computeStructHash() {
        int hash = 17;
        for (GenericType fieldGeneric : this.fieldGenerics) {
            hash = this.computeFieldHash(hash, fieldGeneric);
        }
        Preconditions.checkState(hash != 0);
        return hash;
    }

    int computeFieldHash(int hash, GenericType fieldGeneric) {
        long newHash;
        int id;
        if (fieldGeneric.getTypeToken().isSubtypeOf(List.class)) {
            id = Type.LIST.getId();
        } else if (fieldGeneric.getTypeToken().isSubtypeOf(Map.class)) {
            id = Type.MAP.getId();
        } else {
            try {
                Serializer<?> serializer = this.fury.getClassResolver().getSerializer(fieldGeneric.getCls());
                short xtypeId = serializer.getXtypeId();
                if (xtypeId == 0) {
                    return hash;
                }
                id = Math.abs(xtypeId);
                if (id == Type.FURY_TYPE_TAG.getId()) {
                    id = TypeUtils.computeStringHash(serializer.getCrossLanguageTypeTag());
                }
            }
            catch (Exception e) {
                return hash;
            }
        }
        for (newHash = (long)hash * 31L + (long)id; newHash >= Integer.MAX_VALUE; newHash /= 7L) {
        }
        return (int)newHash;
    }
}

