/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.servlet.jakarta;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.InternalLogId;
import io.grpc.servlet.jakarta.ServletServerStream;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletOutputStream;
import java.io.IOException;
import java.time.Duration;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

final class AsyncServletOutputStreamWriter {
    private final AtomicReference<WriteState> writeState = new AtomicReference<WriteState>(WriteState.DEFAULT);
    private final Log log;
    private final BiFunction<byte[], Integer, ActionItem> writeAction;
    private final ActionItem flushAction;
    private final ActionItem completeAction;
    private final BooleanSupplier isReady;
    private final Queue<ActionItem> writeChain = new ConcurrentLinkedQueue<ActionItem>();
    @Nullable
    private volatile Thread parkingThread;

    AsyncServletOutputStreamWriter(AsyncContext asyncContext, ServletServerStream.ServletTransportState transportState, final InternalLogId logId) throws IOException {
        final Logger logger = Logger.getLogger(AsyncServletOutputStreamWriter.class.getName());
        this.log = new Log(){

            @Override
            public void fine(String str, Object ... params) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "[" + logId + "]" + str, params);
                }
            }

            @Override
            public void finest(String str, Object ... params) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "[" + logId + "] " + str, params);
                }
            }
        };
        ServletOutputStream outputStream = asyncContext.getResponse().getOutputStream();
        this.writeAction = (bytes, numBytes) -> () -> {
            outputStream.write(bytes, 0, numBytes.intValue());
            transportState.runOnTransportThread(() -> transportState.onSentBytes((int)numBytes));
            this.log.finest("outbound data: length={0}, bytes={1}", numBytes, ServletServerStream.toHexString(bytes, numBytes));
        };
        this.flushAction = () -> {
            this.log.finest("flushBuffer", new Object[0]);
            asyncContext.getResponse().flushBuffer();
        };
        this.completeAction = () -> {
            this.log.fine("call is completing", new Object[0]);
            transportState.runOnTransportThread(() -> {
                transportState.complete();
                asyncContext.complete();
                this.log.fine("call completed", new Object[0]);
            });
        };
        this.isReady = () -> outputStream.isReady();
    }

    @VisibleForTesting
    AsyncServletOutputStreamWriter(BiFunction<byte[], Integer, ActionItem> writeAction, ActionItem flushAction, ActionItem completeAction, BooleanSupplier isReady, Log log) {
        this.writeAction = writeAction;
        this.flushAction = flushAction;
        this.completeAction = completeAction;
        this.isReady = isReady;
        this.log = log;
    }

    void writeBytes(byte[] bytes, int numBytes) throws IOException {
        this.runOrBuffer(this.writeAction.apply(bytes, numBytes));
    }

    void flush() throws IOException {
        this.runOrBuffer(this.flushAction);
    }

    void complete() {
        try {
            this.runOrBuffer(this.completeAction);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void onWritePossible() throws IOException {
        this.log.finest("onWritePossible: ENTRY. The servlet output stream becomes ready", new Object[0]);
        this.assureReadyAndDrainedTurnsFalse();
        while (this.isReady.getAsBoolean()) {
            WriteState curState = this.writeState.get();
            ActionItem actionItem = this.writeChain.poll();
            if (actionItem != null) {
                actionItem.run();
                continue;
            }
            if (!this.writeState.compareAndSet(curState, curState.withReadyAndDrained(true))) continue;
            this.log.finest("onWritePossible: EXIT. All data available now is sent out and the servlet output stream is still ready", new Object[0]);
            return;
        }
        this.log.finest("onWritePossible: EXIT. The servlet output stream becomes not ready", new Object[0]);
    }

    private void assureReadyAndDrainedTurnsFalse() {
        while (this.writeState.get().readyAndDrained) {
            this.parkingThread = Thread.currentThread();
            LockSupport.parkNanos(Duration.ofMinutes(1L).toNanos());
        }
        this.parkingThread = null;
    }

    private void runOrBuffer(ActionItem actionItem) throws IOException {
        WriteState curState = this.writeState.get();
        if (curState.readyAndDrained) {
            actionItem.run();
            if (actionItem == this.completeAction) {
                return;
            }
            if (!this.isReady.getAsBoolean()) {
                boolean successful = this.writeState.compareAndSet(curState, curState.withReadyAndDrained(false));
                LockSupport.unpark(this.parkingThread);
                Preconditions.checkState((boolean)successful, (Object)"Bug: curState is unexpectedly changed by another thread");
                this.log.finest("the servlet output stream becomes not ready", new Object[0]);
            }
        } else {
            this.writeChain.offer(actionItem);
            if (!this.writeState.compareAndSet(curState, curState.withReadyAndDrained(false))) {
                Preconditions.checkState((boolean)this.writeState.get().readyAndDrained, (Object)"Bug: onWritePossible() should have changed readyAndDrained to true, but not");
                ActionItem lastItem = this.writeChain.poll();
                if (lastItem != null) {
                    Preconditions.checkState((lastItem == actionItem ? 1 : 0) != 0, (Object)"Bug: lastItem != actionItem");
                    this.runOrBuffer(lastItem);
                }
            }
        }
    }

    private static final class WriteState {
        static final WriteState DEFAULT = new WriteState(false);
        final boolean readyAndDrained;

        WriteState(boolean readyAndDrained) {
            this.readyAndDrained = readyAndDrained;
        }

        @CheckReturnValue
        WriteState withReadyAndDrained(boolean readyAndDrained) {
            return new WriteState(readyAndDrained);
        }
    }

    @VisibleForTesting
    static interface Log {
        default public void fine(String str, Object ... params) {
        }

        default public void finest(String str, Object ... params) {
        }
    }

    @FunctionalInterface
    @VisibleForTesting
    static interface ActionItem {
        public void run() throws IOException;
    }
}

