/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.resilience4j.executor;

import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import io.github.resilience4j.ratelimiter.RequestNotPermitted;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.plugin.base.fallback.FallbackHandler;
import org.apache.shenyu.plugin.resilience4j.Resilience4JPlugin;
import org.apache.shenyu.plugin.resilience4j.conf.Resilience4JConf;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public interface Executor
extends FallbackHandler {
    public <T> Mono<T> run(Mono<T> var1, Function<Throwable, Mono<T>> var2, Resilience4JConf var3);

    default public Mono<Void> withoutFallback(ServerWebExchange exchange, Throwable throwable) {
        Object error;
        if (throwable instanceof TimeoutException) {
            exchange.getResponse().setStatusCode((HttpStatusCode)HttpStatus.GATEWAY_TIMEOUT);
            error = ShenyuResultWrap.error((ServerWebExchange)exchange, (ShenyuResultEnum)ShenyuResultEnum.SERVICE_TIMEOUT);
        } else {
            if (throwable instanceof Resilience4JPlugin.CircuitBreakerStatusCodeException) {
                return Mono.error((Throwable)throwable);
            }
            if (throwable instanceof CallNotPermittedException) {
                exchange.getResponse().setStatusCode((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                error = ShenyuResultWrap.error((ServerWebExchange)exchange, (ShenyuResultEnum)ShenyuResultEnum.SERVICE_RESULT_ERROR);
            } else if (throwable instanceof RequestNotPermitted) {
                exchange.getResponse().setStatusCode((HttpStatusCode)HttpStatus.TOO_MANY_REQUESTS);
                error = ShenyuResultWrap.error((ServerWebExchange)exchange, (ShenyuResultEnum)ShenyuResultEnum.TOO_MANY_REQUESTS);
            } else {
                exchange.getResponse().setStatusCode((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                error = ShenyuResultWrap.error((ServerWebExchange)exchange, (ShenyuResultEnum)ShenyuResultEnum.SERVICE_RESULT_ERROR);
            }
        }
        return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
    }

    default public Mono<Void> error(ServerWebExchange exchange) {
        exchange.getResponse().setStatusCode((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        Object error = ShenyuResultWrap.error((ServerWebExchange)exchange, (ShenyuResultEnum)ShenyuResultEnum.SERVICE_RESULT_ERROR);
        return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
    }
}

