/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.api.naming.pojo.builder;

import com.alibaba.nacos.api.naming.pojo.Instance;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class InstanceBuilder {
    private String instanceId;
    private String ip;
    private Integer port;
    private Double weight;
    private Boolean healthy;
    private Boolean enabled;
    private Boolean ephemeral;
    private String clusterName;
    private String serviceName;
    private Map<String, String> metadata = new HashMap<String, String>();

    private InstanceBuilder() {
    }

    public InstanceBuilder setInstanceId(String instanceId) {
        this.instanceId = instanceId;
        return this;
    }

    public InstanceBuilder setIp(String ip) {
        this.ip = ip;
        return this;
    }

    public InstanceBuilder setPort(Integer port) {
        this.port = port;
        return this;
    }

    public InstanceBuilder setWeight(Double weight) {
        this.weight = weight;
        return this;
    }

    public InstanceBuilder setHealthy(Boolean healthy) {
        this.healthy = healthy;
        return this;
    }

    public InstanceBuilder setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public InstanceBuilder setEphemeral(Boolean ephemeral) {
        this.ephemeral = ephemeral;
        return this;
    }

    public InstanceBuilder setClusterName(String clusterName) {
        this.clusterName = clusterName;
        return this;
    }

    public InstanceBuilder setServiceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    public InstanceBuilder setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public InstanceBuilder addMetadata(String metaKey, String metaValue) {
        this.metadata.put(metaKey, metaValue);
        return this;
    }

    public Instance build() {
        Instance result = new Instance();
        if (!Objects.isNull(this.instanceId)) {
            result.setInstanceId(this.instanceId);
        }
        if (!Objects.isNull(this.ip)) {
            result.setIp(this.ip);
        }
        if (!Objects.isNull(this.port)) {
            result.setPort(this.port);
        }
        if (!Objects.isNull(this.weight)) {
            result.setWeight(this.weight);
        }
        if (!Objects.isNull(this.healthy)) {
            result.setHealthy(this.healthy);
        }
        if (!Objects.isNull(this.enabled)) {
            result.setEnabled(this.enabled);
        }
        if (!Objects.isNull(this.ephemeral)) {
            result.setEphemeral(this.ephemeral);
        }
        if (!Objects.isNull(this.clusterName)) {
            result.setClusterName(this.clusterName);
        }
        if (!Objects.isNull(this.serviceName)) {
            result.setServiceName(this.serviceName);
        }
        result.setMetadata(this.metadata);
        return result;
    }

    public static InstanceBuilder newBuilder() {
        return new InstanceBuilder();
    }
}

