/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.api.utils;

import com.alibaba.nacos.api.utils.StringUtils;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;

public class NetUtils {
    private static final String CLIENT_LOCAL_IP_PROPERTY = "com.alibaba.nacos.client.local.ip";
    private static final String CLIENT_LOCAL_PREFER_HOSTNAME_PROPERTY = "com.alibaba.nacos.client.local.preferHostname";
    private static final String LEGAL_LOCAL_IP_PROPERTY = "java.net.preferIPv6Addresses";
    private static final String DEFAULT_SOLVE_FAILED_RETURN = "resolve_failed";
    private static String localIp;

    public static String localIP() {
        if (!StringUtils.isEmpty(localIp)) {
            return localIp;
        }
        if (System.getProperties().containsKey(CLIENT_LOCAL_IP_PROPERTY)) {
            localIp = System.getProperty(CLIENT_LOCAL_IP_PROPERTY, NetUtils.getAddress());
            return localIp;
        }
        localIp = NetUtils.getAddress();
        return localIp;
    }

    private static String getAddress() {
        InetAddress inetAddress = NetUtils.findFirstNonLoopbackAddress();
        if (inetAddress == null) {
            return DEFAULT_SOLVE_FAILED_RETURN;
        }
        boolean preferHost = Boolean.parseBoolean(System.getProperty(CLIENT_LOCAL_PREFER_HOSTNAME_PROPERTY));
        return preferHost ? inetAddress.getHostName() : inetAddress.getHostAddress();
    }

    private static InetAddress findFirstNonLoopbackAddress() {
        InetAddress result = null;
        try {
            int lowest = Integer.MAX_VALUE;
            Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
            while (nics.hasMoreElements()) {
                NetworkInterface ifc = nics.nextElement();
                if (!ifc.isUp() || ifc.getIndex() >= lowest && result != null) continue;
                lowest = ifc.getIndex();
                Enumeration<InetAddress> addrs = ifc.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress address = addrs.nextElement();
                    boolean isLegalIpVersion = Boolean.parseBoolean(System.getProperty(LEGAL_LOCAL_IP_PROPERTY)) ? address instanceof Inet6Address : address instanceof Inet4Address;
                    if (!isLegalIpVersion || address.isLoopbackAddress()) continue;
                    result = address;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (result != null) {
            return result;
        }
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }
}

