/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config;

import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class DynamicSetProperty<T> {
    private volatile Set<T> values;
    private final DynamicStringProperty delegate;
    private final String delimiter;

    public DynamicSetProperty(String string, String string2) {
        this(string, string2, ",");
    }

    public DynamicSetProperty(String string, String string2, String string3) {
        this.delegate = DynamicPropertyFactory.getInstance().getStringProperty(string, string2);
        this.delimiter = string3;
        this.load();
        this.delegate.addCallback(new Runnable(){

            @Override
            public void run() {
                DynamicSetProperty.this.propertyChangedInternal();
            }
        });
    }

    public DynamicSetProperty(String string, Set<T> set, String string2) {
        this(string, (String)null, string2);
        if (this.values == null && set != null) {
            this.values = Collections.unmodifiableSet(set);
        }
    }

    public DynamicSetProperty(String string, Set<T> set) {
        this(string, set, ",");
    }

    private void propertyChangedInternal() {
        this.load();
        this.propertyChanged();
    }

    protected void propertyChanged() {
    }

    public Set<T> get() {
        return this.values;
    }

    protected void load() {
        if (this.delegate.get() == null) {
            return;
        }
        List<String> list = Arrays.asList(this.delegate.get().split(this.delimiter));
        HashSet<T> hashSet = new HashSet<T>(list.size());
        for (String string : list) {
            hashSet.add(this.from(string));
        }
        this.values = Collections.unmodifiableSet(hashSet);
    }

    public long getChangedTimestamp() {
        return this.delegate.getChangedTimestamp();
    }

    public void addCallback(Runnable runnable) {
        if (runnable != null) {
            this.delegate.addCallback(runnable);
        }
    }

    protected abstract T from(String var1);
}

