/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.extension.support;

import java.lang.annotation.Annotation;
import java.util.Comparator;
import org.apache.dubbo.common.compact.Dubbo2ActivateUtils;
import org.apache.dubbo.common.compact.Dubbo2CompactUtils;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.extension.Wrapper;

public class WrapperComparator
implements Comparator<Object> {
    public static final Comparator<Object> COMPARATOR = new WrapperComparator();

    @Override
    public int compare(Object o1, Object o2) {
        int n2;
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1.equals(o2)) {
            return 0;
        }
        Class clazz1 = (Class)o1;
        Class clazz2 = (Class)o2;
        OrderInfo a1 = this.parseOrder(clazz1);
        OrderInfo a2 = this.parseOrder(clazz2);
        int n1 = a1.order;
        return n1 > (n2 = a2.order) ? 1 : -1;
    }

    private OrderInfo parseOrder(Class<?> clazz) {
        OrderInfo info = new OrderInfo();
        if (clazz.isAnnotationPresent(Activate.class)) {
            Activate activate = clazz.getAnnotation(Activate.class);
            info.order = activate.order();
        } else if (Dubbo2CompactUtils.isEnabled() && Dubbo2ActivateUtils.isActivateLoaded() && clazz.isAnnotationPresent(Dubbo2ActivateUtils.getActivateClass())) {
            Annotation activate = clazz.getAnnotation(Dubbo2ActivateUtils.getActivateClass());
            info.order = Dubbo2ActivateUtils.getOrder(activate);
        } else if (clazz.isAnnotationPresent(Wrapper.class)) {
            Wrapper wrapper = clazz.getAnnotation(Wrapper.class);
            info.order = wrapper.order();
        }
        return info;
    }

    private static class OrderInfo {
        private int order;

        private OrderInfo() {
        }
    }
}

