/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.logger.slf4j;

import org.apache.dubbo.common.logger.Level;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.support.FailsafeLogger;
import org.slf4j.spi.LocationAwareLogger;

public class Slf4jLogger
implements Logger {
    private static final String FQCN = FailsafeLogger.class.getName();
    private final org.slf4j.Logger logger;
    private final LocationAwareLogger locationAwareLogger;

    public Slf4jLogger(org.slf4j.Logger logger) {
        this.locationAwareLogger = logger instanceof LocationAwareLogger ? (LocationAwareLogger)logger : null;
        this.logger = logger;
    }

    @Override
    public void trace(String msg) {
        if (this.locationAwareLogger != null) {
            this.locationAwareLogger.log(null, FQCN, 0, msg, null, null);
            return;
        }
        this.logger.trace(msg);
    }

    @Override
    public void trace(Throwable e) {
        if (this.locationAwareLogger != null) {
            this.locationAwareLogger.log(null, FQCN, 0, e.getMessage(), null, e);
            return;
        }
        this.logger.trace(e.getMessage(), e);
    }

    @Override
    public void trace(String msg, Throwable e) {
        if (this.locationAwareLogger != null) {
            this.locationAwareLogger.log(null, FQCN, 0, msg, null, e);
            return;
        }
        this.logger.trace(msg, e);
    }

    @Override
    public void debug(String msg) {
        if (this.locationAwareLogger != null) {
            this.locationAwareLogger.log(null, FQCN, 10, msg, null, null);
            return;
        }
        this.logger.debug(msg);
    }

    @Override
    public void debug(Throwable e) {
        if (this.locationAwareLogger != null) {
            this.locationAwareLogger.log(null, FQCN, 10, e.getMessage(), null, e);
            return;
        }
        this.logger.debug(e.getMessage(), e);
    }

    @Override
    public void debug(String msg, Throwable e) {
        if (this.locationAwareLogger != null) {
            this.locationAwareLogger.log(null, FQCN, 10, msg, null, e);
            return;
        }
        this.logger.debug(msg, e);
    }

    @Override
    public void info(String msg) {
        if (this.locationAwareLogger != null) {
            this.locationAwareLogger.log(null, FQCN, 20, msg, null, null);
            return;
        }
        this.logger.info(msg);
    }

    @Override
    public void info(Throwable e) {
        if (this.locationAwareLogger != null) {
            this.locationAwareLogger.log(null, FQCN, 20, e.getMessage(), null, e);
            return;
        }
        this.logger.info(e.getMessage(), e);
    }

    @Override
    public void info(String msg, Throwable e) {
        if (this.locationAwareLogger != null) {
            this.locationAwareLogger.log(null, FQCN, 20, msg, null, e);
            return;
        }
        this.logger.info(msg, e);
    }

    @Override
    public void warn(String msg) {
        if (this.locationAwareLogger != null) {
            this.locationAwareLogger.log(null, FQCN, 30, msg, null, null);
            return;
        }
        this.logger.warn(msg);
    }

    @Override
    public void warn(Throwable e) {
        if (this.locationAwareLogger != null) {
            this.locationAwareLogger.log(null, FQCN, 30, e.getMessage(), null, e);
            return;
        }
        this.logger.warn(e.getMessage(), e);
    }

    @Override
    public void warn(String msg, Throwable e) {
        if (this.locationAwareLogger != null) {
            this.locationAwareLogger.log(null, FQCN, 30, msg, null, e);
            return;
        }
        this.logger.warn(msg, e);
    }

    @Override
    public void error(String msg) {
        if (this.locationAwareLogger != null) {
            this.locationAwareLogger.log(null, FQCN, 40, msg, null, null);
            return;
        }
        this.logger.error(msg);
    }

    @Override
    public void error(Throwable e) {
        if (this.locationAwareLogger != null) {
            this.locationAwareLogger.log(null, FQCN, 40, e.getMessage(), null, e);
            return;
        }
        this.logger.error(e.getMessage(), e);
    }

    @Override
    public void error(String msg, Throwable e) {
        if (this.locationAwareLogger != null) {
            this.locationAwareLogger.log(null, FQCN, 40, msg, null, e);
            return;
        }
        this.logger.error(msg, e);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public static Level getLevel(org.slf4j.Logger logger) {
        if (logger.isTraceEnabled()) {
            return Level.TRACE;
        }
        if (logger.isDebugEnabled()) {
            return Level.DEBUG;
        }
        if (logger.isInfoEnabled()) {
            return Level.INFO;
        }
        if (logger.isWarnEnabled()) {
            return Level.WARN;
        }
        if (logger.isErrorEnabled()) {
            return Level.ERROR;
        }
        return Level.OFF;
    }

    public Level getLevel() {
        return Slf4jLogger.getLevel(this.logger);
    }
}

