/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.url.component.ServiceConfigURL;
import org.apache.dubbo.common.url.component.URLAddress;
import org.apache.dubbo.common.url.component.URLParam;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.MetadataInfo;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.model.ServiceModel;

public class InstanceAddressURL
extends URL {
    private final ServiceInstance instance;
    private final MetadataInfo metadataInfo;
    private volatile transient Set<String> providerFirstParams;
    private final transient String protocol;

    protected InstanceAddressURL() {
        this((ServiceInstance)null, (MetadataInfo)null, (String)null);
    }

    public InstanceAddressURL(ServiceInstance instance, MetadataInfo metadataInfo) {
        this.instance = instance;
        this.metadataInfo = metadataInfo;
        this.protocol = "dubbo";
    }

    public InstanceAddressURL(ServiceInstance instance, MetadataInfo metadataInfo, String protocol) {
        this.instance = instance;
        this.metadataInfo = metadataInfo;
        this.protocol = protocol;
    }

    public ServiceInstance getInstance() {
        return this.instance;
    }

    public MetadataInfo getMetadataInfo() {
        return this.metadataInfo;
    }

    @Override
    public String getServiceInterface() {
        return RpcContext.getServiceContext().getInterfaceName();
    }

    @Override
    public String getGroup() {
        return RpcContext.getServiceContext().getGroup();
    }

    @Override
    public String getVersion() {
        return RpcContext.getServiceContext().getVersion();
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public String getProtocolServiceKey() {
        String consumerProtocol;
        URL consumerURL = RpcContext.getServiceContext().getConsumerUrl();
        String string = consumerProtocol = consumerURL == null ? null : consumerURL.getProtocol();
        if (StringUtils.isEquals(consumerProtocol, "consumer")) {
            return RpcContext.getServiceContext().getServiceKey();
        }
        return RpcContext.getServiceContext().getProtocolServiceKey();
    }

    @Override
    public String getServiceKey() {
        return RpcContext.getServiceContext().getServiceKey();
    }

    @Override
    public URL setProtocol(String protocol) {
        return new ServiceConfigURL(protocol, this.getUsername(), this.getPassword(), this.getHost(), this.getPort(), this.getPath(), this.getParameters(), this.attributes);
    }

    @Override
    public URL setHost(String host) {
        return new ServiceConfigURL(this.getProtocol(), this.getUsername(), this.getPassword(), host, this.getPort(), this.getPath(), this.getParameters(), this.attributes);
    }

    @Override
    public URL setPort(int port) {
        return new ServiceConfigURL(this.getProtocol(), this.getUsername(), this.getPassword(), this.getHost(), port, this.getPath(), this.getParameters(), this.attributes);
    }

    @Override
    public URL setPath(String path) {
        return new ServiceConfigURL(this.getProtocol(), this.getUsername(), this.getPassword(), this.getHost(), this.getPort(), path, this.getParameters(), this.attributes);
    }

    @Override
    public String getAddress() {
        return this.instance.getAddress();
    }

    @Override
    public String getHost() {
        return this.instance.getHost();
    }

    @Override
    public int getPort() {
        return this.instance.getPort();
    }

    @Override
    public String getIp() {
        return this.instance.getHost();
    }

    @Override
    public String getRemoteApplication() {
        return this.instance.getServiceName();
    }

    @Override
    public String getSide() {
        return "consumer";
    }

    @Override
    public String getPath() {
        MetadataInfo.ServiceInfo serviceInfo = null;
        String protocolServiceKey = this.getProtocolServiceKey();
        if (StringUtils.isNotEmpty(protocolServiceKey)) {
            serviceInfo = this.getServiceInfo(protocolServiceKey);
        }
        if (serviceInfo == null) {
            return this.getServiceInterface();
        }
        return serviceInfo.getPath();
    }

    @Override
    public String getOriginalParameter(String key) {
        if ("version".equals(key)) {
            return this.getVersion();
        }
        if ("group".equals(key)) {
            return this.getGroup();
        }
        if ("interface".equals(key)) {
            return this.getServiceInterface();
        }
        if ("remote.application".equals(key)) {
            return this.instance.getServiceName();
        }
        if ("side".equals(key)) {
            return this.getSide();
        }
        String protocolServiceKey = this.getProtocolServiceKey();
        if (StringUtils.isEmpty(protocolServiceKey)) {
            return this.getInstanceParameter(key);
        }
        return this.getServiceParameter(protocolServiceKey, key);
    }

    @Override
    public String getParameter(String key) {
        String v;
        URL consumerUrl;
        if ("version".equals(key)) {
            return this.getVersion();
        }
        if ("group".equals(key)) {
            return this.getGroup();
        }
        if ("interface".equals(key)) {
            return this.getServiceInterface();
        }
        if ("remote.application".equals(key)) {
            return this.instance.getServiceName();
        }
        if ("side".equals(key)) {
            return this.getSide();
        }
        if (this.consumerParamFirst(key) && (consumerUrl = RpcContext.getServiceContext().getConsumerUrl()) != null && StringUtils.isNotEmpty(v = consumerUrl.getParameter(key))) {
            return v;
        }
        String protocolServiceKey = this.getProtocolServiceKey();
        if (StringUtils.isEmpty(protocolServiceKey)) {
            return this.getInstanceParameter(key);
        }
        return this.getServiceParameter(protocolServiceKey, key);
    }

    @Override
    public String getOriginalServiceParameter(String service, String key) {
        String value;
        if (this.metadataInfo != null && StringUtils.isNotEmpty(value = this.metadataInfo.getParameter(key, service))) {
            return value;
        }
        return this.getInstanceParameter(key);
    }

    @Override
    public String getServiceParameter(String service, String key) {
        String value;
        String v;
        URL consumerUrl;
        if (this.consumerParamFirst(key) && (consumerUrl = RpcContext.getServiceContext().getConsumerUrl()) != null && StringUtils.isNotEmpty(v = consumerUrl.getServiceParameter(service, key))) {
            return v;
        }
        if (this.metadataInfo != null && StringUtils.isNotEmpty(value = this.metadataInfo.getParameter(key, service))) {
            return value;
        }
        return this.getInstanceParameter(key);
    }

    @Override
    public String getServiceMethodParameter(String protocolServiceKey, String method, String key) {
        String v;
        URL consumerUrl;
        if (this.consumerParamFirst(key) && (consumerUrl = RpcContext.getServiceContext().getConsumerUrl()) != null && StringUtils.isNotEmpty(v = consumerUrl.getServiceMethodParameter(protocolServiceKey, method, key))) {
            return v;
        }
        MetadataInfo.ServiceInfo serviceInfo = this.getServiceInfo(protocolServiceKey);
        if (null == serviceInfo) {
            return this.getParameter(key);
        }
        String value = serviceInfo.getMethodParameter(method, key, (String)null);
        if (StringUtils.isNotEmpty(value)) {
            return value;
        }
        return this.getParameter(key);
    }

    @Override
    public String getMethodParameter(String method, String key) {
        String v;
        URL consumerUrl;
        if (this.consumerParamFirst(key) && (consumerUrl = RpcContext.getServiceContext().getConsumerUrl()) != null && StringUtils.isNotEmpty(v = consumerUrl.getMethodParameter(method, key))) {
            return v;
        }
        String protocolServiceKey = this.getProtocolServiceKey();
        if (StringUtils.isEmpty(protocolServiceKey)) {
            return null;
        }
        return this.getServiceMethodParameter(protocolServiceKey, method, key);
    }

    @Override
    public boolean hasServiceMethodParameter(String protocolServiceKey, String method, String key) {
        URL consumerUrl;
        if (this.consumerParamFirst(key) && (consumerUrl = RpcContext.getServiceContext().getConsumerUrl()) != null && consumerUrl.hasServiceMethodParameter(protocolServiceKey, method, key)) {
            return true;
        }
        MetadataInfo.ServiceInfo serviceInfo = this.getServiceInfo(protocolServiceKey);
        if (StringUtils.isEmpty(method)) {
            String suffix = "." + key;
            for (String fullKey : this.getParameters().keySet()) {
                if (!fullKey.endsWith(suffix)) continue;
                return true;
            }
            return false;
        }
        if (StringUtils.isEmpty(key)) {
            String prefix = method + ".";
            for (String fullKey : this.getParameters().keySet()) {
                if (!fullKey.startsWith(prefix)) continue;
                return true;
            }
            return false;
        }
        if (null == serviceInfo) {
            return false;
        }
        return serviceInfo.hasMethodParameter(method, key);
    }

    @Override
    public boolean hasMethodParameter(String method, String key) {
        URL consumerUrl;
        if (this.consumerParamFirst(key) && (consumerUrl = RpcContext.getServiceContext().getConsumerUrl()) != null && consumerUrl.hasMethodParameter(method, key)) {
            return true;
        }
        String protocolServiceKey = this.getProtocolServiceKey();
        if (StringUtils.isEmpty(protocolServiceKey)) {
            return false;
        }
        return this.hasServiceMethodParameter(protocolServiceKey, method, key);
    }

    @Override
    public boolean hasServiceMethodParameter(String protocolServiceKey, String method) {
        URL consumerUrl = RpcContext.getServiceContext().getConsumerUrl();
        if (consumerUrl != null && consumerUrl.hasServiceMethodParameter(protocolServiceKey, method)) {
            return true;
        }
        MetadataInfo.ServiceInfo serviceInfo = this.getServiceInfo(protocolServiceKey);
        if (null == serviceInfo) {
            return false;
        }
        return serviceInfo.hasMethodParameter(method);
    }

    @Override
    public boolean hasMethodParameter(String method) {
        URL consumerUrl = RpcContext.getServiceContext().getConsumerUrl();
        if (consumerUrl != null && consumerUrl.hasMethodParameter(method)) {
            return true;
        }
        String protocolServiceKey = this.getProtocolServiceKey();
        if (StringUtils.isEmpty(protocolServiceKey)) {
            return false;
        }
        return this.hasServiceMethodParameter(protocolServiceKey, method);
    }

    @Override
    public Map<String, String> getOriginalServiceParameters(String protocolServiceKey) {
        Map<String, String> instanceParams = this.getInstance().getAllParams();
        Map<Object, Object> metadataParams = this.metadataInfo == null ? new HashMap() : this.metadataInfo.getParameters(protocolServiceKey);
        int i = instanceParams == null ? 0 : instanceParams.size();
        int j = metadataParams == null ? 0 : metadataParams.size();
        HashMap<String, String> params = new HashMap<String, String>((int)((double)(i + j) / 0.75) + 1);
        if (instanceParams != null) {
            params.putAll(instanceParams);
        }
        if (metadataParams != null) {
            params.putAll(metadataParams);
        }
        return params;
    }

    @Override
    public Map<String, String> getServiceParameters(String protocolServiceKey) {
        URL consumerUrl;
        Map<String, String> instanceParams = this.getInstance().getAllParams();
        Map<Object, Object> metadataParams = this.metadataInfo == null ? new HashMap() : this.metadataInfo.getParameters(protocolServiceKey);
        int i = instanceParams == null ? 0 : instanceParams.size();
        int j = metadataParams == null ? 0 : metadataParams.size();
        HashMap<String, String> params = new HashMap<String, String>((int)((double)(i + j) / 0.75) + 1);
        if (instanceParams != null) {
            params.putAll(instanceParams);
        }
        if (metadataParams != null) {
            params.putAll(metadataParams);
        }
        if ((consumerUrl = RpcContext.getServiceContext().getConsumerUrl()) != null) {
            HashMap<String, String> consumerParams = new HashMap<String, String>(consumerUrl.getParameters());
            if (CollectionUtils.isNotEmpty(this.providerFirstParams)) {
                this.providerFirstParams.forEach(consumerParams::remove);
            }
            params.putAll(consumerParams);
        }
        return params;
    }

    @Override
    public Map<String, String> getOriginalParameters() {
        String protocolServiceKey = this.getProtocolServiceKey();
        if (StringUtils.isEmpty(protocolServiceKey)) {
            return this.getInstance().getAllParams();
        }
        return this.getOriginalServiceParameters(protocolServiceKey);
    }

    @Override
    public Map<String, String> getParameters() {
        String protocolServiceKey = this.getProtocolServiceKey();
        if (StringUtils.isEmpty(protocolServiceKey)) {
            return this.getInstance().getAllParams();
        }
        return this.getServiceParameters(protocolServiceKey);
    }

    @Override
    public URL addParameter(String key, String value) {
        if (StringUtils.isEmpty(key) || StringUtils.isEmpty(value)) {
            return this;
        }
        this.getInstance().putExtendParam(key, value);
        return this;
    }

    @Override
    public URL addParameterIfAbsent(String key, String value) {
        if (StringUtils.isEmpty(key) || StringUtils.isEmpty(value)) {
            return this;
        }
        this.getInstance().putExtendParamIfAbsent(key, value);
        return this;
    }

    public URL addServiceParameter(String protocolServiceKey, String key, String value) {
        if (StringUtils.isEmpty(key) || StringUtils.isEmpty(value)) {
            return this;
        }
        MetadataInfo.ServiceInfo serviceInfo = this.getServiceInfo(protocolServiceKey);
        if (null != serviceInfo) {
            serviceInfo.addParameter(key, value);
        }
        return this;
    }

    public URL addServiceParameterIfAbsent(String protocolServiceKey, String key, String value) {
        if (StringUtils.isEmpty(key) || StringUtils.isEmpty(value)) {
            return this;
        }
        MetadataInfo.ServiceInfo serviceInfo = this.getServiceInfo(protocolServiceKey);
        if (null != serviceInfo) {
            serviceInfo.addParameterIfAbsent(key, value);
        }
        return this;
    }

    public URL addConsumerParams(String protocolServiceKey, Map<String, String> params) {
        MetadataInfo.ServiceInfo serviceInfo = this.getServiceInfo(protocolServiceKey);
        if (null != serviceInfo) {
            serviceInfo.addConsumerParams(params);
        }
        return this;
    }

    @Override
    public String getAnyMethodParameter(String key) {
        String v;
        URL consumerUrl;
        if (this.consumerParamFirst(key) && (consumerUrl = RpcContext.getServiceContext().getConsumerUrl()) != null && StringUtils.isNotEmpty(v = consumerUrl.getAnyMethodParameter(key))) {
            return v;
        }
        String suffix = "." + key;
        String protocolServiceKey = this.getProtocolServiceKey();
        if (StringUtils.isNotEmpty(protocolServiceKey)) {
            MetadataInfo.ServiceInfo serviceInfo = this.getServiceInfo(protocolServiceKey);
            if (null == serviceInfo) {
                return null;
            }
            for (String fullKey : serviceInfo.getAllParams().keySet()) {
                if (!fullKey.endsWith(suffix)) continue;
                return this.getParameter(fullKey);
            }
        }
        return null;
    }

    @Override
    public URLParam getUrlParam() {
        throw new UnsupportedOperationException("URLParam is replaced with MetadataInfo in instance url");
    }

    @Override
    public URLAddress getUrlAddress() {
        throw new UnsupportedOperationException("URLAddress is replaced with ServiceInstance in instance url");
    }

    private MetadataInfo.ServiceInfo getServiceInfo(String protocolServiceKey) {
        return this.metadataInfo.getValidServiceInfo(protocolServiceKey);
    }

    private String getInstanceParameter(String key) {
        String value = this.instance.getMetadata().get(key);
        if (StringUtils.isNotEmpty(value)) {
            return value;
        }
        return this.instance.getExtendParam(key);
    }

    private Map<String, String> getInstanceMetadata() {
        return this.instance.getMetadata();
    }

    @Override
    public FrameworkModel getOrDefaultFrameworkModel() {
        return this.instance.getOrDefaultApplicationModel().getFrameworkModel();
    }

    @Override
    public ApplicationModel getOrDefaultApplicationModel() {
        return this.instance.getOrDefaultApplicationModel();
    }

    @Override
    public ApplicationModel getApplicationModel() {
        return this.instance.getApplicationModel();
    }

    @Override
    public ScopeModel getScopeModel() {
        return Optional.ofNullable(RpcContext.getServiceContext().getConsumerUrl()).map(URL::getScopeModel).orElse(super.getScopeModel());
    }

    @Override
    public ServiceModel getServiceModel() {
        return RpcContext.getServiceContext().getConsumerUrl().getServiceModel();
    }

    public Set<String> getProviderFirstParams() {
        return this.providerFirstParams;
    }

    public void setProviderFirstParams(Set<String> providerFirstParams) {
        this.providerFirstParams = providerFirstParams;
    }

    private boolean consumerParamFirst(String key) {
        if (CollectionUtils.isNotEmpty(this.providerFirstParams)) {
            return !this.providerFirstParams.contains(key);
        }
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceAddressURL)) {
            return false;
        }
        InstanceAddressURL that = (InstanceAddressURL)obj;
        return this.getInstance().equals(that.getInstance());
    }

    @Override
    public int hashCode() {
        return this.getInstance().hashCode();
    }

    @Override
    public String toString() {
        if (this.instance == null) {
            return "{}";
        }
        if (this.metadataInfo == null) {
            return this.instance.toString();
        }
        String protocolServiceKey = this.getProtocolServiceKey();
        if (StringUtils.isNotEmpty(protocolServiceKey)) {
            return this.instance.toString() + ", " + this.metadataInfo.getServiceString(protocolServiceKey);
        }
        return this.instance.toString();
    }
}

