/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.configurator.parser.model;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.PojoUtils;
import org.apache.dubbo.rpc.cluster.configurator.parser.model.ConditionMatch;

public class ConfigItem {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(ConfigItem.class);
    public static final String GENERAL_TYPE = "general";
    public static final String WEIGHT_TYPE = "weight";
    public static final String BALANCING_TYPE = "balancing";
    public static final String DISABLED_TYPE = "disabled";
    public static final String CONFIG_ITEM_TYPE = "type";
    public static final String ENABLED_KEY = "enabled";
    public static final String ADDRESSES_KEY = "addresses";
    public static final String PROVIDER_ADDRESSES_KEY = "providerAddresses";
    public static final String SERVICES_KEY = "services";
    public static final String APPLICATIONS_KEY = "applications";
    public static final String PARAMETERS_KEY = "parameters";
    public static final String MATCH_KEY = "match";
    public static final String SIDE_KEY = "side";
    private String type;
    private Boolean enabled;
    private List<String> addresses;
    private List<String> providerAddresses;
    private List<String> services;
    private List<String> applications;
    private Map<String, String> parameters;
    private ConditionMatch match;
    private String side;

    public static ConfigItem parseFromMap(Map<String, Object> map) {
        Object parameters;
        Object applications;
        Object services;
        Object providerAddresses;
        Object addresses;
        ConfigItem configItem = new ConfigItem();
        configItem.setType((String)map.get(CONFIG_ITEM_TYPE));
        Object enabled = map.get(ENABLED_KEY);
        if (enabled != null) {
            configItem.setEnabled(Boolean.parseBoolean(enabled.toString()));
        }
        if ((addresses = map.get(ADDRESSES_KEY)) != null && List.class.isAssignableFrom(addresses.getClass())) {
            configItem.setAddresses(((List)addresses).stream().map(String::valueOf).collect(Collectors.toList()));
        }
        if ((providerAddresses = map.get(PROVIDER_ADDRESSES_KEY)) != null && List.class.isAssignableFrom(providerAddresses.getClass())) {
            configItem.setProviderAddresses(((List)providerAddresses).stream().map(String::valueOf).collect(Collectors.toList()));
        }
        if ((services = map.get(SERVICES_KEY)) != null && List.class.isAssignableFrom(services.getClass())) {
            configItem.setServices(((List)services).stream().map(String::valueOf).collect(Collectors.toList()));
        }
        if ((applications = map.get(APPLICATIONS_KEY)) != null && List.class.isAssignableFrom(applications.getClass())) {
            configItem.setApplications(((List)applications).stream().map(String::valueOf).collect(Collectors.toList()));
        }
        if ((parameters = map.get(PARAMETERS_KEY)) != null && Map.class.isAssignableFrom(parameters.getClass())) {
            configItem.setParameters(((Map)parameters).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue().toString())));
        }
        try {
            Object match = map.get(MATCH_KEY);
            if (match != null && Map.class.isAssignableFrom(match.getClass())) {
                configItem.setMatch(PojoUtils.mapToPojo((Map)match, ConditionMatch.class));
            }
        }
        catch (Throwable t) {
            logger.error("2-13", " Failed to parse dynamic configuration rule", String.valueOf(map.get(MATCH_KEY)), "Error occurred when parsing rule component.", t);
        }
        configItem.setSide((String)map.get(SIDE_KEY));
        return configItem;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public List<String> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<String> addresses) {
        this.addresses = addresses;
    }

    public List<String> getServices() {
        return this.services;
    }

    public void setServices(List<String> services) {
        this.services = services;
    }

    public List<String> getApplications() {
        return this.applications;
    }

    public void setApplications(List<String> applications) {
        this.applications = applications;
    }

    public List<String> getProviderAddresses() {
        return this.providerAddresses;
    }

    public void setProviderAddresses(List<String> providerAddresses) {
        this.providerAddresses = providerAddresses;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public String getSide() {
        return this.side;
    }

    public void setSide(String side) {
        this.side = side;
    }

    public ConditionMatch getMatch() {
        return this.match;
    }

    public void setMatch(ConditionMatch match) {
        this.match = match;
    }
}

