/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch.nodes.IngestTotal;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Ingest
implements JsonpSerializable {
    private final Map<String, IngestTotal> pipelines;
    @Nullable
    private final IngestTotal total;
    public static final JsonpDeserializer<Ingest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Ingest::setupIngestDeserializer);

    private Ingest(Builder builder) {
        this.pipelines = ApiTypeHelper.unmodifiable(builder.pipelines);
        this.total = builder.total;
    }

    public static Ingest of(Function<Builder, ObjectBuilder<Ingest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, IngestTotal> pipelines() {
        return this.pipelines;
    }

    @Nullable
    public final IngestTotal total() {
        return this.total;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.pipelines)) {
            generator.writeKey("pipelines");
            generator.writeStartObject();
            for (Map.Entry<String, IngestTotal> item0 : this.pipelines.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.total != null) {
            generator.writeKey("total");
            this.total.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupIngestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::pipelines, JsonpDeserializer.stringMapDeserializer(IngestTotal._DESERIALIZER), "pipelines");
        op.add(Builder::total, IngestTotal._DESERIALIZER, "total");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Ingest> {
        @Nullable
        private Map<String, IngestTotal> pipelines;
        @Nullable
        private IngestTotal total;

        public final Builder pipelines(Map<String, IngestTotal> map) {
            this.pipelines = Builder._mapPutAll(this.pipelines, map);
            return this;
        }

        public final Builder pipelines(String key, IngestTotal value) {
            this.pipelines = Builder._mapPut(this.pipelines, key, value);
            return this;
        }

        public final Builder pipelines(String key, Function<IngestTotal.Builder, ObjectBuilder<IngestTotal>> fn) {
            return this.pipelines(key, fn.apply(new IngestTotal.Builder()).build());
        }

        public final Builder total(@Nullable IngestTotal value) {
            this.total = value;
            return this;
        }

        public final Builder total(Function<IngestTotal.Builder, ObjectBuilder<IngestTotal>> fn) {
            return this.total(fn.apply(new IngestTotal.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Ingest build() {
            this._checkSingleUse();
            return new Ingest(this);
        }
    }
}

