/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.casdoor;

import java.util.Objects;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.Singleton;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.casbin.casdoor.entity.CasdoorUser;
import org.casbin.casdoor.service.CasdoorAuthService;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class CasdoorPlugin
extends AbstractShenyuPlugin {
    protected Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
        CasdoorUser casdoorUser;
        CasdoorUser casdoorUser2;
        CasdoorAuthService casdoorAuthService = (CasdoorAuthService)Singleton.INST.get(CasdoorAuthService.class);
        ServerHttpRequest request = exchange.getRequest();
        String token = exchange.getRequest().getHeaders().getFirst("Authorization");
        if (Objects.nonNull(token) && Objects.nonNull(casdoorUser2 = casdoorAuthService.parseJwtToken(token))) {
            return chain.execute(this.handleToken(exchange, casdoorUser2));
        }
        MultiValueMap queryParams = request.getQueryParams();
        String code = (String)queryParams.getFirst((Object)"code");
        String state = (String)queryParams.getFirst((Object)"state");
        if ((Objects.nonNull(code) || Objects.nonNull(state)) && Objects.nonNull(casdoorUser = casdoorAuthService.parseJwtToken(token = casdoorAuthService.getOAuthToken(code, state)))) {
            return chain.execute(this.handleToken(exchange, casdoorUser));
        }
        Object error = ShenyuResultWrap.error((ServerWebExchange)exchange, (ShenyuResultEnum)ShenyuResultEnum.ERROR_TOKEN);
        return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
    }

    public int getOrder() {
        return PluginEnum.CASDOOR.getCode();
    }

    public String named() {
        return PluginEnum.CASDOOR.getName();
    }

    public boolean skip(ServerWebExchange exchange) {
        return false;
    }

    private ServerWebExchange handleToken(ServerWebExchange exchange, CasdoorUser casdoorUser) {
        ServerHttpRequest.Builder mutate = exchange.getRequest().mutate();
        mutate.header("name", new String[]{casdoorUser.getName()});
        mutate.header("id", new String[]{casdoorUser.getId()});
        mutate.header("organization", new String[]{casdoorUser.getOwner()});
        return exchange.mutate().request(mutate.build()).build();
    }
}

