/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.casdoor.handle;

import java.util.Map;
import java.util.Optional;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.Singleton;
import org.apache.shenyu.plugin.base.handler.PluginDataHandler;
import org.casbin.casdoor.config.CasdoorConfig;
import org.casbin.casdoor.service.CasdoorAuthService;

public class CasdoorPluginDateHandler
implements PluginDataHandler {
    public void handlerPlugin(PluginData pluginData) {
        Map configMap = GsonUtils.getInstance().toObjectMap(pluginData.getConfig(), String.class);
        String endpoint = Optional.ofNullable((String)configMap.get("endpoint")).orElse("");
        String clientSecrect = Optional.ofNullable((String)configMap.get("client_secrect")).orElse("");
        String clientId = Optional.ofNullable((String)configMap.get("client_id")).orElse("");
        String certificate = Optional.ofNullable((String)configMap.get("certificate")).orElse("");
        certificate = certificate.replace("\\n", "\n");
        String organization = Optional.ofNullable((String)configMap.get("organization-name")).orElse("");
        String application = Optional.ofNullable((String)configMap.get("application-name")).orElse("");
        CasdoorConfig casdoorConfig = new CasdoorConfig(endpoint, clientId, clientSecrect, certificate, organization, application);
        CasdoorAuthService casdoorAuthService = new CasdoorAuthService(casdoorConfig);
        Singleton.INST.single(CasdoorAuthService.class, (Object)casdoorAuthService);
    }

    public String pluginNamed() {
        return PluginEnum.CASDOOR.getName();
    }
}

