/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.ai.transformer.response.handler;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.convert.plugin.AiResponseTransformerConfig;
import org.apache.shenyu.common.dto.convert.rule.AiResponseTransformerHandle;
import org.apache.shenyu.common.enums.AiModelProviderEnum;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.Singleton;
import org.apache.shenyu.plugin.ai.common.config.AiCommonConfig;
import org.apache.shenyu.plugin.ai.common.spring.ai.AiModelFactory;
import org.apache.shenyu.plugin.ai.common.spring.ai.registry.AiModelFactoryRegistry;
import org.apache.shenyu.plugin.ai.transformer.response.cache.ChatClientCache;
import org.apache.shenyu.plugin.base.cache.CommonHandleCache;
import org.apache.shenyu.plugin.base.handler.PluginDataHandler;
import org.apache.shenyu.plugin.base.utils.BeanHolder;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AiResponseTransformerPluginHandler
implements PluginDataHandler {
    public static final Supplier<CommonHandleCache<String, AiResponseTransformerHandle>> CACHED_HANDLE = new BeanHolder(CommonHandleCache::new);
    private static final Logger LOG = LoggerFactory.getLogger(AiResponseTransformerPluginHandler.class);
    private final AiModelFactoryRegistry aiModelFactoryRegistry;

    public AiResponseTransformerPluginHandler(AiModelFactoryRegistry aiModelFactoryRegistry) {
        this.aiModelFactoryRegistry = aiModelFactoryRegistry;
    }

    public void handlerPlugin(PluginData pluginData) {
        if (Objects.nonNull(pluginData) && pluginData.getEnabled().booleanValue()) {
            try {
                AiResponseTransformerConfig aiResponseTransformerConfig = (AiResponseTransformerConfig)GsonUtils.getInstance().fromJson(pluginData.getConfig(), AiResponseTransformerConfig.class);
                if (Objects.isNull(aiResponseTransformerConfig)) {
                    return;
                }
                AiModelFactory factory = this.aiModelFactoryRegistry.getFactory(AiModelProviderEnum.getByName((String)aiResponseTransformerConfig.getProvider()));
                ChatClientCache.getInstance().init("default", factory.createAiModel(AiResponseTransformerPluginHandler.convertConfig(aiResponseTransformerConfig)));
                Singleton.INST.single(AiResponseTransformerConfig.class, (Object)aiResponseTransformerConfig);
            }
            catch (Exception e) {
                return;
            }
        }
    }

    public void handlerRule(RuleData ruleData) {
        Optional.ofNullable(ruleData.getHandle()).ifPresent(s -> {
            try {
                AiResponseTransformerHandle aiResponseTransformerHandle = (AiResponseTransformerHandle)GsonUtils.getInstance().fromJson(s, AiResponseTransformerHandle.class);
                if (Objects.nonNull(aiResponseTransformerHandle)) {
                    CACHED_HANDLE.get().cachedHandle((Object)CacheKeyUtils.INST.getKey(ruleData), (Object)aiResponseTransformerHandle);
                }
            }
            catch (Exception e) {
                LOG.error("AiResponseTransformerPluginHandler handle rule error", (Throwable)e);
                return;
            }
        });
        ChatClientCache.getInstance().destroyClient(ruleData.getId());
    }

    public void removeRule(RuleData ruleData) {
        Optional.ofNullable(ruleData.getHandle()).ifPresent(s -> CACHED_HANDLE.get().removeHandle((Object)CacheKeyUtils.INST.getKey(ruleData)));
        try {
            AiResponseTransformerHandle aiResponseTransformerHandle = (AiResponseTransformerHandle)GsonUtils.getInstance().fromJson(ruleData.getHandle(), AiResponseTransformerHandle.class);
            if (Objects.nonNull(aiResponseTransformerHandle) && Objects.nonNull(aiResponseTransformerHandle.getProvider())) {
                ChatClientCache.getInstance().destroyClient(ruleData.getId() + aiResponseTransformerHandle.getProvider());
            }
        }
        catch (Exception e) {
            LOG.error("AiResponseTransformerPluginHandler remove rule error", (Throwable)e);
            return;
        }
    }

    public String pluginNamed() {
        return PluginEnum.AI_RESPONSE_TRANSFORMER.getName();
    }

    public static AiCommonConfig convertConfig(AiResponseTransformerConfig aiResponseTransformerConfig) {
        AiCommonConfig aiCommonConfig = new AiCommonConfig();
        Optional.ofNullable(aiResponseTransformerConfig.getBaseUrl()).ifPresent(arg_0 -> ((AiCommonConfig)aiCommonConfig).setBaseUrl(arg_0));
        Optional.ofNullable(aiResponseTransformerConfig.getProvider()).ifPresent(arg_0 -> ((AiCommonConfig)aiCommonConfig).setProvider(arg_0));
        Optional.ofNullable(aiResponseTransformerConfig.getModel()).ifPresent(arg_0 -> ((AiCommonConfig)aiCommonConfig).setModel(arg_0));
        Optional.ofNullable(aiResponseTransformerConfig.getApiKey()).ifPresent(arg_0 -> ((AiCommonConfig)aiCommonConfig).setApiKey(arg_0));
        return aiCommonConfig;
    }
}

