/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.lookout.api;

import com.alipay.lookout.api.BasicTag;
import com.alipay.lookout.api.Tag;
import com.alipay.lookout.common.Assert;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

final class TagSet
implements Iterable<Tag> {
    private final TreeMap<String, Tag> tags;
    static final TagSet EMPTY = new TagSet(new TreeMap<String, Tag>());

    static TagSet create(Iterable<Tag> tags) {
        return EMPTY.addAll(tags);
    }

    static TagSet create(Map<String, String> tags) {
        return EMPTY.addAll(tags);
    }

    public TagSet(TreeMap<String, Tag> tags) {
        this.tags = tags;
    }

    @Override
    public Iterator<Tag> iterator() {
        return Collections.unmodifiableCollection(this.tags.values()).iterator();
    }

    boolean isEmpty() {
        return this.tags.isEmpty();
    }

    TagSet add(String k, String v) {
        return this.add(new BasicTag(k, v));
    }

    TagSet add(Tag tag) {
        if (tag == null) {
            return this;
        }
        TreeMap<String, Tag> newTags = new TreeMap<String, Tag>((SortedMap<String, Tag>)this.tags);
        newTags.put(tag.key(), tag);
        return new TagSet(newTags);
    }

    TagSet addAll(Iterable<Tag> ts) {
        if (ts instanceof TagSet) {
            TagSet data = (TagSet)ts;
            return this.addAll(data.tags.values());
        }
        Iterator<Tag> it = ts.iterator();
        TreeMap<String, Tag> newTags = new TreeMap<String, Tag>((SortedMap<String, Tag>)this.tags);
        while (it.hasNext()) {
            BasicTag tag = BasicTag.of(it.next());
            newTags.put(tag.key(), tag);
        }
        return new TagSet(newTags);
    }

    TagSet addAll(Map<String, String> ts) {
        if (ts == null || ts.isEmpty()) {
            return this;
        }
        TreeMap<String, Tag> newTags = new TreeMap<String, Tag>((SortedMap<String, Tag>)this.tags);
        for (Map.Entry<String, String> entry : ts.entrySet()) {
            newTags.put(entry.getKey(), new BasicTag(entry.getKey(), entry.getValue()));
        }
        return new TagSet(newTags);
    }

    TagSet addAll(String[] ts) {
        Assert.checkArg(ts.length % 2 == 0, "the length of the array type argument must be even\uff01length\uff1a" + ts.length);
        if (ts.length == 0) {
            return this;
        }
        TreeMap<String, Tag> newTags = new TreeMap<String, Tag>((SortedMap<String, Tag>)this.tags);
        int length = ts.length / 2;
        for (int i = 0; i < length; ++i) {
            int j = i * 2;
            newTags.put(ts[j], new BasicTag(ts[j], ts[j + 1]));
        }
        return new TagSet(newTags);
    }

    TagSet addAll(Tag[] ts) {
        if (ts.length == 0) {
            return this;
        }
        TreeMap<String, Tag> newTags = new TreeMap<String, Tag>((SortedMap<String, Tag>)this.tags);
        for (int i = 0; i < ts.length; ++i) {
            BasicTag basicTag = BasicTag.of(ts[i]);
            newTags.put(basicTag.key(), basicTag);
        }
        return new TagSet(newTags);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TagSet other = (TagSet)o;
        if (this.tags.size() != other.tags.size()) {
            return false;
        }
        return this.tags.equals(other.tags);
    }

    public int hashCode() {
        return Arrays.hashCode(this.tags.values().toArray());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.tags.values());
        return builder.toString();
    }
}

