/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.common.tracer.core.reporter.digest;

import com.alipay.common.tracer.core.appender.encoder.SpanEncoder;
import com.alipay.common.tracer.core.appender.file.LoadTestAwareAppender;
import com.alipay.common.tracer.core.appender.manager.AsyncCommonDigestAppenderManager;
import com.alipay.common.tracer.core.appender.self.SelfLog;
import com.alipay.common.tracer.core.configuration.SofaTracerConfiguration;
import com.alipay.common.tracer.core.reporter.digest.AbstractDiskReporter;
import com.alipay.common.tracer.core.reporter.digest.manager.SofaTracerDigestReporterAsyncManager;
import com.alipay.common.tracer.core.reporter.stat.SofaTracerStatisticReporter;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.common.tracer.core.utils.AssertUtils;
import com.alipay.common.tracer.core.utils.StringUtils;
import java.util.concurrent.atomic.AtomicBoolean;

public class DiskReporterImpl
extends AbstractDiskReporter {
    private final AtomicBoolean isDigestFileInited = new AtomicBoolean(false);
    private final String digestLogType;
    private final String digestRollingPolicy;
    private String digestLogReserveConfig;
    private final SpanEncoder contextEncoder;
    private String logNameKey;
    private SofaTracerStatisticReporter statReporter;

    public DiskReporterImpl(String digestLogType, SpanEncoder contextEncoder) {
        this(digestLogType, "", "", contextEncoder, null);
    }

    public DiskReporterImpl(String digestLogType, String digestRollingPolicy, String digestLogReserveConfig, SpanEncoder contextEncoder) {
        this(digestLogType, digestRollingPolicy, digestLogReserveConfig, contextEncoder, null);
    }

    public DiskReporterImpl(String digestLogType, String digestRollingPolicy, String digestLogReserveConfig, SpanEncoder contextEncoder, SofaTracerStatisticReporter statReporter) {
        this(digestLogType, digestRollingPolicy, digestLogReserveConfig, contextEncoder, statReporter, null);
    }

    public DiskReporterImpl(String digestLogType, String digestRollingPolicy, String digestLogReserveConfig, SpanEncoder contextEncoder, SofaTracerStatisticReporter statReporter, String logNameKey) {
        AssertUtils.hasText(digestLogType, "digestLogType can't be empty");
        this.digestLogType = digestLogType;
        this.digestRollingPolicy = digestRollingPolicy;
        this.digestLogReserveConfig = digestLogReserveConfig;
        this.contextEncoder = contextEncoder;
        this.statReporter = statReporter;
        this.logNameKey = logNameKey;
    }

    public SofaTracerStatisticReporter getStatReporter() {
        return this.statReporter;
    }

    public void setStatReporter(SofaTracerStatisticReporter statReporter) {
        this.statReporter = statReporter;
    }

    @Override
    public String getDigestReporterType() {
        return this.digestLogType;
    }

    @Override
    public String getStatReporterType() {
        if (this.statReporter != null) {
            return this.statReporter.getStatTracerName();
        }
        return "";
    }

    @Override
    public void digestReport(SofaTracerSpan span) {
        AsyncCommonDigestAppenderManager asyncDigestManager;
        if (!this.isDigestFileInited.get()) {
            this.initDigestFile();
        }
        if ((asyncDigestManager = SofaTracerDigestReporterAsyncManager.getSofaTracerDigestReporterAsyncManager()).isAppenderAndEncoderExist(this.digestLogType)) {
            asyncDigestManager.append(span);
        } else {
            SelfLog.warn(span.toString() + " have no logType set, so ignore data persistence.");
        }
    }

    @Override
    public void statisticReport(SofaTracerSpan span) {
        if (this.statReporter != null) {
            this.statReporter.reportStat(span);
        }
    }

    public AtomicBoolean getIsDigestFileInited() {
        return this.isDigestFileInited;
    }

    public String getDigestLogType() {
        return this.digestLogType;
    }

    public String getDigestRollingPolicy() {
        return this.digestRollingPolicy;
    }

    public String getDigestLogReserveConfig() {
        return this.digestLogReserveConfig;
    }

    public SpanEncoder getContextEncoder() {
        return this.contextEncoder;
    }

    public String getLogNameKey() {
        return this.logNameKey;
    }

    private synchronized void initDigestFile() {
        String currentDigestLogReserveConfig;
        if (this.isDigestFileInited.get()) {
            return;
        }
        if (StringUtils.isNotBlank(this.logNameKey) && !(currentDigestLogReserveConfig = SofaTracerConfiguration.getLogReserveConfig(this.logNameKey)).equals(this.digestLogReserveConfig)) {
            SelfLog.info("the lognamekey : " + this.logNameKey + " take effect. the old logreserveconfig is " + this.digestLogReserveConfig + " and the new logreverseconfig is " + currentDigestLogReserveConfig);
            this.digestLogReserveConfig = currentDigestLogReserveConfig;
        }
        LoadTestAwareAppender digestTraceAppender = LoadTestAwareAppender.createLoadTestAwareTimedRollingFileAppender(this.digestLogType, this.digestRollingPolicy, this.digestLogReserveConfig);
        AsyncCommonDigestAppenderManager asyncDigestManager = SofaTracerDigestReporterAsyncManager.getSofaTracerDigestReporterAsyncManager();
        if (!asyncDigestManager.isAppenderAndEncoderExist(this.digestLogType)) {
            asyncDigestManager.addAppender(this.digestLogType, digestTraceAppender, this.contextEncoder);
        }
        this.isDigestFileInited.set(true);
    }
}

