/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.springboot.starter.plugin.ai.transformer.response;

import java.util.List;
import org.apache.shenyu.plugin.ai.common.spring.ai.AiModelFactory;
import org.apache.shenyu.plugin.ai.common.spring.ai.factory.DeepSeekModelFactory;
import org.apache.shenyu.plugin.ai.common.spring.ai.factory.OpenAiModelFactory;
import org.apache.shenyu.plugin.ai.common.spring.ai.registry.AiModelFactoryRegistry;
import org.apache.shenyu.plugin.ai.transformer.response.AiResponseTransformerPlugin;
import org.apache.shenyu.plugin.ai.transformer.response.handler.AiResponseTransformerPluginHandler;
import org.apache.shenyu.plugin.api.ShenyuPlugin;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.codec.ServerCodecConfigurer;

@Configuration
@ConditionalOnProperty(value={"shenyu.plugins.ai.transformer.response.enabled"}, havingValue="true", matchIfMissing=true)
public class AiResponseTransformerPluginConfiguration {
    @Bean
    public ShenyuPlugin aiResponseTransformerPlugin(ServerCodecConfigurer configurer, List<AiModelFactory> aiModelFactoryList) {
        return new AiResponseTransformerPlugin(configurer.getReaders(), this.aiModelFactoryRegistry(aiModelFactoryList));
    }

    @Bean
    public AiResponseTransformerPluginHandler aiResponseTransformerPluginHandler(AiModelFactoryRegistry aiModelFactoryRegistry) {
        return new AiResponseTransformerPluginHandler(aiModelFactoryRegistry);
    }

    @Bean
    public AiModelFactoryRegistry aiModelFactoryRegistry(List<AiModelFactory> aiModelFactoryList) {
        return new AiModelFactoryRegistry(aiModelFactoryList);
    }

    @Bean
    public OpenAiModelFactory openAiModelFactory() {
        return new OpenAiModelFactory();
    }

    @Bean
    public DeepSeekModelFactory deepSeekModelFactory() {
        return new DeepSeekModelFactory();
    }
}

