/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.httpclient;

import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.enums.HeaderUniqueStrategyEnum;
import org.apache.shenyu.common.enums.HttpRetryBackoffSpecEnum;
import org.apache.shenyu.common.enums.RetryEnum;
import org.apache.shenyu.common.enums.UniqueHeaderEnum;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.LogUtils;
import org.apache.shenyu.plugin.api.ShenyuPlugin;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.context.ShenyuContext;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.plugin.httpclient.CustomRetryStrategy;
import org.apache.shenyu.plugin.httpclient.DefaultRetryStrategy;
import org.apache.shenyu.plugin.httpclient.ExponentialRetryBackoffStrategy;
import org.apache.shenyu.plugin.httpclient.FixedRetryStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractHttpClientPlugin<R>
implements ShenyuPlugin {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractHttpClientPlugin.class);

    public final Mono<Void> execute(ServerWebExchange exchange, ShenyuPluginChain chain) {
        String retryStrategyType;
        ShenyuContext shenyuContext = (ShenyuContext)exchange.getAttribute("context");
        Objects.requireNonNull(shenyuContext);
        URI uri = (URI)exchange.getAttribute("httpUri");
        if (Objects.isNull(uri)) {
            Object error = ShenyuResultWrap.error((ServerWebExchange)exchange, (ShenyuResultEnum)ShenyuResultEnum.CANNOT_FIND_URL);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        long timeout = (Long)Optional.ofNullable(exchange.getAttribute("httpTimeOut")).orElse(3000L);
        Duration duration = Duration.ofMillis(timeout);
        int retryTimes = (Integer)Optional.ofNullable(exchange.getAttribute("httpRetry")).orElse(0);
        String retryStrategy = (String)Optional.ofNullable(exchange.getAttribute("retryStrategy")).orElseGet(() -> ((RetryEnum)RetryEnum.CURRENT).getName());
        LogUtils.debug((Logger)LOG, () -> String.format("The request urlPath is: %s, retryTimes is : %s, retryStrategy is : %s", uri, retryTimes, retryStrategy));
        Mono response = this.doRequest(exchange, exchange.getRequest().getMethod().name(), uri, (Flux<DataBuffer>)exchange.getRequest().getBody()).timeout(duration, Mono.error(() -> new TimeoutException("Response took longer than timeout: " + duration))).doOnError(e -> LOG.error(e.getMessage(), e));
        Mono retriedResponse = (switch (retryStrategyType = (String)Optional.ofNullable(exchange.getAttribute("default")).orElse(HttpRetryBackoffSpecEnum.getDefault())) {
            case "exponential" -> new ExponentialRetryBackoffStrategy(this);
            case "fixed" -> new FixedRetryStrategy(this);
            case "custom" -> new CustomRetryStrategy(this);
            default -> new DefaultRetryStrategy(this);
        }).execute(response, exchange, duration, retryTimes);
        return retriedResponse.onErrorMap(ShenyuException.class, th -> new ResponseStatusException((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE, ShenyuResultEnum.CANNOT_FIND_HEALTHY_UPSTREAM_URL_AFTER_FAILOVER.getMsg(), (Throwable)th)).onErrorMap(TimeoutException.class, th -> new ResponseStatusException((HttpStatusCode)HttpStatus.GATEWAY_TIMEOUT, th.getMessage(), (Throwable)th)).flatMap(o -> chain.execute(exchange));
    }

    protected abstract Mono<R> doRequest(ServerWebExchange var1, String var2, URI var3, Flux<DataBuffer> var4);

    protected void duplicateHeaders(ServerWebExchange exchange, HttpHeaders headers, UniqueHeaderEnum uniqueHeaderEnum) {
        String duplicateHeader = (String)exchange.getAttribute(uniqueHeaderEnum.getName());
        if (StringUtils.isEmpty((CharSequence)duplicateHeader)) {
            return;
        }
        List<String> duplicateHeaderList = Arrays.asList(StringUtils.split((String)duplicateHeader, (String)";"));
        if (CollectionUtils.isEmpty(duplicateHeaderList)) {
            return;
        }
        HeaderUniqueStrategyEnum strategy = (HeaderUniqueStrategyEnum)exchange.getAttributeOrDefault(uniqueHeaderEnum.getStrategy(), (Object)HeaderUniqueStrategyEnum.RETAIN_FIRST);
        for (String headerKey : duplicateHeaderList) {
            this.duplicate(headers, headerKey, strategy);
        }
    }

    protected void duplicate(HttpHeaders headers, String header, HeaderUniqueStrategyEnum strategy) {
        List headerValues = headers.get((Object)header);
        if (Objects.isNull(headerValues) || headerValues.size() <= 1) {
            return;
        }
        switch (strategy) {
            case RETAIN_FIRST: {
                headers.set(header, (String)headerValues.get(0));
                break;
            }
            case RETAIN_LAST: {
                headers.set(header, (String)headerValues.get(headerValues.size() - 1));
                break;
            }
            case RETAIN_UNIQUE: {
                headers.put(header, new ArrayList(new LinkedHashSet(headerValues)));
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + strategy);
            }
        }
    }
}

