/*
 * Decompiled with CFR 0.152.
 */
package io.fury.serializer;

import io.fury.Fury;
import io.fury.memory.MemoryBuffer;
import io.fury.serializer.BufferObject;
import io.fury.serializer.Serializers;
import io.fury.type.Type;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class BufferSerializers {

    public static final class ByteBufferSerializer
    extends Serializers.CrossLanguageCompatibleSerializer<ByteBuffer> {
        public ByteBufferSerializer(Fury fury, Class<ByteBuffer> cls) {
            super(fury, cls, Type.FURY_BUFFER.getId());
        }

        @Override
        public void write(MemoryBuffer buffer, ByteBuffer value) {
            this.fury.writeBufferObject(buffer, new BufferObject.ByteBufferBufferObject(value));
        }

        @Override
        public ByteBuffer read(MemoryBuffer buffer) {
            MemoryBuffer newBuffer = this.fury.readBufferObject(buffer);
            int readerIndex = newBuffer.readerIndex();
            int size = newBuffer.remaining();
            ByteBuffer originalBuffer = newBuffer.sliceAsByteBuffer(readerIndex, size - 1);
            byte isBigEndian = newBuffer.get(readerIndex + size - 1);
            originalBuffer.order(isBigEndian == 1 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
            return originalBuffer;
        }
    }
}

