/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.common.struct;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class TwoWayMap<K, V>
implements Map<K, V> {
    private ConcurrentMap<K, V> kvMap = new ConcurrentHashMap();
    private ConcurrentMap<V, K> vkMap = new ConcurrentHashMap<V, K>();
    private ReentrantLock lock = new ReentrantLock();

    @Override
    public int size() {
        return this.kvMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.kvMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.kvMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.vkMap.containsKey(value);
    }

    @Override
    public V get(Object key) {
        return this.kvMap.get(key);
    }

    public K getKey(Object value) {
        return (K)this.vkMap.get(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        this.lock.lock();
        try {
            this.kvMap.put(key, value);
            this.vkMap.put(value, key);
            V v = value;
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        this.lock.lock();
        try {
            Object value = this.kvMap.remove(key);
            this.vkMap.remove(value);
            Object v = value;
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.lock.tryLock();
        try {
            this.kvMap.clear();
            this.vkMap.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Set<K> keySet() {
        return this.kvMap.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.kvMap.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.kvMap.entrySet();
    }
}

