/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.transport;

import com.alipay.sofa.rpc.base.Destroyable;
import com.alipay.sofa.rpc.ext.ExtensionLoaderFactory;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.transport.ClientTransport;
import com.alipay.sofa.rpc.transport.ClientTransportConfig;
import com.alipay.sofa.rpc.transport.ClientTransportHolder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class NotReusableClientTransportHolder
implements ClientTransportHolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(NotReusableClientTransportHolder.class);
    private final ConcurrentMap<ClientTransportConfig, ClientTransport> allTransports = new ConcurrentHashMap<ClientTransportConfig, ClientTransport>();

    @Override
    public ClientTransport getClientTransport(ClientTransportConfig config) {
        ClientTransport old;
        ClientTransport transport = (ClientTransport)this.allTransports.get(config);
        if (transport == null && (old = this.allTransports.putIfAbsent(config, transport = ExtensionLoaderFactory.getExtensionLoader(ClientTransport.class).getExtension(config.getContainer(), new Class[]{ClientTransportConfig.class}, new Object[]{config}))) != null) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Multiple threads init ClientTransport with same ClientTransportConfig!");
            }
            transport.destroy();
            transport = old;
        }
        return transport;
    }

    @Override
    public boolean removeClientTransport(ClientTransport clientTransport) {
        if (clientTransport == null) {
            return false;
        }
        this.allTransports.remove(clientTransport.getConfig());
        return true;
    }

    @Override
    public int size() {
        return this.allTransports.size();
    }

    @Override
    public void destroy() {
        for (Map.Entry entrySet : this.allTransports.entrySet()) {
            ClientTransport clientTransport = (ClientTransport)entrySet.getValue();
            if (!clientTransport.isAvailable()) continue;
            clientTransport.destroy();
        }
        this.allTransports.clear();
    }

    @Override
    public void destroy(Destroyable.DestroyHook hook) {
        if (hook != null) {
            hook.preDestroy();
        }
        this.destroy();
        if (hook != null) {
            hook.postDestroy();
        }
    }
}

