/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.impl.standalone;

import java.util.Collections;
import java.util.Set;
import org.apache.sling.discovery.ClusterView;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.discovery.InstanceFilter;
import org.apache.sling.discovery.TopologyView;
import org.apache.sling.discovery.impl.standalone.ClusterViewImpl;

public class TopologyViewImpl
implements TopologyView {
    private volatile boolean current = true;
    private final InstanceDescription myInstance;

    public TopologyViewImpl(InstanceDescription myInstance) {
        this.myInstance = myInstance;
    }

    public InstanceDescription getLocalInstance() {
        return this.myInstance;
    }

    public boolean isCurrent() {
        return this.current;
    }

    public void invalidate() {
        this.current = false;
    }

    public Set<InstanceDescription> getInstances() {
        return Collections.singleton(this.myInstance);
    }

    public Set<InstanceDescription> findInstances(InstanceFilter picker) {
        if (picker.accept(this.myInstance)) {
            return this.getInstances();
        }
        return Collections.emptySet();
    }

    public Set<ClusterView> getClusterViews() {
        ClusterViewImpl clusterView = new ClusterViewImpl(this.myInstance);
        return Collections.singleton(clusterView);
    }
}

