/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.packaging.impl.importer;

import java.io.InputStream;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.packaging.DistributionPackage;
import org.apache.sling.distribution.packaging.DistributionPackageInfo;
import org.apache.sling.distribution.packaging.impl.DistributionPackageImporter;
import org.apache.sling.distribution.packaging.impl.importer.RepositoryDistributionPackageImporter;
import org.apache.sling.jcr.api.SlingRepository;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, service={DistributionPackageImporter.class}, property={"webconsole.configurationFactory.nameHint=Importer name: {name}"})
@Designate(ocd=Config.class, factory=true)
public class RepositoryDistributionPackageImporterFactory
implements DistributionPackageImporter {
    @Reference
    private SlingRepository repository;
    private RepositoryDistributionPackageImporter importer;

    @Activate
    protected void activate(Config conf) {
        this.importer = new RepositoryDistributionPackageImporter(this.repository, conf.service_name(), conf.path(), conf.privilege_name());
    }

    @Override
    public void importPackage(@NotNull ResourceResolver resourceResolver, @NotNull DistributionPackage distributionPackage) throws DistributionException {
        this.importer.importPackage(resourceResolver, distributionPackage);
    }

    @Override
    @NotNull
    public DistributionPackageInfo importStream(@NotNull ResourceResolver resourceResolver, @NotNull InputStream stream) throws DistributionException {
        return this.importer.importStream(resourceResolver, stream);
    }

    @ObjectClassDefinition(name="Apache Sling Distribution Importer - Repository Package Importer Factory")
    public static @interface Config {
        @AttributeDefinition(name="Name", description="The name of the importer.")
        public String name();

        @AttributeDefinition
        public String service_name() default "admin";

        @AttributeDefinition
        public String path() default "/var/sling/distribution/import";

        @AttributeDefinition
        public String privilege_name() default "jcr:read";
    }
}

