/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resource.filter;

import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.sling.api.resource.Resource;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class ResourceStream {
    protected Resource resource;

    public ResourceStream(Resource resource) {
        this.resource = resource;
    }

    public Stream<Resource> stream(final Predicate<Resource> branchSelector) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new Iterator<Resource>(){
            private final Deque<Iterator<Resource>> resources = new LinkedList<Iterator<Resource>>();
            private Resource current;
            {
                this.current = ResourceStream.this.resource;
                this.resources.push(ResourceStream.this.resource.getChildren().iterator());
            }

            @Override
            public boolean hasNext() {
                if (this.current == null) {
                    return this.seek();
                }
                return true;
            }

            @Override
            public Resource next() {
                if (this.current == null) {
                    this.seek();
                }
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                Resource next = this.current;
                this.current = null;
                return next;
            }

            private boolean seek() {
                while (!this.resources.isEmpty()) {
                    Iterator<Resource> iterator = this.resources.peek();
                    if (iterator.hasNext()) {
                        this.current = iterator.next();
                        if (branchSelector.test(this.current)) {
                            this.resources.push(this.current.getChildren().iterator());
                        }
                        return true;
                    }
                    this.resources.pop();
                }
                return false;
            }
        }, 1040), false);
    }

    public Stream<Resource> listChildren(Predicate<Resource> childSelector) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.resource.listChildren(), 1040), false).filter(childSelector);
    }
}

