/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkException;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.classification.BinaryLogisticRegressionSummaryImpl;
import org.apache.spark.ml.classification.BinaryLogisticRegressionTrainingSummary;
import org.apache.spark.ml.classification.LogisticRegressionModel$;
import org.apache.spark.ml.classification.LogisticRegressionModel$LogisticRegressionModelWriter$;
import org.apache.spark.ml.classification.LogisticRegressionModel$LogisticRegressionModelWriter$Data$;
import org.apache.spark.ml.classification.LogisticRegressionParams;
import org.apache.spark.ml.classification.LogisticRegressionSummary;
import org.apache.spark.ml.classification.LogisticRegressionSummaryImpl;
import org.apache.spark.ml.classification.LogisticRegressionTrainingSummary;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel;
import org.apache.spark.ml.classification.ProbabilisticClassifierParams;
import org.apache.spark.ml.impl.Utils$;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.SparseMatrix;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasAggregationDepth;
import org.apache.spark.ml.param.shared.HasElasticNetParam;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasMaxBlockSizeInMB;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasRegParam;
import org.apache.spark.ml.param.shared.HasStandardization;
import org.apache.spark.ml.param.shared.HasThreshold;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.HasTrainingSummary;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.VersionUtils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0011}a\u0001B0a\u0001-D!\"!\u0004\u0001\u0005\u000b\u0007I\u0011IA\b\u0011)\ti\u0004\u0001B\u0001B\u0003%\u0011\u0011\u0003\u0005\u000b\u0003\u0003\u0002!Q1A\u0005\u0002\u0005\r\u0003BCA)\u0001\t\u0005\t\u0015!\u0003\u0002F!Q\u0011Q\u000b\u0001\u0003\u0006\u0004%\t!a\u0016\t\u0013\u0005m\u0003A!A!\u0002\u0013\u0001\bBCA0\u0001\t\u0015\r\u0011\"\u0011\u0002b!Q\u0011\u0011\u000f\u0001\u0003\u0002\u0003\u0006I!a\u0019\t\u0015\u0005U\u0004A!b\u0001\n\u0013\t9\b\u0003\u0006\u0002\u0000\u0001\u0011\t\u0011)A\u0005\u0003sB\u0001\"!!\u0001\t\u0003!\u00171\u0011\u0005\t\u0003\u0003\u0003A\u0011\u00013\u0002\u0018\"9\u0011Q\u0014\u0001\u0005\u0002\u0005]\u0003BCAX\u0001!\u0015\r\u0011\"\u0003\u0002X!9\u0011\u0011\u0015\u0001\u0005\u0002\u0005E\u0006\"CA[\u0001\t\u0007I\u0011BA\\\u0011!\ty\f\u0001Q\u0001\n\u0005e\u0006\"CAa\u0001\t\u0007I\u0011BAY\u0011!\t\u0019\r\u0001Q\u0001\n\u0005\r\u0006\"CAc\u0001\u0001\u0007I\u0011BAd\u0011%\ty\r\u0001a\u0001\n\u0013\t\t\u000e\u0003\u0005\u0002^\u0002\u0001\u000b\u0015BAe\u0011!\ty\u000e\u0001C!E\u0006\u0005\bb\u0002B\u0005\u0001\u0011\u0005#1\u0002\u0005\b\u00053\u0001A\u0011IAY\u0011\u001d\u0011i\u0002\u0001C!\u0005?AqA!\n\u0001\t\u0003\n9\rC\u0005\u0003*\u0001\u0011\r\u0011\"\u0003\u0003,!A!1\u0007\u0001!\u0002\u0013\u0011i\u0003C\u0005\u00036\u0001\u0011\r\u0011\"\u0003\u00038!A!1\b\u0001!\u0002\u0013\u0011I\u0004C\u0005\u0003>\u0001\u0011\r\u0011\"\u0003\u0003,!A!q\b\u0001!\u0002\u0013\u0011i\u0003C\u0005\u0003B\u0001\u0011\r\u0011\"\u0011\u0002b!A!\u0011\n\u0001!\u0002\u0013\t\u0019\u0007C\u0004\u0003N\u0001!\tEa\u0014\t\u000f\tM\u0003\u0001\"\u0001\u0003V!9!1\r\u0001\u0005\u0002\t\u0015\u0004b\u0002BD\u0001\u0011\u0005#\u0011\u0012\u0005\b\u0005\u001f\u0003A\u0011\u000bBI\u0011\u001d\u00119\n\u0001C!\u00053CqAa)\u0001\t\u0003\u0012)\u000bC\u0004\u00034\u0002!\tF!.\t\u000f\te\u0006\u0001\"\u0015\u0003<\"9!\u0011\u0019\u0001\u0005B\t\r\u0007b\u0002Bg\u0001\u0011\u0005#qZ\u0004\b\u0005'\u0004\u0007\u0012\u0001Bk\r\u0019y\u0006\r#\u0001\u0003X\"9\u0011\u0011\u0011\u0019\u0005\u0002\tU\bb\u0002B|a\u0011\u0005#\u0011 \u0005\b\u0007\u0007\u0001D\u0011IB\u0003\r\u001d\u0019i\u0001\r\u00011\u0007\u001fA\u0011b!\b5\u0005\u0003\u0005\u000b\u0011\u0002<\t\u000f\u0005\u0005E\u0007\"\u0001\u0004 \u001911q\u0005\u001bE\u0007SA!\"a\u00188\u0005+\u0007I\u0011AA1\u0011)\t\th\u000eB\tB\u0003%\u00111\r\u0005\u000b\u0005\u0003:$Q3A\u0005\u0002\u0005\u0005\u0004B\u0003B%o\tE\t\u0015!\u0003\u0002d!Q\u0011QK\u001c\u0003\u0016\u0004%\t!a\u0016\t\u0013\u0005msG!E!\u0002\u0013\u0001\bBCA!o\tU\r\u0011\"\u0001\u0002D!Q\u0011\u0011K\u001c\u0003\u0012\u0003\u0006I!!\u0012\t\u0015\u0005UtG!f\u0001\n\u0003\t9\b\u0003\u0006\u0002\u0000]\u0012\t\u0012)A\u0005\u0003sBq!!!8\t\u0003\u0019\t\u0005C\u0005\u0003$^\n\t\u0011\"\u0001\u0004R!I1QL\u001c\u0012\u0002\u0013\u00051q\f\u0005\n\u0007g:\u0014\u0013!C\u0001\u0007?B\u0011b!\u001e8#\u0003%\taa\u001e\t\u0013\rmt'%A\u0005\u0002\ru\u0004\"CBAoE\u0005I\u0011ABB\u0011%\u00199iNA\u0001\n\u0003\u001aI\tC\u0005\u0004\u0016^\n\t\u0011\"\u0001\u0002b!I1qS\u001c\u0002\u0002\u0013\u00051\u0011\u0014\u0005\n\u0007;;\u0014\u0011!C!\u0007?C\u0011b!,8\u0003\u0003%\taa,\t\u0013\rMv'!A\u0005B\rU\u0006\"CB]o\u0005\u0005I\u0011IB^\u0011%\u0011imNA\u0001\n\u0003\u001ai\fC\u0005\u0004@^\n\t\u0011\"\u0011\u0004B\u001eI1Q\u0019\u001b\u0002\u0002#%1q\u0019\u0004\n\u0007O!\u0014\u0011!E\u0005\u0007\u0013Dq!!!T\t\u0003\u00199\u000eC\u0005\u0003NN\u000b\t\u0011\"\u0012\u0004>\"I1\u0011\\*\u0002\u0002\u0013\u000551\u001c\u0005\n\u0007O\u001c\u0016\u0011!CA\u0007SDqaa?5\t#\u001aiP\u0002\u0004\u0005\u0002A\"A1\u0001\u0005\b\u0003\u0003KF\u0011\u0001C\u0003\u0011%!I!\u0017b\u0001\n\u0013\u0019I\t\u0003\u0005\u0005\fe\u0003\u000b\u0011BBF\u0011\u001d\u0019\u0019!\u0017C!\t\u001bA\u0011\u0002\"\u00051\u0003\u0003%I\u0001b\u0005\u0003/1{w-[:uS\u000e\u0014Vm\u001a:fgNLwN\\'pI\u0016d'BA1c\u00039\u0019G.Y:tS\u001aL7-\u0019;j_:T!a\u00193\u0002\u00055d'BA3g\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0007.\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002S\u0006\u0019qN]4\u0004\u0001M1\u0001\u0001\\<~\u0003\u0003\u0001B!\u001c8qm6\t\u0001-\u0003\u0002pA\n\u0001\u0003K]8cC\nLG.[:uS\u000e\u001cE.Y:tS\u001aL7-\u0019;j_:lu\u000eZ3m!\t\tH/D\u0001s\u0015\t\u0019(-\u0001\u0004mS:\fGnZ\u0005\u0003kJ\u0014aAV3di>\u0014\bCA7\u0001!\tA80D\u0001z\u0015\tQ(-\u0001\u0003vi&d\u0017B\u0001?z\u0005)iEj\u0016:ji\u0006\u0014G.\u001a\t\u0003[zL!a 1\u000311{w-[:uS\u000e\u0014Vm\u001a:fgNLwN\u001c)be\u0006l7\u000fE\u0003y\u0003\u0007\t9!C\u0002\u0002\u0006e\u0014!\u0003S1t)J\f\u0017N\\5oON+X.\\1ssB\u0019Q.!\u0003\n\u0007\u0005-\u0001MA\u0011M_\u001eL7\u000f^5d%\u0016<'/Z:tS>tGK]1j]&twmU;n[\u0006\u0014\u00180A\u0002vS\u0012,\"!!\u0005\u0011\t\u0005M\u0011Q\u0005\b\u0005\u0003+\t\t\u0003\u0005\u0003\u0002\u0018\u0005uQBAA\r\u0015\r\tYB[\u0001\u0007yI|w\u000e\u001e \u000b\u0005\u0005}\u0011!B:dC2\f\u0017\u0002BA\u0012\u0003;\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u0014\u0003S\u0011aa\u0015;sS:<'\u0002BA\u0012\u0003;AS!AA\u0017\u0003s\u0001B!a\f\u000265\u0011\u0011\u0011\u0007\u0006\u0004\u0003g!\u0017AC1o]>$\u0018\r^5p]&!\u0011qGA\u0019\u0005\u0015\u0019\u0016N\\2fC\t\tY$A\u00032]Qr\u0003'\u0001\u0003vS\u0012\u0004\u0003&\u0002\u0002\u0002.\u0005e\u0012!E2pK\u001a4\u0017nY5f]Rl\u0015\r\u001e:jqV\u0011\u0011Q\t\t\u0004c\u0006\u001d\u0013bAA%e\n1Q*\u0019;sSbDSaAA\u0017\u0003\u001b\n#!a\u0014\u0002\u000bIr\u0013G\f\u0019\u0002%\r|WM\u001a4jG&,g\u000e^'biJL\u0007\u0010\t\u0015\u0006\t\u00055\u0012QJ\u0001\u0010S:$XM]2faR4Vm\u0019;peV\t\u0001\u000fK\u0003\u0006\u0003[\ti%\u0001\tj]R,'oY3qiZ+7\r^8sA!*a!!\f\u0002N\u0005Qa.^7DY\u0006\u001c8/Z:\u0016\u0005\u0005\r\u0004\u0003BA3\u0003Oj!!!\b\n\t\u0005%\u0014Q\u0004\u0002\u0004\u0013:$\b&B\u0004\u0002.\u00055\u0014EAA8\u0003\u0015\tdf\r\u00181\u0003-qW/\\\"mCN\u001cXm\u001d\u0011)\u000b!\ti#!\u001c\u0002\u001b%\u001cX*\u001e7uS:|W.[1m+\t\tI\b\u0005\u0003\u0002f\u0005m\u0014\u0002BA?\u0003;\u0011qAQ8pY\u0016\fg.\u0001\bjg6+H\u000e^5o_6L\u0017\r\u001c\u0011\u0002\rqJg.\u001b;?)-1\u0018QQAE\u0003\u001b\u000b\t*!&\t\u000f\u000551\u00021\u0001\u0002\u0012!2\u0011QQA\u0017\u0003sAq!!\u0011\f\u0001\u0004\t)\u0005\u000b\u0004\u0002\n\u00065\u0012Q\n\u0005\u0007\u0003+Z\u0001\u0019\u00019)\r\u00055\u0015QFA'\u0011\u001d\tyf\u0003a\u0001\u0003GBc!!%\u0002.\u00055\u0004bBA;\u0017\u0001\u0007\u0011\u0011\u0010\u000b\bm\u0006e\u00151TAP\u0011\u001d\ti\u0001\u0004a\u0001\u0003#Aa!!(\r\u0001\u0004\u0001\u0018\u0001D2pK\u001a4\u0017nY5f]R\u001c\bbBAQ\u0019\u0001\u0007\u00111U\u0001\nS:$XM]2faR\u0004B!!\u001a\u0002&&!\u0011qUA\u000f\u0005\u0019!u.\u001e2mK\"*Q\"!\f\u0002,\u0006\u0012\u0011QV\u0001\u0006e9\u0002d\u0006M\u0001\u000e?\u000e|WM\u001a4jG&,g\u000e^:\u0016\u0005\u0005\r\u0006&B\b\u0002.\u00055\u0014\u0001E0j]R,'oY3qiZ+7\r^8s+\t\tI\fE\u0002r\u0003wK1!!0s\u0005-!UM\\:f-\u0016\u001cGo\u001c:\u0002#}Kg\u000e^3sG\u0016\u0004HOV3di>\u0014\b%\u0001\u0006`S:$XM]2faR\f1bX5oi\u0016\u00148-\u001a9uA\u0005\trLY5oCJLH\u000b\u001b:fg\"|G\u000eZ:\u0016\u0005\u0005%\u0007CBA3\u0003\u0017\f\u0019+\u0003\u0003\u0002N\u0006u!!B!se\u0006L\u0018!F0cS:\f'/\u001f+ie\u0016\u001c\bn\u001c7eg~#S-\u001d\u000b\u0005\u0003'\fI\u000e\u0005\u0003\u0002f\u0005U\u0017\u0002BAl\u0003;\u0011A!\u00168ji\"I\u00111\\\u000b\u0002\u0002\u0003\u0007\u0011\u0011Z\u0001\u0004q\u0012\n\u0014AE0cS:\f'/\u001f+ie\u0016\u001c\bn\u001c7eg\u0002\nQb\u001c8QCJ\fWn\u00115b]\u001e,G\u0003BAj\u0003GDq!!:\u0018\u0001\u0004\t9/A\u0003qCJ\fW\u000e\r\u0003\u0002j\u0006]\bCBAv\u0003_\f\u00190\u0004\u0002\u0002n*\u0019\u0011Q\u001d2\n\t\u0005E\u0018Q\u001e\u0002\u0006!\u0006\u0014\u0018-\u001c\t\u0005\u0003k\f9\u0010\u0004\u0001\u0005\u0019\u0005e\u00181]A\u0001\u0002\u0003\u0015\t!a?\u0003\u0007}#3'\u0005\u0003\u0002~\n\r\u0001\u0003BA3\u0003\u007fLAA!\u0001\u0002\u001e\t9aj\u001c;iS:<\u0007\u0003BA3\u0005\u000bIAAa\u0002\u0002\u001e\t\u0019\u0011I\\=\u0002\u0019M,G\u000f\u00165sKNDw\u000e\u001c3\u0015\t\t5!qB\u0007\u0002\u0001!9!\u0011\u0003\rA\u0002\u0005\r\u0016!\u0002<bYV,\u0007&\u0002\r\u0002.\tU\u0011E\u0001B\f\u0003\u0015\td&\u000e\u00181\u000319W\r\u001e+ie\u0016\u001c\bn\u001c7eQ\u0015I\u0012Q\u0006B\u000b\u00035\u0019X\r\u001e+ie\u0016\u001c\bn\u001c7egR!!Q\u0002B\u0011\u0011\u001d\u0011\tB\u0007a\u0001\u0003\u0013DSAGA\u0017\u0005+\tQbZ3u)\"\u0014Xm\u001d5pY\u0012\u001c\b&B\u000e\u0002.\tU\u0011AB7be\u001eLg.\u0006\u0002\u0003.A9\u0011Q\rB\u0018a\u0006\r\u0016\u0002\u0002B\u0019\u0003;\u0011\u0011BR;oGRLwN\\\u0019\u0002\u000f5\f'oZ5oA\u00059Q.\u0019:hS:\u001cXC\u0001B\u001d!\u0019\t)Ga\fqa\u0006AQ.\u0019:hS:\u001c\b%A\u0003tG>\u0014X-\u0001\u0004tG>\u0014X\rI\u0001\f]Vlg)Z1ukJ,7\u000fK\u0003#\u0003[\u0011)%\t\u0002\u0003H\u0005)\u0011G\f\u001c/a\u0005aa.^7GK\u0006$XO]3tA!*1%!\f\u0003F\u000591/^7nCJLXCAA\u0004Q\u0015!\u0013Q\u0006B\u000b\u00035\u0011\u0017N\\1ssN+X.\\1ssV\u0011!q\u000b\t\u0004[\ne\u0013b\u0001B.A\n9#)\u001b8befdunZ5ti&\u001c'+Z4sKN\u001c\u0018n\u001c8Ue\u0006Lg.\u001b8h'VlW.\u0019:zQ\u0015)\u0013Q\u0006B0C\t\u0011\t'A\u00033]Mr\u0003'\u0001\u0005fm\u0006dW/\u0019;f)\u0011\u00119G!\u001c\u0011\u00075\u0014I'C\u0002\u0003l\u0001\u0014\u0011\u0004T8hSN$\u0018n\u0019*fOJ,7o]5p]N+X.\\1ss\"9!q\u000e\u0014A\u0002\tE\u0014a\u00023bi\u0006\u001cX\r\u001e\u0019\u0005\u0005g\u0012\t\t\u0005\u0004\u0003v\tm$qP\u0007\u0003\u0005oR1A!\u001fe\u0003\r\u0019\u0018\u000f\\\u0005\u0005\u0005{\u00129HA\u0004ECR\f7/\u001a;\u0011\t\u0005U(\u0011\u0011\u0003\r\u0005\u0007\u0013i'!A\u0001\u0002\u000b\u0005\u00111 \u0002\u0004?\u0012\"\u0004&\u0002\u0014\u0002.\u0005-\u0016a\u00029sK\u0012L7\r\u001e\u000b\u0005\u0003G\u0013Y\t\u0003\u0004\u0003\u000e\u001e\u0002\r\u0001]\u0001\tM\u0016\fG/\u001e:fg\u00061\"/Y<3aJ|'-\u00192jY&$\u00180\u00138QY\u0006\u001cW\rF\u0002q\u0005'CaA!&)\u0001\u0004\u0001\u0018!\u0004:boB\u0013X\rZ5di&|g.\u0001\u0006qe\u0016$\u0017n\u0019;SC^$2\u0001\u001dBN\u0011\u0019\u0011i)\u000ba\u0001a\"*\u0011&!\f\u0003 \u0006\u0012!\u0011U\u0001\u0006g9\u0002d\u0006M\u0001\u0005G>\u0004\u0018\u0010F\u0002w\u0005OCqA!++\u0001\u0004\u0011Y+A\u0003fqR\u0014\u0018\r\u0005\u0003\u0002l\n5\u0016\u0002\u0002BX\u0003[\u0014\u0001\u0002U1sC6l\u0015\r\u001d\u0015\u0006U\u00055\u0012\u0011H\u0001\u000fe\u0006<(\u0007\u001d:fI&\u001cG/[8o)\u0011\t\u0019Ka.\t\r\tU5\u00061\u0001q\u0003Y\u0001(o\u001c2bE&d\u0017\u000e^=3aJ,G-[2uS>tG\u0003BAR\u0005{CaAa0-\u0001\u0004\u0001\u0018a\u00039s_\n\f'-\u001b7jif\fQa\u001e:ji\u0016,\"A!2\u0011\u0007a\u00149-C\u0002\u0003Jf\u0014\u0001\"\u0014'Xe&$XM\u001d\u0015\u0006[\u00055\"QI\u0001\ti>\u001cFO]5oOR\u0011\u0011\u0011\u0003\u0015\u0006\u0001\u00055\u0012\u0011H\u0001\u0018\u0019><\u0017n\u001d;jGJ+wM]3tg&|g.T8eK2\u0004\"!\u001c\u0019\u0014\u000fA\u0012INa8\u0003fB!\u0011Q\rBn\u0013\u0011\u0011i.!\b\u0003\r\u0005s\u0017PU3g!\u0011A(\u0011\u001d<\n\u0007\t\r\u0018P\u0001\u0006N\u0019J+\u0017\rZ1cY\u0016\u0004BAa:\u0003r6\u0011!\u0011\u001e\u0006\u0005\u0005W\u0014i/\u0001\u0002j_*\u0011!q^\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003t\n%(\u0001D*fe&\fG.\u001b>bE2,GC\u0001Bk\u0003\u0011\u0011X-\u00193\u0016\u0005\tm\b\u0003\u0002=\u0003~ZL1Aa@z\u0005!iEJU3bI\u0016\u0014\b&\u0002\u001a\u0002.\t\u0015\u0013\u0001\u00027pC\u0012$2A^B\u0004\u0011\u001d\u0019Ia\ra\u0001\u0003#\tA\u0001]1uQ\"*1'!\f\u0003F\tiBj\\4jgRL7MU3he\u0016\u001c8/[8o\u001b>$W\r\\,sSR,'oE\u00035\u0005\u000b\u001c\t\u0002\u0005\u0003\u0004\u0014\reQBAB\u000b\u0015\r\u00199\u0002Z\u0001\tS:$XM\u001d8bY&!11DB\u000b\u0005\u001daunZ4j]\u001e\f\u0001\"\u001b8ti\u0006t7-\u001a\u000b\u0005\u0007C\u0019)\u0003E\u0002\u0004$Qj\u0011\u0001\r\u0005\u0007\u0007;1\u0004\u0019\u0001<\u0003\t\u0011\u000bG/Y\n\bo\te71FB\u0019!\u0011\t)g!\f\n\t\r=\u0012Q\u0004\u0002\b!J|G-^2u!\u0011\u0019\u0019d!\u0010\u000f\t\rU2\u0011\b\b\u0005\u0003/\u00199$\u0003\u0002\u0002 %!11HA\u000f\u0003\u001d\u0001\u0018mY6bO\u0016LAAa=\u0004@)!11HA\u000f)1\u0019\u0019ea\u0012\u0004J\r-3QJB(!\r\u0019)eN\u0007\u0002i!9\u0011q\f\"A\u0002\u0005\r\u0004b\u0002B!\u0005\u0002\u0007\u00111\r\u0005\u0007\u0003+\u0012\u0005\u0019\u00019\t\u000f\u0005\u0005#\t1\u0001\u0002F!9\u0011Q\u000f\"A\u0002\u0005eD\u0003DB\"\u0007'\u001a)fa\u0016\u0004Z\rm\u0003\"CA0\u0007B\u0005\t\u0019AA2\u0011%\u0011\te\u0011I\u0001\u0002\u0004\t\u0019\u0007\u0003\u0005\u0002V\r\u0003\n\u00111\u0001q\u0011%\t\te\u0011I\u0001\u0002\u0004\t)\u0005C\u0005\u0002v\r\u0003\n\u00111\u0001\u0002z\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAB1U\u0011\t\u0019ga\u0019,\u0005\r\u0015\u0004\u0003BB4\u0007_j!a!\u001b\u000b\t\r-4QN\u0001\nk:\u001c\u0007.Z2lK\u0012TA!a\r\u0002\u001e%!1\u0011OB5\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"a!\u001f+\u0007A\u001c\u0019'\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\r}$\u0006BA#\u0007G\nabY8qs\u0012\"WMZ1vYR$S'\u0006\u0002\u0004\u0006*\"\u0011\u0011PB2\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u001111\u0012\t\u0005\u0007\u001b\u001b\u0019*\u0004\u0002\u0004\u0010*!1\u0011\u0013Bw\u0003\u0011a\u0017M\\4\n\t\u0005\u001d2qR\u0001\raJ|G-^2u\u0003JLG/_\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0011\u0019aa'\t\u0013\u0005m7*!AA\u0002\u0005\r\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\r\u0005\u0006CBBR\u0007S\u0013\u0019!\u0004\u0002\u0004&*!1qUA\u000f\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0007W\u001b)K\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA=\u0007cC\u0011\"a7N\u0003\u0003\u0005\rAa\u0001\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0007\u0017\u001b9\fC\u0005\u0002\\:\u000b\t\u00111\u0001\u0002d\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002dQ\u001111R\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005e41\u0019\u0005\n\u00037\f\u0016\u0011!a\u0001\u0005\u0007\tA\u0001R1uCB\u00191QI*\u0014\u000bM\u001bYM!:\u0011\u001f\r571[A2\u0003G\u0002\u0018QIA=\u0007\u0007j!aa4\u000b\t\rE\u0017QD\u0001\beVtG/[7f\u0013\u0011\u0019)na4\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>tW\u0007\u0006\u0002\u0004H\u0006)\u0011\r\u001d9msRa11IBo\u0007?\u001c\toa9\u0004f\"9\u0011q\f,A\u0002\u0005\r\u0004b\u0002B!-\u0002\u0007\u00111\r\u0005\u0007\u0003+2\u0006\u0019\u00019\t\u000f\u0005\u0005c\u000b1\u0001\u0002F!9\u0011Q\u000f,A\u0002\u0005e\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0007W\u001c9\u0010\u0005\u0004\u0002f\r58\u0011_\u0005\u0005\u0007_\fiB\u0001\u0004PaRLwN\u001c\t\u000e\u0003K\u001a\u00190a\u0019\u0002dA\f)%!\u001f\n\t\rU\u0018Q\u0004\u0002\u0007)V\u0004H.Z\u001b\t\u0013\rex+!AA\u0002\r\r\u0013a\u0001=%a\u0005A1/\u0019<f\u00136\u0004H\u000e\u0006\u0003\u0002T\u000e}\bbBB\u00051\u0002\u0007\u0011\u0011\u0003\u0002\u001e\u0019><\u0017n\u001d;jGJ+wM]3tg&|g.T8eK2\u0014V-\u00193feN\u0019\u0011La?\u0015\u0005\u0011\u001d\u0001cAB\u00123\u0006I1\r\\1tg:\u000bW.Z\u0001\u000bG2\f7o\u001d(b[\u0016\u0004Cc\u0001<\u0005\u0010!91\u0011B/A\u0002\u0005E\u0011\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001C\u000b!\u0011\u0019i\tb\u0006\n\t\u0011e1q\u0012\u0002\u0007\u001f\nTWm\u0019;)\u000bA\niC!\u0012)\u000b=\niC!\u0012")
public class LogisticRegressionModel
extends ProbabilisticClassificationModel<Vector, LogisticRegressionModel>
implements MLWritable,
LogisticRegressionParams,
HasTrainingSummary<LogisticRegressionTrainingSummary> {
    private Vector _coefficients;
    private final String uid;
    private final Matrix coefficientMatrix;
    private final Vector interceptVector;
    private final int numClasses;
    private final boolean org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial;
    private final DenseVector _interceptVector;
    private final double _intercept;
    private double[] _binaryThresholds;
    private final Function1<Vector, Object> margin;
    private final Function1<Vector, Vector> margins;
    private final Function1<Vector, Object> score;
    private final int numFeatures;
    private Option<LogisticRegressionTrainingSummary> trainingSummary;
    private Param<String> family;
    private Param<Matrix> lowerBoundsOnCoefficients;
    private Param<Matrix> upperBoundsOnCoefficients;
    private Param<Vector> lowerBoundsOnIntercepts;
    private Param<Vector> upperBoundsOnIntercepts;
    private DoubleParam maxBlockSizeInMB;
    private IntParam aggregationDepth;
    private DoubleParam threshold;
    private Param<String> weightCol;
    private BooleanParam standardization;
    private DoubleParam tol;
    private BooleanParam fitIntercept;
    private IntParam maxIter;
    private DoubleParam elasticNetParam;
    private DoubleParam regParam;
    private volatile boolean bitmap$0;

    public static LogisticRegressionModel load(String path) {
        return LogisticRegressionModel$.MODULE$.load(path);
    }

    public static MLReader<LogisticRegressionModel> read() {
        return LogisticRegressionModel$.MODULE$.read();
    }

    @Override
    public boolean hasSummary() {
        return HasTrainingSummary.hasSummary$(this);
    }

    @Override
    public HasTrainingSummary<LogisticRegressionTrainingSummary> setSummary(Option<LogisticRegressionTrainingSummary> summary) {
        return HasTrainingSummary.setSummary$(this, summary);
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$classification$LogisticRegressionParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return ProbabilisticClassifierParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public String getFamily() {
        return LogisticRegressionParams.getFamily$(this);
    }

    @Override
    public void checkThresholdConsistency() {
        LogisticRegressionParams.checkThresholdConsistency$(this);
    }

    @Override
    public Matrix getLowerBoundsOnCoefficients() {
        return LogisticRegressionParams.getLowerBoundsOnCoefficients$(this);
    }

    @Override
    public Matrix getUpperBoundsOnCoefficients() {
        return LogisticRegressionParams.getUpperBoundsOnCoefficients$(this);
    }

    @Override
    public Vector getLowerBoundsOnIntercepts() {
        return LogisticRegressionParams.getLowerBoundsOnIntercepts$(this);
    }

    @Override
    public Vector getUpperBoundsOnIntercepts() {
        return LogisticRegressionParams.getUpperBoundsOnIntercepts$(this);
    }

    @Override
    public boolean usingBoundConstrainedOptimization() {
        return LogisticRegressionParams.usingBoundConstrainedOptimization$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return LogisticRegressionParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public final double getMaxBlockSizeInMB() {
        return HasMaxBlockSizeInMB.getMaxBlockSizeInMB$(this);
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth.getAggregationDepth$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final boolean getStandardization() {
        return HasStandardization.getStandardization$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept.getFitIntercept$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final double getElasticNetParam() {
        return HasElasticNetParam.getElasticNetParam$(this);
    }

    @Override
    public final double getRegParam() {
        return HasRegParam.getRegParam$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public final Option<LogisticRegressionTrainingSummary> trainingSummary() {
        return this.trainingSummary;
    }

    @Override
    public final void trainingSummary_$eq(Option<LogisticRegressionTrainingSummary> x$1) {
        this.trainingSummary = x$1;
    }

    @Override
    public final Param<String> family() {
        return this.family;
    }

    @Override
    public Param<Matrix> lowerBoundsOnCoefficients() {
        return this.lowerBoundsOnCoefficients;
    }

    @Override
    public Param<Matrix> upperBoundsOnCoefficients() {
        return this.upperBoundsOnCoefficients;
    }

    @Override
    public Param<Vector> lowerBoundsOnIntercepts() {
        return this.lowerBoundsOnIntercepts;
    }

    @Override
    public Param<Vector> upperBoundsOnIntercepts() {
        return this.upperBoundsOnIntercepts;
    }

    @Override
    public final void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$family_$eq(Param<String> x$1) {
        this.family = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$lowerBoundsOnCoefficients_$eq(Param<Matrix> x$1) {
        this.lowerBoundsOnCoefficients = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$upperBoundsOnCoefficients_$eq(Param<Matrix> x$1) {
        this.upperBoundsOnCoefficients = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$lowerBoundsOnIntercepts_$eq(Param<Vector> x$1) {
        this.lowerBoundsOnIntercepts = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$upperBoundsOnIntercepts_$eq(Param<Vector> x$1) {
        this.upperBoundsOnIntercepts = x$1;
    }

    @Override
    public final DoubleParam maxBlockSizeInMB() {
        return this.maxBlockSizeInMB;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxBlockSizeInMB$_setter_$maxBlockSizeInMB_$eq(DoubleParam x$1) {
        this.maxBlockSizeInMB = x$1;
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public DoubleParam threshold() {
        return this.threshold;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasThreshold$_setter_$threshold_$eq(DoubleParam x$1) {
        this.threshold = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final BooleanParam standardization() {
        return this.standardization;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStandardization$_setter_$standardization_$eq(BooleanParam x$1) {
        this.standardization = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final DoubleParam elasticNetParam() {
        return this.elasticNetParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasElasticNetParam$_setter_$elasticNetParam_$eq(DoubleParam x$1) {
        this.elasticNetParam = x$1;
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Matrix coefficientMatrix() {
        return this.coefficientMatrix;
    }

    public Vector interceptVector() {
        return this.interceptVector;
    }

    @Override
    public int numClasses() {
        return this.numClasses;
    }

    public boolean org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial() {
        return this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial;
    }

    public Vector coefficients() {
        if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) {
            throw new SparkException("Multinomial models contain a matrix of coefficients, use coefficientMatrix instead.");
        }
        return this._coefficients();
    }

    private Vector _coefficients$lzycompute() {
        LogisticRegressionModel logisticRegressionModel = this;
        synchronized (logisticRegressionModel) {
            if (!this.bitmap$0) {
                Vector vector;
                Predef$.MODULE$.require(this.coefficientMatrix().isTransposed(), (Function0 & Serializable)() -> "LogisticRegressionModel coefficients should be row major for binomial model.");
                Matrix matrix = this.coefficientMatrix();
                if (matrix instanceof DenseMatrix) {
                    DenseMatrix denseMatrix = (DenseMatrix)matrix;
                    vector = Vectors$.MODULE$.dense(denseMatrix.values());
                } else if (matrix instanceof SparseMatrix) {
                    SparseMatrix sparseMatrix = (SparseMatrix)matrix;
                    vector = Vectors$.MODULE$.sparse(this.coefficientMatrix().numCols(), sparseMatrix.rowIndices(), sparseMatrix.values());
                } else {
                    throw new MatchError((Object)matrix);
                }
                this._coefficients = vector;
                this.bitmap$0 = true;
            }
        }
        return this._coefficients;
    }

    private Vector _coefficients() {
        return !this.bitmap$0 ? this._coefficients$lzycompute() : this._coefficients;
    }

    public double intercept() {
        if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) {
            throw new SparkException("Multinomial models contain a vector of intercepts, use interceptVector instead.");
        }
        return this._intercept();
    }

    private DenseVector _interceptVector() {
        return this._interceptVector;
    }

    private double _intercept() {
        return this._intercept;
    }

    private double[] _binaryThresholds() {
        return this._binaryThresholds;
    }

    private void _binaryThresholds_$eq(double[] x$1) {
        this._binaryThresholds = x$1;
    }

    @Override
    public void onParamChange(Param<?> param) {
        block6: {
            block7: {
                if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) break block6;
                String string = param.name();
                String string2 = "threshold";
                if (!(string == null ? string2 != null : !string.equals(string2))) break block7;
                String string3 = param.name();
                String string4 = "thresholds";
                if (string3 != null ? !string3.equals(string4) : string4 != null) break block6;
            }
            if (this.isDefined(this.threshold()) || this.isDefined(this.thresholds())) {
                double _threshold = this.getThreshold();
                if (_threshold == 0.0) {
                    this._binaryThresholds_$eq(new double[]{_threshold, Double.NEGATIVE_INFINITY});
                } else if (_threshold == 1.0) {
                    this._binaryThresholds_$eq(new double[]{_threshold, Double.POSITIVE_INFINITY});
                } else {
                    this._binaryThresholds_$eq(new double[]{_threshold, scala.math.package$.MODULE$.log(_threshold / (1.0 - _threshold))});
                }
            } else {
                this._binaryThresholds_$eq(null);
            }
        }
    }

    @Override
    public LogisticRegressionModel setThreshold(double value) {
        return (LogisticRegressionModel)LogisticRegressionParams.setThreshold$(this, value);
    }

    @Override
    public double getThreshold() {
        return LogisticRegressionParams.getThreshold$(this);
    }

    @Override
    public LogisticRegressionModel setThresholds(double[] value) {
        return (LogisticRegressionModel)LogisticRegressionParams.setThresholds$(this, value);
    }

    @Override
    public double[] getThresholds() {
        return LogisticRegressionParams.getThresholds$(this);
    }

    private Function1<Vector, Object> margin() {
        return this.margin;
    }

    private Function1<Vector, Vector> margins() {
        return this.margins;
    }

    private Function1<Vector, Object> score() {
        return this.score;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    @Override
    public LogisticRegressionTrainingSummary summary() {
        return (LogisticRegressionTrainingSummary)HasTrainingSummary.summary$(this);
    }

    public BinaryLogisticRegressionTrainingSummary binarySummary() {
        BinaryLogisticRegressionTrainingSummary binaryLogisticRegressionTrainingSummary;
        LogisticRegressionTrainingSummary logisticRegressionTrainingSummary = this.summary();
        if (!(logisticRegressionTrainingSummary instanceof BinaryLogisticRegressionTrainingSummary)) {
            throw new RuntimeException(new StringBuilder(53).append("Cannot create a binary summary for a non-binary model").append(new StringBuilder(35).append("(numClasses=").append(this.numClasses()).append("), use summary instead.").toString()).toString());
        }
        BinaryLogisticRegressionTrainingSummary binaryLogisticRegressionTrainingSummary2 = binaryLogisticRegressionTrainingSummary = (BinaryLogisticRegressionTrainingSummary)logisticRegressionTrainingSummary;
        return binaryLogisticRegressionTrainingSummary2;
    }

    public LogisticRegressionSummary evaluate(Dataset<?> dataset) {
        String weightColName = !this.isDefined(this.weightCol()) ? "weightCol" : this.$(this.weightCol());
        Tuple3 tuple3 = this.findSummaryModel();
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        ProbabilisticClassificationModel summaryModel = (ProbabilisticClassificationModel)tuple3._1();
        String probabilityColName = (String)tuple3._2();
        String predictionColName = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)summaryModel, (Object)probabilityColName, (Object)predictionColName);
        Tuple3 tuple33 = tuple32;
        ProbabilisticClassificationModel summaryModel2 = (ProbabilisticClassificationModel)tuple33._1();
        String probabilityColName2 = (String)tuple33._2();
        String predictionColName2 = (String)tuple33._3();
        return this.numClasses() > 2 ? new LogisticRegressionSummaryImpl(summaryModel2.transform(dataset), probabilityColName2, predictionColName2, this.$(this.labelCol()), this.$(this.featuresCol()), weightColName) : new BinaryLogisticRegressionSummaryImpl(summaryModel2.transform(dataset), probabilityColName2, predictionColName2, this.$(this.labelCol()), this.$(this.featuresCol()), weightColName);
    }

    @Override
    public double predict(Vector features) {
        return this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial() ? super.predict(features) : (BoxesRunTime.unboxToDouble((Object)this.score().apply((Object)features)) > this._binaryThresholds()[0] ? 1.0 : 0.0);
    }

    @Override
    public Vector raw2probabilityInPlace(Vector rawPrediction) {
        DenseVector denseVector;
        Vector vector = rawPrediction;
        if (vector instanceof DenseVector) {
            denseVector = (DenseVector)vector;
            double[] values = denseVector.values();
            if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) {
                Utils$.MODULE$.softmax(values);
            } else {
                values[0] = 1.0 / (1.0 + scala.math.package$.MODULE$.exp(-values[0]));
                values[1] = 1.0 - values[0];
            }
        } else {
            if (vector instanceof SparseVector) {
                throw new RuntimeException("Unexpected error in LogisticRegressionModel: raw2probabilitiesInPlace encountered SparseVector");
            }
            throw new MatchError((Object)vector);
        }
        DenseVector denseVector2 = denseVector;
        return denseVector2;
    }

    @Override
    public Vector predictRaw(Vector features) {
        Vector vector;
        if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) {
            vector = (Vector)this.margins().apply((Object)features);
        } else {
            double m = BoxesRunTime.unboxToDouble((Object)this.margin().apply((Object)features));
            vector = Vectors$.MODULE$.dense(-m, (Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{m}));
        }
        return vector;
    }

    @Override
    public LogisticRegressionModel copy(ParamMap extra) {
        LogisticRegressionModel newModel = this.copyValues(new LogisticRegressionModel(this.uid(), this.coefficientMatrix(), this.interceptVector(), this.numClasses(), this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()), extra);
        return (LogisticRegressionModel)((Model)((Object)newModel.setSummary(this.trainingSummary()))).setParent(this.parent());
    }

    @Override
    public double raw2prediction(Vector rawPrediction) {
        return this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial() ? super.raw2prediction(rawPrediction) : (rawPrediction.apply(1) > this._binaryThresholds()[1] ? 1.0 : 0.0);
    }

    @Override
    public double probability2prediction(Vector probability) {
        return this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial() ? super.probability2prediction(probability) : (probability.apply(1) > this._binaryThresholds()[0] ? 1.0 : 0.0);
    }

    @Override
    public MLWriter write() {
        return new LogisticRegressionModelWriter(this);
    }

    @Override
    public String toString() {
        return new StringBuilder(56).append("LogisticRegressionModel: uid=").append(this.uid()).append(", numClasses=").append(this.numClasses()).append(", numFeatures=").append(this.numFeatures()).toString();
    }

    public static final /* synthetic */ double $anonfun$margin$1(LogisticRegressionModel $this, Vector features) {
        return BLAS$.MODULE$.dot(features, $this._coefficients()) + $this._intercept();
    }

    public static final /* synthetic */ double $anonfun$score$1(LogisticRegressionModel $this, Vector features) {
        double m = BoxesRunTime.unboxToDouble((Object)$this.margin().apply((Object)features));
        return 1.0 / (1.0 + scala.math.package$.MODULE$.exp(-m));
    }

    public LogisticRegressionModel(String uid, Matrix coefficientMatrix, Vector interceptVector, int numClasses, boolean isMultinomial) {
        double[] dArray;
        this.uid = uid;
        this.coefficientMatrix = coefficientMatrix;
        this.interceptVector = interceptVector;
        this.numClasses = numClasses;
        this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial = isMultinomial;
        MLWritable.$init$(this);
        HasRegParam.$init$(this);
        HasElasticNetParam.$init$(this);
        HasMaxIter.$init$(this);
        HasFitIntercept.$init$(this);
        HasTol.$init$(this);
        HasStandardization.$init$(this);
        HasWeightCol.$init$(this);
        HasThreshold.$init$(this);
        HasAggregationDepth.$init$(this);
        HasMaxBlockSizeInMB.$init$(this);
        LogisticRegressionParams.$init$(this);
        HasTrainingSummary.$init$(this);
        Predef$.MODULE$.require(coefficientMatrix.numRows() == interceptVector.size(), (Function0 & Serializable)() -> new StringBuilder(0).append("Dimension mismatch! Expected ").append(new StringBuilder(59).append("coefficientMatrix.numRows == interceptVector.size, but ").append(this.coefficientMatrix().numRows()).append(" != ").toString()).append(String.valueOf(BoxesRunTime.boxToInteger((int)this.interceptVector().size()))).toString());
        this._interceptVector = isMultinomial ? interceptVector.toDense() : null;
        double d = this._intercept = !isMultinomial ? interceptVector.apply(0) : Double.NaN;
        if (!isMultinomial) {
            double[] dArray2 = new double[2];
            dArray2[0] = 0.5;
            dArray = dArray2;
            dArray2[1] = 0.0;
        } else {
            dArray = null;
        }
        this._binaryThresholds = dArray;
        this.margin = (Function1 & Serializable)features -> BoxesRunTime.boxToDouble((double)LogisticRegressionModel.$anonfun$margin$1(this, features));
        this.margins = (Function1 & Serializable)features -> {
            void var2_2;
            DenseVector m = this._interceptVector().copy();
            BLAS$.MODULE$.gemv(1.0, this.coefficientMatrix(), features, 1.0, m);
            return var2_2;
        };
        this.score = (Function1 & Serializable)features -> BoxesRunTime.boxToDouble((double)LogisticRegressionModel.$anonfun$score$1(this, features));
        this.numFeatures = coefficientMatrix.numCols();
        Statics.releaseFence();
    }

    public LogisticRegressionModel(String uid, Vector coefficients, double intercept) {
        this(uid, (Matrix)new DenseMatrix(1, coefficients.size(), coefficients.toArray(), true), Vectors$.MODULE$.dense(intercept, (Seq)Nil$.MODULE$), 2, false);
    }

    private static class LogisticRegressionModelReader
    extends MLReader<LogisticRegressionModel> {
        private final String className = LogisticRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public LogisticRegressionModel load(String path) {
            LogisticRegressionModel logisticRegressionModel;
            DefaultParamsReader.Metadata metadata;
            block10: {
                Matrix matrix;
                Vector vector;
                int n;
                int n2;
                Object isMultinomial;
                block12: {
                    Row row;
                    block11: {
                        Some some;
                        Dataset data;
                        block7: {
                            double d;
                            int n3;
                            int n4;
                            Object coefficients;
                            block9: {
                                Row row2;
                                block8: {
                                    Some some2;
                                    metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
                                    Tuple2 tuple2 = VersionUtils$.MODULE$.majorMinorVersion(metadata.sparkVersion());
                                    if (tuple2 == null) {
                                        throw new MatchError((Object)tuple2);
                                    }
                                    int major = tuple2._1$mcI$sp();
                                    int minor = tuple2._2$mcI$sp();
                                    Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(major, minor);
                                    Tuple2.mcII.sp sp3 = sp2;
                                    int major2 = sp3._1$mcI$sp();
                                    int minor2 = sp3._2$mcI$sp();
                                    String dataPath = new Path(path, "data").toString();
                                    data = this.sparkSession().read().format("parquet").load(dataPath);
                                    if (major2 >= 2 && (major2 != 2 || minor2 != 0)) break block7;
                                    row2 = (Row)MLUtils$.MODULE$.convertVectorColumnsToML(data, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients"})).select("numClasses", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"numFeatures", "intercept", "coefficients"})).head();
                                    if (row2 == null || (some2 = Row$.MODULE$.unapplySeq(row2)).isEmpty() || some2.get() == null || ((SeqOps)some2.get()).lengthCompare(4) != 0) break block8;
                                    Object numClasses = ((SeqOps)some2.get()).apply(0);
                                    Object numFeatures = ((SeqOps)some2.get()).apply(1);
                                    Object intercept = ((SeqOps)some2.get()).apply(2);
                                    coefficients = ((SeqOps)some2.get()).apply(3);
                                    if (!(numClasses instanceof Integer)) break block8;
                                    n4 = BoxesRunTime.unboxToInt((Object)numClasses);
                                    if (!(numFeatures instanceof Integer)) break block8;
                                    n3 = BoxesRunTime.unboxToInt((Object)numFeatures);
                                    if (!(intercept instanceof Double)) break block8;
                                    d = BoxesRunTime.unboxToDouble((Object)intercept);
                                    if (coefficients instanceof Vector) break block9;
                                }
                                throw new MatchError((Object)row2);
                            }
                            Vector vector2 = (Vector)coefficients;
                            Tuple4 tuple4 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)n4), (Object)BoxesRunTime.boxToInteger((int)n3), (Object)BoxesRunTime.boxToDouble((double)d), (Object)vector2);
                            Tuple4 tuple42 = tuple4;
                            int numClasses = BoxesRunTime.unboxToInt((Object)tuple42._1());
                            int numFeatures = BoxesRunTime.unboxToInt((Object)tuple42._2());
                            double intercept = BoxesRunTime.unboxToDouble((Object)tuple42._3());
                            Vector coefficients2 = (Vector)tuple42._4();
                            DenseMatrix coefficientMatrix = new DenseMatrix(1, coefficients2.size(), coefficients2.toArray(), true);
                            Vector interceptVector = Vectors$.MODULE$.dense(intercept, (Seq)Nil$.MODULE$);
                            logisticRegressionModel = new LogisticRegressionModel(metadata.uid(), (Matrix)coefficientMatrix, interceptVector, numClasses, false);
                            break block10;
                        }
                        row = (Row)data.select("numClasses", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"numFeatures", "interceptVector", "coefficientMatrix", "isMultinomial"})).head();
                        if (row == null || (some = Row$.MODULE$.unapplySeq(row)).isEmpty() || some.get() == null || ((SeqOps)some.get()).lengthCompare(5) != 0) break block11;
                        Object numClasses = ((SeqOps)some.get()).apply(0);
                        Object numFeatures = ((SeqOps)some.get()).apply(1);
                        Object interceptVector = ((SeqOps)some.get()).apply(2);
                        Object coefficientMatrix = ((SeqOps)some.get()).apply(3);
                        isMultinomial = ((SeqOps)some.get()).apply(4);
                        if (!(numClasses instanceof Integer)) break block11;
                        n2 = BoxesRunTime.unboxToInt((Object)numClasses);
                        if (!(numFeatures instanceof Integer)) break block11;
                        n = BoxesRunTime.unboxToInt((Object)numFeatures);
                        if (!(interceptVector instanceof Vector)) break block11;
                        vector = (Vector)interceptVector;
                        if (!(coefficientMatrix instanceof Matrix)) break block11;
                        matrix = (Matrix)coefficientMatrix;
                        if (isMultinomial instanceof Boolean) break block12;
                    }
                    throw new MatchError((Object)row);
                }
                boolean bl = BoxesRunTime.unboxToBoolean((Object)isMultinomial);
                Tuple5 tuple5 = new Tuple5((Object)BoxesRunTime.boxToInteger((int)n2), (Object)BoxesRunTime.boxToInteger((int)n), (Object)vector, (Object)matrix, (Object)BoxesRunTime.boxToBoolean((boolean)bl));
                Tuple5 tuple52 = tuple5;
                int numClasses = BoxesRunTime.unboxToInt((Object)tuple52._1());
                int numFeatures = BoxesRunTime.unboxToInt((Object)tuple52._2());
                Vector interceptVector = (Vector)tuple52._3();
                Matrix coefficientMatrix = (Matrix)tuple52._4();
                boolean isMultinomial2 = BoxesRunTime.unboxToBoolean((Object)tuple52._5());
                logisticRegressionModel = new LogisticRegressionModel(metadata.uid(), coefficientMatrix, interceptVector, numClasses, isMultinomial2);
            }
            LogisticRegressionModel model = logisticRegressionModel;
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class LogisticRegressionModelWriter
    extends MLWriter {
        private volatile LogisticRegressionModel$LogisticRegressionModelWriter$Data$ Data$module;
        private final LogisticRegressionModel instance;

        private LogisticRegressionModel$LogisticRegressionModelWriter$Data$ Data() {
            if (this.Data$module == null) {
                this.Data$lzycompute$1();
            }
            return this.Data$module;
        }

        @Override
        public void saveImpl(String path) {
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sc(), DefaultParamsWriter$.MODULE$.saveMetadata$default$4(), DefaultParamsWriter$.MODULE$.saveMetadata$default$5());
            Data data = new Data(this, this.instance.numClasses(), this.instance.numFeatures(), this.instance.interceptVector(), this.instance.coefficientMatrix(), this.instance.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial());
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(LogisticRegressionModelWriter.class.getClassLoader());
            public final class Org_apache_spark_ml_classification_LogisticRegressionModel$LogisticRegressionModelWriter$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.classification.LogisticRegressionModel.LogisticRegressionModelWriter")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.classification.LogisticRegressionModel.LogisticRegressionModelWriter"), "Data"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_ml_classification_LogisticRegressionModel$LogisticRegressionModelWriter$$typecreator1$1(LogisticRegressionModelWriter $outer) {
                }
            }
            this.sparkSession().createDataFrame((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Data[]{data})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_LogisticRegressionModel$LogisticRegressionModelWriter$$typecreator1$1(null))).repartition(1).write().parquet(dataPath);
        }

        private final void Data$lzycompute$1() {
            LogisticRegressionModelWriter logisticRegressionModelWriter = this;
            synchronized (logisticRegressionModelWriter) {
                if (this.Data$module == null) {
                    this.Data$module = new LogisticRegressionModel$LogisticRegressionModelWriter$Data$(this);
                }
            }
        }

        public LogisticRegressionModelWriter(LogisticRegressionModel instance) {
            this.instance = instance;
        }

        private class Data
        implements Product,
        Serializable {
            private final int numClasses;
            private final int numFeatures;
            private final Vector interceptVector;
            private final Matrix coefficientMatrix;
            private final boolean isMultinomial;
            public final /* synthetic */ LogisticRegressionModelWriter $outer;

            public Iterator<String> productElementNames() {
                return Product.productElementNames$((Product)this);
            }

            public int numClasses() {
                return this.numClasses;
            }

            public int numFeatures() {
                return this.numFeatures;
            }

            public Vector interceptVector() {
                return this.interceptVector;
            }

            public Matrix coefficientMatrix() {
                return this.coefficientMatrix;
            }

            public boolean isMultinomial() {
                return this.isMultinomial;
            }

            public Data copy(int numClasses, int numFeatures, Vector interceptVector, Matrix coefficientMatrix, boolean isMultinomial) {
                return new Data(this.org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$Data$$$outer(), numClasses, numFeatures, interceptVector, coefficientMatrix, isMultinomial);
            }

            public int copy$default$1() {
                return this.numClasses();
            }

            public int copy$default$2() {
                return this.numFeatures();
            }

            public Vector copy$default$3() {
                return this.interceptVector();
            }

            public Matrix copy$default$4() {
                return this.coefficientMatrix();
            }

            public boolean copy$default$5() {
                return this.isMultinomial();
            }

            public String productPrefix() {
                return "Data";
            }

            public int productArity() {
                return 5;
            }

            public Object productElement(int x$1) {
                Object object;
                int n = x$1;
                switch (n) {
                    case 0: {
                        object = BoxesRunTime.boxToInteger((int)this.numClasses());
                        break;
                    }
                    case 1: {
                        object = BoxesRunTime.boxToInteger((int)this.numFeatures());
                        break;
                    }
                    case 2: {
                        object = this.interceptVector();
                        break;
                    }
                    case 3: {
                        object = this.coefficientMatrix();
                        break;
                    }
                    case 4: {
                        object = BoxesRunTime.boxToBoolean((boolean)this.isMultinomial());
                        break;
                    }
                    default: {
                        object = Statics.ioobe((int)x$1);
                        break;
                    }
                }
                return object;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Data;
            }

            public String productElementName(int x$1) {
                String string;
                int n = x$1;
                switch (n) {
                    case 0: {
                        string = "numClasses";
                        break;
                    }
                    case 1: {
                        string = "numFeatures";
                        break;
                    }
                    case 2: {
                        string = "interceptVector";
                        break;
                    }
                    case 3: {
                        string = "coefficientMatrix";
                        break;
                    }
                    case 4: {
                        string = "isMultinomial";
                        break;
                    }
                    default: {
                        string = (String)Statics.ioobe((int)x$1);
                        break;
                    }
                }
                return string;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
                n = Statics.mix((int)n, (int)this.numClasses());
                n = Statics.mix((int)n, (int)this.numFeatures());
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.interceptVector()));
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.coefficientMatrix()));
                n = Statics.mix((int)n, (int)(this.isMultinomial() ? 1231 : 1237));
                return Statics.finalizeHash((int)n, (int)5);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Data)) return false;
                if (((Data)object).org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$Data$$$outer() != this.org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$Data$$$outer()) return false;
                boolean bl = true;
                if (!bl) return false;
                Data data = (Data)x$1;
                if (this.numClasses() != data.numClasses()) return false;
                if (this.numFeatures() != data.numFeatures()) return false;
                if (this.isMultinomial() != data.isMultinomial()) return false;
                Vector vector = this.interceptVector();
                Vector vector2 = data.interceptVector();
                if (vector == null) {
                    if (vector2 != null) {
                        return false;
                    }
                } else if (!vector.equals(vector2)) return false;
                Matrix matrix = this.coefficientMatrix();
                Matrix matrix2 = data.coefficientMatrix();
                if (matrix == null) {
                    if (matrix2 != null) {
                        return false;
                    }
                } else if (!matrix.equals(matrix2)) return false;
                if (!data.canEqual(this)) return false;
                return true;
            }

            public /* synthetic */ LogisticRegressionModelWriter org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$Data$$$outer() {
                return this.$outer;
            }

            public Data(LogisticRegressionModelWriter $outer, int numClasses, int numFeatures, Vector interceptVector, Matrix coefficientMatrix, boolean isMultinomial) {
                this.numClasses = numClasses;
                this.numFeatures = numFeatures;
                this.interceptVector = interceptVector;
                this.coefficientMatrix = coefficientMatrix;
                this.isMultinomial = isMultinomial;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Product.$init$((Product)this);
            }
        }
    }
}

