/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import org.apache.datasketches.quantiles.DoublesAuxiliary;
import org.apache.datasketches.quantiles.DoublesSketch;

final class KolmogorovSmirnov {
    KolmogorovSmirnov() {
    }

    public static double computeKSDelta(DoublesSketch sketch1, DoublesSketch sketch2) {
        DoublesAuxiliary p = new DoublesAuxiliary(sketch1);
        DoublesAuxiliary q = new DoublesAuxiliary(sketch2);
        double[] pSamplesArr = p.auxSamplesArr_;
        double[] qSamplesArr = q.auxSamplesArr_;
        long[] pCumWtsArr = p.auxCumWtsArr_;
        long[] qCumWtsArr = q.auxCumWtsArr_;
        int pSamplesArrLen = pSamplesArr.length;
        int qSamplesArrLen = qSamplesArr.length;
        double n1 = sketch1.getN();
        double n2 = sketch2.getN();
        double deltaArea = 0.0;
        int i = 0;
        int j = 0;
        while (i < pSamplesArrLen && j < qSamplesArrLen) {
            deltaArea = Math.max(deltaArea, Math.abs((double)pCumWtsArr[i] / n1 - (double)qCumWtsArr[j] / n2));
            if (pSamplesArr[i] < qSamplesArr[j]) {
                ++i;
                continue;
            }
            if (qSamplesArr[j] < pSamplesArr[i]) {
                ++j;
                continue;
            }
            ++i;
            ++j;
        }
        deltaArea = Math.max(deltaArea, Math.abs((double)pCumWtsArr[i] / n1 - (double)qCumWtsArr[j] / n2));
        return deltaArea;
    }

    public static double computeKSThreshold(DoublesSketch sketch1, DoublesSketch sketch2, double tgtPvalue) {
        double r1 = sketch1.getRetainedItems();
        double r2 = sketch2.getRetainedItems();
        double alpha = tgtPvalue;
        double alphaFactor = Math.sqrt(-0.5 * Math.log(0.5 * alpha));
        double deltaAreaThreshold = alphaFactor * Math.sqrt((r1 + r2) / (r1 * r2));
        double eps1 = sketch1.getNormalizedRankError(false);
        double eps2 = sketch2.getNormalizedRankError(false);
        return deltaAreaThreshold + eps1 + eps2;
    }

    public static boolean kolmogorovSmirnovTest(DoublesSketch sketch1, DoublesSketch sketch2, double tgtPvalue) {
        double thresh;
        double delta = KolmogorovSmirnov.computeKSDelta(sketch1, sketch2);
        return delta > (thresh = KolmogorovSmirnov.computeKSThreshold(sketch1, sketch2, tgtPvalue));
    }
}

